/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.ColoringAttributesRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.vecmath.Color3f;

public class ColoringAttributes
extends NodeComponent {
    public static final int ALLOW_COLOR_READ = 0;
    public static final int ALLOW_COLOR_WRITE = 1;
    public static final int ALLOW_SHADE_MODEL_READ = 2;
    public static final int ALLOW_SHADE_MODEL_WRITE = 3;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int SHADE_FLAT = 2;
    public static final int SHADE_GOURAUD = 3;
    private static final int[] readCapabilities = new int[]{0, 2};

    public ColoringAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public ColoringAttributes(Color3f color, int shadeModel) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ColoringAttributesRetained)this.retained).initColor(color);
        ((ColoringAttributesRetained)this.retained).initShadeModel(shadeModel);
    }

    public ColoringAttributes(float red, float green, float blue, int shadeModel) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ColoringAttributesRetained)this.retained).initColor(red, green, blue);
        ((ColoringAttributesRetained)this.retained).initShadeModel(shadeModel);
    }

    public void setColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes0"));
        }
        if (this.isLive()) {
            ((ColoringAttributesRetained)this.retained).setColor(color);
        } else {
            ((ColoringAttributesRetained)this.retained).initColor(color);
        }
    }

    public void setColor(float r, float g, float b) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes0"));
        }
        if (this.isLive()) {
            ((ColoringAttributesRetained)this.retained).setColor(r, g, b);
        } else {
            ((ColoringAttributesRetained)this.retained).initColor(r, g, b);
        }
    }

    public void getColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes2"));
        }
        ((ColoringAttributesRetained)this.retained).getColor(color);
    }

    public void setShadeModel(int shadeModel) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes3"));
        }
        if (this.isLive()) {
            ((ColoringAttributesRetained)this.retained).setShadeModel(shadeModel);
        } else {
            ((ColoringAttributesRetained)this.retained).initShadeModel(shadeModel);
        }
    }

    public int getShadeModel() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes4"));
        }
        return ((ColoringAttributesRetained)this.retained).getShadeModel();
    }

    @Override
    void createRetained() {
        this.retained = new ColoringAttributesRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        ColoringAttributes ca = new ColoringAttributes();
        ca.duplicateNodeComponent(this);
        return ca;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        ColoringAttributesRetained attr = (ColoringAttributesRetained)originalNodeComponent.retained;
        ColoringAttributesRetained rt = (ColoringAttributesRetained)this.retained;
        Color3f c = new Color3f();
        attr.getColor(c);
        rt.initColor(c);
        rt.initShadeModel(attr.getShadeModel());
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer(this.getNamePrefix());
        str.append("org.jogamp.java3d.ColoringAttributes: ");
        String[] shadingModes = new String[]{"FASTEST", "NICEST", "SHADE_FLAT", "SHADE_GOURAUD"};
        try {
            Color3f color = new Color3f();
            this.getColor(color);
            str.append("Color=" + color);
        }
        catch (CapabilityNotSetException e) {
            str.append("Color=N/A");
        }
        try {
            str.append(" ShadeModel=" + shadingModes[this.getShadeModel()]);
        }
        catch (CapabilityNotSetException ex) {
            str.append("ShadeModel=N/A");
        }
        return new String(str);
    }
}

