/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.jogamp.java3d.Canvas3D;

class EventCatcher
implements ComponentListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
WindowListener {
    private Canvas3D canvas;
    private static final boolean DEBUG = false;
    private boolean stopped = false;
    private boolean focusEvents = false;
    private boolean keyEvents = false;
    private boolean mouseEvents = false;
    private boolean mouseMotionEvents = false;
    private boolean mouseWheelEvents = false;
    private boolean mouseListenerAdded = false;

    EventCatcher(Canvas3D c) {
        this.canvas = c;
    }

    void enableFocusEvents() {
        if (!this.focusEvents) {
            this.canvas.addFocusListener(this);
            this.focusEvents = true;
        }
    }

    void disableFocusEvents() {
        if (this.focusEvents) {
            this.canvas.removeFocusListener(this);
            this.focusEvents = false;
        }
    }

    void enableKeyEvents() {
        if (!this.keyEvents) {
            this.canvas.addKeyListener(this);
            this.keyEvents = true;
            if (!this.mouseListenerAdded) {
                this.canvas.addMouseListener(this);
                this.mouseListenerAdded = true;
            }
        }
    }

    void disableKeyEvents() {
        if (this.keyEvents) {
            this.canvas.removeKeyListener(this);
            this.keyEvents = false;
            if (!this.mouseEvents && this.mouseListenerAdded) {
                this.canvas.removeMouseListener(this);
                this.mouseListenerAdded = false;
            }
        }
    }

    void enableMouseEvents() {
        if (!this.mouseEvents) {
            this.mouseEvents = true;
            if (!this.mouseListenerAdded) {
                this.canvas.addMouseListener(this);
                this.mouseListenerAdded = true;
            }
        }
    }

    void disableMouseEvents() {
        if (this.mouseEvents) {
            this.mouseEvents = false;
            if (!this.keyEvents && this.mouseListenerAdded) {
                this.canvas.removeMouseListener(this);
                this.mouseListenerAdded = false;
            }
        }
    }

    void enableMouseMotionEvents() {
        if (!this.mouseMotionEvents) {
            this.canvas.addMouseMotionListener(this);
            this.mouseMotionEvents = true;
        }
    }

    void disableMouseMotionEvents() {
        if (this.mouseMotionEvents) {
            this.canvas.removeMouseMotionListener(this);
            this.mouseMotionEvents = false;
        }
    }

    void enableMouseWheelEvents() {
        if (!this.mouseWheelEvents) {
            this.canvas.addMouseWheelListener(this);
            this.mouseWheelEvents = true;
        }
    }

    void disableMouseWheelEvents() {
        if (this.mouseWheelEvents) {
            this.canvas.removeMouseWheelListener(this);
            this.mouseWheelEvents = false;
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(e);
            this.canvas.evaluateVisiblilty();
            this.canvas.redraw();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (e.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(e);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        if (e.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(e);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (e.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(e);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
        this.stopped = !this.stopped;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
        if (this.canvas.view != null) {
            this.canvas.view.sendEventToSoundScheduler(e);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
        if (this.canvas.view != null) {
            this.canvas.view.sendEventToSoundScheduler(e);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.canvas.sendEventToBehaviorScheduler(e);
        this.canvas.evaluateVisiblilty();
    }

    void reset() {
        this.focusEvents = false;
        this.keyEvents = false;
        this.mouseEvents = false;
        this.mouseMotionEvents = false;
        this.mouseWheelEvents = false;
        this.mouseListenerAdded = false;
        this.stopped = false;
    }
}

