/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.IndexedGeometryArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;

public abstract class IndexedGeometryArray
extends GeometryArray {
    public static final int ALLOW_COORDINATE_INDEX_READ = 9;
    public static final int ALLOW_COORDINATE_INDEX_WRITE = 10;
    public static final int ALLOW_COLOR_INDEX_READ = 11;
    public static final int ALLOW_COLOR_INDEX_WRITE = 12;
    public static final int ALLOW_NORMAL_INDEX_READ = 13;
    public static final int ALLOW_NORMAL_INDEX_WRITE = 14;
    public static final int ALLOW_TEXCOORD_INDEX_READ = 15;
    public static final int ALLOW_TEXCOORD_INDEX_WRITE = 16;
    public static final int ALLOW_VERTEX_ATTR_INDEX_READ = 24;
    public static final int ALLOW_VERTEX_ATTR_INDEX_WRITE = 25;
    private static final int[] readCapabilities = new int[]{11, 9, 13, 15, 24};

    IndexedGeometryArray() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public IndexedGeometryArray(int vertexCount, int vertexFormat, int indexCount) {
        super(vertexCount, vertexFormat);
        this.setDefaultReadCapabilities(readCapabilities);
        ((IndexedGeometryArrayRetained)this.retained).createIndexedGeometryArrayData(indexCount);
    }

    public IndexedGeometryArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int indexCount) {
        this(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, 0, null, indexCount);
    }

    public IndexedGeometryArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes);
        this.setDefaultReadCapabilities(readCapabilities);
        ((IndexedGeometryArrayRetained)this.retained).createIndexedGeometryArrayData(indexCount);
    }

    public int getIndexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray0"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getIndexCount();
    }

    public void setValidIndexCount(int validIndexCount) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray16"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setValidIndexCount(validIndexCount);
    }

    public int getValidIndexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray17"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getValidIndexCount();
    }

    public void setInitialIndexIndex(int initialIndexIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray18"));
        }
        if (initialIndexIndex < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray20"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setInitialIndexIndex(initialIndexIndex);
    }

    public int getInitialIndexIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray19"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getInitialIndexIndex();
    }

    @Override
    public void setInitialVertexIndex(int initialVertexIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialCoordIndex(int initialCoordIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialColorIndex(int initialColorIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialNormalIndex(int initialNormalIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialTexCoordIndex(int texCoordSet, int initialTexCoordIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialVertexAttrIndex(int vertexAttrNum, int initialVertexAttrIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValidVertexCount(int validVertexCount) {
        throw new UnsupportedOperationException();
    }

    public void setCoordinateIndex(int index, int coordinateIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray1"));
        }
        int format = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x2000) != 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray31"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordinateIndex(index, coordinateIndex);
    }

    public void setCoordinateIndices(int index, int[] coordinateIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray1"));
        }
        int format = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x2000) != 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray31"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordinateIndices(index, coordinateIndices);
    }

    public void setCoordIndicesRef(int[] coordIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray86"));
        }
        int format = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x2000) == 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray32"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordIndicesRef(coordIndices);
    }

    public void setColorIndex(int index, int colorIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray3"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setColorIndex(index, colorIndex);
    }

    public void setColorIndices(int index, int[] colorIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray3"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setColorIndices(index, colorIndices);
    }

    public void setNormalIndex(int index, int normalIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray5"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setNormalIndex(index, normalIndex);
    }

    public void setNormalIndices(int index, int[] normalIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray5"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setNormalIndices(index, normalIndices);
    }

    public void setTextureCoordinateIndex(int index, int texCoordIndex) {
        this.setTextureCoordinateIndex(0, index, texCoordIndex);
    }

    public void setTextureCoordinateIndex(int texCoordSet, int index, int texCoordIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray7"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setTextureCoordinateIndex(texCoordSet, index, texCoordIndex);
    }

    public void setTextureCoordinateIndices(int index, int[] texCoordIndices) {
        this.setTextureCoordinateIndices(0, index, texCoordIndices);
    }

    public void setTextureCoordinateIndices(int texCoordSet, int index, int[] texCoordIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray7"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setTextureCoordinateIndices(texCoordSet, index, texCoordIndices);
    }

    public void setVertexAttrIndex(int vertexAttrNum, int index, int vertexAttrIndex) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray28"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setVertexAttrIndex(vertexAttrNum, index, vertexAttrIndex);
    }

    public void setVertexAttrIndices(int vertexAttrNum, int index, int[] vertexAttrIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray28"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setVertexAttrIndices(vertexAttrNum, index, vertexAttrIndices);
    }

    public int getCoordinateIndex(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray9"));
        }
        int format = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x2000) != 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray31"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getCoordinateIndex(index);
    }

    public void getCoordinateIndices(int index, int[] coordinateIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray9"));
        }
        int format = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x2000) != 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray31"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getCoordinateIndices(index, coordinateIndices);
    }

    public int[] getCoordIndicesRef() {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryArray87"));
        }
        int format = ((IndexedGeometryArrayRetained)this.retained).vertexFormat;
        if ((format & 0x2000) == 0) {
            throw new IllegalStateException(J3dI18N.getString("IndexedGeometryArray32"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getCoordIndicesRef();
    }

    public int getColorIndex(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray11"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getColorIndex(index);
    }

    public void getColorIndices(int index, int[] colorIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray11"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getColorIndices(index, colorIndices);
    }

    public int getNormalIndex(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray13"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getNormalIndex(index);
    }

    public void getNormalIndices(int index, int[] normalIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray13"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getNormalIndices(index, normalIndices);
    }

    public int getTextureCoordinateIndex(int index) {
        return this.getTextureCoordinateIndex(0, index);
    }

    public int getTextureCoordinateIndex(int texCoordSet, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray15"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getTextureCoordinateIndex(texCoordSet, index);
    }

    public void getTextureCoordinateIndices(int index, int[] texCoordIndices) {
        this.getTextureCoordinateIndices(0, index, texCoordIndices);
    }

    public void getTextureCoordinateIndices(int texCoordSet, int index, int[] texCoordIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray15"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getTextureCoordinateIndices(texCoordSet, index, texCoordIndices);
    }

    public int getVertexAttrIndex(int vertexAttrNum, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray29"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getVertexAttrIndex(vertexAttrNum, index);
    }

    public void getVertexAttrIndices(int vertexAttrNum, int index, int[] vertexAttrIndices) {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray29"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getVertexAttrIndices(vertexAttrNum, index, vertexAttrIndices);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        IndexedGeometryArrayRetained ga = (IndexedGeometryArrayRetained)originalNodeComponent.retained;
        IndexedGeometryArrayRetained rt = (IndexedGeometryArrayRetained)this.retained;
        int vformat = ga.getVertexFormat();
        int[] buffer = new int[ga.getIndexCount()];
        if ((vformat & 1) != 0) {
            ga.getCoordinateIndices(0, buffer);
            rt.setCoordinateIndices(0, buffer);
        }
        if ((vformat & 0x200) == 0) {
            int i;
            if ((vformat & 2) != 0) {
                ga.getNormalIndices(0, buffer);
                rt.setNormalIndices(0, buffer);
            }
            if ((vformat & 4) != 0) {
                ga.getColorIndices(0, buffer);
                rt.setColorIndices(0, buffer);
            }
            if ((vformat & 0x1000) != 0) {
                for (i = 0; i < ga.vertexAttrCount; ++i) {
                    ga.getVertexAttrIndices(i, 0, buffer);
                    rt.setVertexAttrIndices(i, 0, buffer);
                }
            }
            if ((vformat & 0x460) != 0) {
                for (i = 0; i < ga.texCoordSetCount; ++i) {
                    ga.getTextureCoordinateIndices(i, 0, buffer);
                    rt.setTextureCoordinateIndices(i, 0, buffer);
                }
            }
        }
    }
}

