/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.LinkedPoint;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.pointdescriptor.matcher.Matcher;
import mpicbg.pointdescriptor.similarity.SimilarityMeasure;
import net.imglib2.util.Util;

public abstract class AbstractPointDescriptor<P extends Point, F extends AbstractPointDescriptor<P, F>> {
    final P basisPoint;
    final ArrayList<P> neighbors;
    final ArrayList<LinkedPoint<P>> descriptorPoints;
    SimilarityMeasure similarityMeasure;
    final Matcher matcher;
    ArrayList<PointMatch> bestPointMatchSet = null;
    final int numDimensions;
    final long id;
    protected static final AtomicLong index = new AtomicLong(0L);

    public AbstractPointDescriptor(P basisPoint, ArrayList<P> orderedNearestNeighboringPoints, SimilarityMeasure similarityMeasure, Matcher matcher) throws NoSuitablePointsException {
        this.basisPoint = basisPoint;
        this.numDimensions = basisPoint.getL().length;
        this.similarityMeasure = similarityMeasure;
        this.matcher = matcher;
        this.id = index.getAndIncrement();
        this.neighbors = orderedNearestNeighboringPoints;
        for (Point point : orderedNearestNeighboringPoints) {
            if (point.getL().length == this.numDimensions) continue;
            throw new NoSuitablePointsException("At least one of the Points<P> given as ArrayList< P > orderedNearestNeighboringPoints have a different dimensionality than the basis point.");
        }
        this.descriptorPoints = new ArrayList(this.neighbors.size());
        double[] basis = this.useWorldCoordinatesForDescriptorBuildUp() ? (double[])basisPoint.getW().clone() : (double[])basisPoint.getL().clone();
        for (Point absolute : orderedNearestNeighboringPoints) {
            double[] localCoordinates = this.useWorldCoordinatesForDescriptorBuildUp() ? (double[])absolute.getW().clone() : (double[])absolute.getL().clone();
            for (int d = 0; d < this.numDimensions; ++d) {
                int n = d;
                localCoordinates[n] = localCoordinates[n] - basis[d];
            }
            this.descriptorPoints.add(new LinkedPoint<Point>(localCoordinates, absolute));
        }
    }

    public double descriptorDistance(F pointDescriptor) {
        ArrayList<ArrayList<PointMatch>> matchesList = this.matcher.createCandidates(this, (AbstractPointDescriptor<?, ?>)pointDescriptor);
        double bestSimilarity = Double.MAX_VALUE;
        this.bestPointMatchSet = null;
        for (ArrayList<PointMatch> matches : matchesList) {
            Object fitResult = this.fitMatches(matches);
            double similarity = this.similarityMeasure.getSimilarity(matches) * this.matcher.getNormalizationFactor(matches, fitResult);
            if (!(similarity < bestSimilarity)) continue;
            bestSimilarity = similarity;
            this.bestPointMatchSet = matches;
        }
        if (this.resetWorldCoordinatesAfterMatching()) {
            this.resetWorldCoordinates();
        }
        return bestSimilarity;
    }

    public ArrayList<PointMatch> getBestPointMatchSet() {
        return this.bestPointMatchSet;
    }

    protected void resetWorldCoordinates() {
        for (Point point : this.descriptorPoints) {
            double[] l = point.getL();
            double[] w = point.getW();
            for (int d = 0; d < l.length; ++d) {
                w[d] = l[d];
            }
        }
    }

    public abstract Object fitMatches(ArrayList<PointMatch> var1);

    public abstract boolean resetWorldCoordinatesAfterMatching();

    public abstract boolean useWorldCoordinatesForDescriptorBuildUp();

    public SimilarityMeasure getSimilarityMeasure() {
        return this.similarityMeasure;
    }

    public void setSimilarityMeasure(SimilarityMeasure similarityMeasure) {
        this.similarityMeasure = similarityMeasure;
    }

    public long getId() {
        return this.id;
    }

    public P getBasisPoint() {
        return this.basisPoint;
    }

    public Point getDescriptorPoint(int index) {
        return this.descriptorPoints.get(index);
    }

    public ArrayList<P> getOrderedNearestNeighboringPoints() {
        return this.neighbors;
    }

    public int numNeighbors() {
        return this.neighbors.size();
    }

    public int numDimensions() {
        return this.numDimensions;
    }

    public String toString() {
        String out = this.getClass().getName() + "[" + this.id + "] has position: " + Util.printCoordinates((double[])this.basisPoint.getW());
        for (int i = 0; i < this.neighbors.size(); ++i) {
            out = out + "\nneighbor " + (i + 1) + " vector: " + Util.printCoordinates((double[])this.basisPoint.getW());
        }
        return out;
    }
}

