/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import java.util.ArrayList;
import mpicbg.spim.fusion.CombinedPixelWeightener;
import mpicbg.spim.registration.ViewDataBeads;

public class BlendingSimple
extends CombinedPixelWeightener<BlendingSimple> {
    final int numDimensions;
    final int numViews;
    final double[] weights;
    final double[] border;
    final double[][] scaling;
    final int[][] imageSizes;
    double percentScaling = 0.3;

    protected BlendingSimple(ArrayList<ViewDataBeads> views) {
        super(views);
        this.numViews = views.size();
        this.numDimensions = views.get(0).getNumDimensions();
        this.weights = new double[this.numViews];
        this.scaling = new double[this.numViews][this.numDimensions];
        this.border = new double[]{15.0, 15.0, 15.0};
        this.imageSizes = new int[this.numViews][];
        for (int i = 0; i < this.numViews; ++i) {
            this.imageSizes[i] = views.get(i).getImageSize();
            for (int d = 0; d < this.numDimensions; ++d) {
                this.scaling[i][d] = 1.0;
            }
            this.scaling[i][2] = views.get(i).getZStretching();
        }
    }

    public void setPercentScaling(double p) {
        this.percentScaling = p;
    }

    public void setBorder(double numPixels) {
        for (int d = 0; d < this.border.length; ++d) {
            this.border[d] = numPixels;
        }
    }

    public void setBorder(double[] numPixels) {
        for (int d = 0; d < this.border.length; ++d) {
            this.border[d] = numPixels[d];
        }
    }

    public void setBlendingRange(double ratio) {
        this.percentScaling = ratio;
    }

    @Override
    public void close() {
    }

    @Override
    public double getWeight(int view) {
        return this.weights[view];
    }

    @Override
    public void updateWeights(int[][] locations, boolean[] useView) {
        double[][] tmp = new double[locations.length][locations[0].length];
        for (int i = 0; i < locations.length; ++i) {
            for (int d = 0; d < locations[0].length; ++d) {
                tmp[i][d] = locations[i][d];
            }
        }
        this.updateWeights(tmp, useView);
    }

    @Override
    public void updateWeights(double[][] locations, boolean[] useView) {
        for (int i = 0; i < useView.length; ++i) {
            this.weights[i] = useView[i] ? BlendingSimple.computeWeight(locations[i], this.imageSizes[i], this.border, this.scaling[i], this.percentScaling) : 0.0;
        }
    }

    public static final double computeWeight(int[] location, int[] dimensions, double[] border, double[] dimensionScaling, double percentScaling) {
        double[] tmp = new double[location.length];
        for (int d = 0; d < location.length; ++d) {
            tmp[d] = location[d];
        }
        return BlendingSimple.computeWeight(tmp, dimensions, border, dimensionScaling, percentScaling);
    }

    public static final double computeWeight(double[] location, int[] dimensions, double[] border, double[] dimensionScaling, double percentScaling) {
        double minDistance = 1.0;
        for (int dim = 0; dim < location.length; ++dim) {
            double value;
            double localImgPos = location[dim];
            if (dimensionScaling != null && dimensionScaling[dim] != 0.0) {
                value = Math.max(0.0, Math.min(localImgPos - border[dim] / dimensionScaling[dim], (double)(dimensions[dim] - 1) - localImgPos - border[dim] / dimensionScaling[dim]));
                value *= dimensionScaling[dim];
            } else {
                value = Math.max(0.0, Math.min(localImgPos - border[dim], (double)(dimensions[dim] - 1) - localImgPos - border[dim]));
            }
            double imgAreaBlend = Math.round(percentScaling * 0.5 * (double)dimensions[dim] * dimensionScaling[dim]);
            value = value < imgAreaBlend ? (value /= imgAreaBlend) : 1.0;
            minDistance *= value;
        }
        if (minDistance == 1.0) {
            return 1.0;
        }
        if (minDistance == 0.0) {
            return 0.0;
        }
        return (Math.cos((1.0 - minDistance) * Math.PI) + 1.0) / 2.0;
    }
}

