/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.Modulo;
import loci.formats.meta.MetadataRetrieve;
import mpicbg.spim.io.IOFunctions;
import ome.units.quantity.Length;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.spimdata.imgloaders.LegacyLightSheetZ1ImgLoader;

public class LightSheetZ1MetaData {
    private String objective = "";
    private String calUnit = "um";
    private int rotationAxis = -1;
    private String[] channels;
    private String[] angles;
    private String[] illuminations;
    private int numT = -1;
    private int numI = -1;
    private double calX;
    private double calY;
    private double calZ;
    private double lightsheetThickness = -1.0;
    private String[] files;
    private HashMap<Integer, int[]> imageSizes;
    private int pixelType = -1;
    private int bytesPerPixel = -1;
    private String pixelTypeString = "";
    private boolean isLittleEndian;
    private IFormatReader r = null;
    private boolean applyAxis = true;

    public void setRotationAxis(int rotAxis) {
        this.rotationAxis = rotAxis;
    }

    public void setCalX(double calX) {
        this.calX = calX;
    }

    public void setCalY(double calY) {
        this.calY = calY;
    }

    public void setCalZ(double calZ) {
        this.calZ = calZ;
    }

    public void setCalUnit(String calUnit) {
        this.calUnit = calUnit;
    }

    public int numChannels() {
        return this.channels.length;
    }

    public int numAngles() {
        return this.angles.length;
    }

    public int numIlluminations() {
        return this.numI;
    }

    public int numTimepoints() {
        return this.numT;
    }

    public String objective() {
        return this.objective;
    }

    public int rotationAxis() {
        return this.rotationAxis;
    }

    public double calX() {
        return this.calX;
    }

    public double calY() {
        return this.calY;
    }

    public double calZ() {
        return this.calZ;
    }

    public String[] files() {
        return this.files;
    }

    public String[] channels() {
        return this.channels;
    }

    public String[] angles() {
        return this.angles;
    }

    public String[] illuminations() {
        return this.illuminations;
    }

    public HashMap<Integer, int[]> imageSizes() {
        return this.imageSizes;
    }

    public String calUnit() {
        return this.calUnit;
    }

    public double lightsheetThickness() {
        return this.lightsheetThickness;
    }

    public int pixelType() {
        return this.pixelType;
    }

    public int bytesPerPixel() {
        return this.bytesPerPixel;
    }

    public String pixelTypeString() {
        return this.pixelTypeString;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public IFormatReader getReader() {
        return this.r;
    }

    public String rotationAxisName() {
        if (this.rotationAxis == 0) {
            return "X";
        }
        if (this.rotationAxis == 1) {
            return "Y";
        }
        if (this.rotationAxis == 2) {
            return "Z";
        }
        return "Unknown";
    }

    public boolean allImageSizesEqual() {
        int[] size = null;
        boolean allEqual = true;
        for (int[] sizes : this.imageSizes().values()) {
            if (size == null) {
                size = (int[])sizes.clone();
                continue;
            }
            for (int d = 0; d < size.length; ++d) {
                if (size[d] == sizes[d]) continue;
                allEqual = false;
            }
        }
        return allEqual;
    }

    public boolean applyAxis() {
        return this.applyAxis;
    }

    public void setApplyAxis(boolean apply) {
        this.applyAxis = apply;
    }

    public boolean loadMetaData(File cziFile) {
        return this.loadMetaData(cziFile, false);
    }

    public boolean loadMetaData(File cziFile, boolean keepFileOpen) {
        IFormatReader r = LegacyLightSheetZ1ImgLoader.instantiateImageReader();
        if (!LegacyLightSheetZ1ImgLoader.createOMEXMLMetadata(r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            IOFunctions.println("Creating MetaDataStore failed. Stopping");
            return false;
        }
        try {
            r.setId(cziFile.getAbsolutePath());
            this.pixelType = r.getPixelType();
            this.bytesPerPixel = FormatTools.getBytesPerPixel((int)this.pixelType);
            this.pixelTypeString = FormatTools.getPixelTypeString((int)this.pixelType);
            this.isLittleEndian = r.isLittleEndian();
            if (this.pixelType != 1 && this.pixelType != 3 && this.pixelType != 5 && this.pixelType != 6) {
                IOFunctions.println("LightSheetZ1MetaData.loadMetaData(): PixelType " + this.pixelTypeString + " not supported yet. Please send me an email about this: stephan.preibisch@gmx.de - stopping.");
                r.close();
                return false;
            }
        }
        catch (Exception e) {
            IOFunctions.println("File '" + cziFile.getAbsolutePath() + "' could not be opened: " + e);
            IOFunctions.println("Stopping");
            e.printStackTrace();
            try {
                r.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        Hashtable metaData = r.getGlobalMetadata();
        int numA = r.getSeriesCount();
        System.out.println("numA: " + numA);
        this.numT = -1;
        this.numI = -1;
        int numC = -1;
        this.imageSizes = new HashMap();
        try {
            int numDigits = Integer.toString(numA).length();
            for (int a = 0; a < numA; ++a) {
                r.setSeries(a);
                IOFunctions.println("Querying information for angle/illumination #" + a);
                int w = r.getSizeX();
                int h = r.getSizeY();
                double dimZ = LightSheetZ1MetaData.getDouble(metaData, "Information|Image|V|View|SizeZ #" + StackList.leadingZeros(Integer.toString(a + 1), numDigits));
                if (Double.isNaN(dimZ)) {
                    dimZ = LightSheetZ1MetaData.getDouble(metaData, "Information|Image|V|View|SizeZ #" + Integer.toString(a + 1));
                }
                if (Double.isNaN(dimZ)) {
                    dimZ = LightSheetZ1MetaData.getDouble(metaData, "SizeZ|View|V|Image|Information #" + StackList.leadingZeros(Integer.toString(a + 1), numDigits));
                }
                if (Double.isNaN(dimZ)) {
                    dimZ = LightSheetZ1MetaData.getDouble(metaData, "SizeZ|View|V|Image|Information #" + Integer.toString(a + 1));
                }
                if (numA == 1 && Double.isNaN(dimZ)) {
                    dimZ = LightSheetZ1MetaData.getDouble(metaData, "Information|Image|SizeZ #1");
                }
                if (Double.isNaN(dimZ)) {
                    try {
                        int z = r.getSizeZ();
                        if (z <= 1) {
                            IOFunctions.println("Could not read stack size for angle " + a + ", trying the hard way later (w=" + w + ", h=" + h + ")");
                            dimZ = 0.0;
                        } else {
                            IOFunctions.println("Read stack size for angle " + a + " directly from Bioformats (w=" + w + ", h=" + h + ", d=" + z + ")");
                            dimZ = z;
                        }
                    }
                    catch (Exception e) {
                        IOFunctions.println("Could not read stack size for angle (not even bioformats directly) " + a + ", trying the hard way later (w=" + w + ", h=" + h + ")");
                        dimZ = 0.0;
                    }
                }
                int d = (int)Math.round(dimZ);
                this.imageSizes.put(a, new int[]{w, h, d});
                IOFunctions.println("(w=" + w + ", h=" + h + ", d=" + d + ")");
                if (this.numT >= 0 && this.numT != r.getSizeT()) {
                    IOFunctions.println("Number of timepoints inconsistent across angles. Stopping.");
                    r.close();
                    return false;
                }
                this.numT = r.getSizeT();
                Modulo moduloC = r.getModuloC();
                if (this.numI >= 0 && this.numI != moduloC.length()) {
                    IOFunctions.println("Number of illumination directions inconsistent across angles. Stopping.");
                    r.close();
                    return false;
                }
                this.numI = moduloC.length();
                if (numC >= 0 && numC != r.getSizeC() / moduloC.length()) {
                    IOFunctions.println("Number of channels directions inconsistent across angles. Stopping.");
                    r.close();
                    return false;
                }
                numC = r.getSizeC() / moduloC.length();
            }
        }
        catch (Exception e) {
            IOFunctions.println("An error occured parsing the main meta data: " + e + ". Stopping.");
            e.printStackTrace();
            LightSheetZ1MetaData.printMetaData(r);
            try {
                r.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        this.channels = new String[numC];
        this.angles = new String[numA];
        this.illuminations = new String[this.numI];
        this.files = r.getSeriesUsedFiles();
        boolean printMetadata = false;
        for (int i = 0; i < this.numI; ++i) {
            this.illuminations[i] = String.valueOf(i);
        }
        try {
            Object tmp = metaData.get("Experiment|AcquisitionBlock|AcquisitionModeSetup|Objective #1");
            this.objective = tmp != null ? tmp.toString() : "Unknown Objective";
        }
        catch (Exception e) {
            IOFunctions.println("An error occured parsing the objective used: " + e + "\n. Proceeding.");
            this.objective = "Unknown Objective";
            LightSheetZ1MetaData.printMetaData(r);
        }
        try {
            for (int c = 0; c < numC; ++c) {
                Object tmp = metaData.get("Information|Image|Channel|IlluminationWavelength|SinglePeak #" + (c + 1));
                String string = this.channels[c] = tmp != null ? tmp.toString() : String.valueOf(c);
                if (this.channels[c].contains("-")) {
                    this.channels[c] = this.channels[c].substring(0, this.channels[c].indexOf("-"));
                }
                if (this.channels[c].toLowerCase().startsWith("laser")) {
                    this.channels[c] = this.channels[c].substring(this.channels[c].toLowerCase().indexOf("laser") + 5, this.channels[c].length());
                }
                if (this.channels[c].toLowerCase().startsWith("laser ")) {
                    this.channels[c] = this.channels[c].substring(this.channels[c].toLowerCase().indexOf("laser ") + 6, this.channels[c].length());
                }
                this.channels[c] = this.channels[c].trim();
                if (this.channels[c].length() == 0) {
                    this.channels[c] = String.valueOf(c);
                }
                try {
                    this.channels[c] = Integer.toString((int)Double.parseDouble(this.channels[c]));
                    continue;
                }
                catch (NumberFormatException h) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            IOFunctions.println("An error occured parsing the channels: " + e + "\n. Proceeding.");
            for (int c = 0; c < numC; ++c) {
                this.channels[c] = String.valueOf(c);
            }
            printMetadata = true;
        }
        try {
            int a;
            boolean allAnglesNegative = true;
            int[] anglesTmp = new int[numA];
            for (a = 0; a < numA; ++a) {
                Object tmp = metaData.get("Information|Image|V|View|Offset #" + (a + 1));
                int n = anglesTmp[a] = tmp != null ? (int)Math.round(Double.parseDouble(tmp.toString())) : a;
                if (anglesTmp[a] <= 0) continue;
                allAnglesNegative = false;
            }
            if (allAnglesNegative) {
                a = 0;
                while (a < numA) {
                    int n = a++;
                    anglesTmp[n] = anglesTmp[n] * -1;
                }
            }
            for (a = 0; a < numA; ++a) {
                this.angles[a] = String.valueOf(anglesTmp[a]);
            }
        }
        catch (Exception e) {
            IOFunctions.println("An error occured parsing the rotation angles: " + e + "\n. Proceeding.");
            for (int a = 0; a < numA; ++a) {
                this.angles[a] = String.valueOf(a);
            }
            printMetadata = true;
        }
        try {
            Object tmp = metaData.get("Information|Image|V|AxisOfRotation #1");
            if (tmp != null && tmp.toString().trim().length() >= 5) {
                IOFunctions.println("Rotation axis: " + tmp);
                String[] axes = tmp.toString().split(" ");
                if (Double.parseDouble(axes[0]) == 1.0) {
                    this.rotationAxis = 0;
                } else if (Double.parseDouble(axes[1]) == 1.0) {
                    this.rotationAxis = 1;
                } else if (Double.parseDouble(axes[2]) == 1.0) {
                    this.rotationAxis = 2;
                } else {
                    this.rotationAxis = -1;
                    printMetadata = true;
                }
            } else {
                this.rotationAxis = -1;
                printMetadata = true;
            }
        }
        catch (Exception e) {
            IOFunctions.println("An error occured parsing the rotation axis: " + e + "\n. Proceeding.");
            this.rotationAxis = -1;
            printMetadata = true;
        }
        try {
            for (String key : metaData.keySet()) {
                if (!key.startsWith("LsmTag|Name #") || !metaData.get(key).toString().trim().equals("LightSheetThickness")) continue;
                String lookup = "LsmTag " + key.substring(key.indexOf(35), key.length());
                Object tmp = metaData.get(lookup);
                if (tmp != null) {
                    this.lightsheetThickness = Double.parseDouble(tmp.toString());
                    continue;
                }
                this.lightsheetThickness = -1.0;
            }
        }
        catch (Exception e) {
            IOFunctions.println("An error occured parsing the lightsheet thickness: " + e + "\n. Proceeding.");
            this.lightsheetThickness = -1.0;
            printMetadata = true;
        }
        try {
            MetadataRetrieve retrieve = (MetadataRetrieve)r.getMetadataStore();
            float cal = 0.0f;
            Length f = retrieve.getPixelsPhysicalSizeX(0);
            if (f != null) {
                cal = f.value().floatValue();
            }
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.println("LightSheetZ1: Warning, calibration for dimension X seems corrupted, setting to 1.");
            }
            this.calX = cal;
            f = retrieve.getPixelsPhysicalSizeY(0);
            if (f != null) {
                cal = f.value().floatValue();
            }
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.println("LightSheetZ1: Warning, calibration for dimension Y seems corrupted, setting to 1.");
            }
            this.calY = cal;
            f = retrieve.getPixelsPhysicalSizeZ(0);
            if (f != null) {
                cal = f.value().floatValue();
            }
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.println("LightSheetZ1: Warning, calibration for dimension Z seems corrupted, setting to 1.");
            }
            this.calZ = cal;
        }
        catch (Exception e) {
            IOFunctions.println("An error occured parsing the calibration: " + e + "\n. Proceeding.");
            this.calZ = 1.0;
            this.calY = 1.0;
            this.calX = 1.0;
            printMetadata = true;
        }
        if (printMetadata) {
            LightSheetZ1MetaData.printMetaData(r);
        }
        if (!keepFileOpen) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.r = r;
        }
        return true;
    }

    protected static double getDouble(Hashtable<String, Object> metadata, String key) {
        if (metadata == null) {
            throw new RuntimeException("Missing metadata while looking for: " + key);
        }
        Object o = metadata.get(key);
        if (o == null) {
            StringBuilder builder = new StringBuilder();
            for (String candidate : metadata.keySet()) {
                builder.append("\n" + candidate);
            }
            IOFunctions.println("Missing key " + key + " in LZ1 metadata");
            return Double.NaN;
        }
        return Double.parseDouble(o.toString());
    }

    public static void printMetaData(IFormatReader r) {
        LightSheetZ1MetaData.printMetaData(r.getGlobalMetadata());
    }

    public static void printMetaData(Hashtable<String, Object> metaData) {
        System.out.println("num keys: " + metaData.keySet().size());
        System.out.println("num objects: " + metaData.size());
        ArrayList<String> entries = new ArrayList<String>();
        for (String s : metaData.keySet()) {
            entries.add("'" + s + "': " + metaData.get(s));
        }
        Collections.sort(entries);
        for (String s : entries) {
            System.out.println(s);
        }
    }
}

