/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.interestpointdetection;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.util.HashMap;
import java.util.List;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.wrapper.ImgLib2;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.segmentation.InteractiveIntegral;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.realtransform.AffineTransform3D;
import spim.fiji.plugin.interestpointdetection.DifferenceOf;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.interestpointdetection.ProcessDOM;

public class DifferenceOfMean
extends DifferenceOf {
    public static int defaultR1 = 2;
    public static int defaultR2 = 3;
    public static double defaultT = 0.02;
    public static int[] defaultRadius1;
    public static int[] defaultRadius2;
    public static double[] defaultThreshold;
    public static boolean[] defaultFindMin;
    public static boolean[] defaultFindMax;
    int[] radius1;
    int[] radius2;
    double[] threshold;
    boolean[] findMin;
    boolean[] findMax;

    public DifferenceOfMean(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(spimData, viewIdsToProcess);
    }

    @Override
    public String getDescription() {
        return "Difference-of-Mean (Integral image based)";
    }

    @Override
    public DifferenceOfMean newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new DifferenceOfMean(spimData, viewIdsToProcess);
    }

    @Override
    public HashMap<ViewId, List<InterestPoint>> findInterestPoints(TimePoint t) {
        HashMap<ViewId, List<InterestPoint>> interestPoints = new HashMap<ViewId, List<InterestPoint>>();
        for (ViewDescription vd : SpimData2.getAllViewIdsForTimePointSorted(this.spimData, this.viewIdsToProcess, t)) {
            try {
                long time1 = System.currentTimeMillis();
                if (!vd.isPresent()) continue;
                Channel c = ((ViewSetup)vd.getViewSetup()).getChannel();
                AffineTransform3D correctCoordinates = new AffineTransform3D();
                RandomAccessibleInterval<net.imglib2.type.numeric.real.FloatType> input = this.openAndDownsample(this.spimData, vd, correctCoordinates);
                long time2 = System.currentTimeMillis();
                this.benchmark.openFiles += time2 - time1;
                this.preSmooth(input);
                Image img = ImgLib2.wrapFloatToImgLib1((Img)((Img)input));
                List<InterestPoint> ips = ProcessDOM.compute((Image<FloatType>)img, (Img<net.imglib2.type.numeric.real.FloatType>)((Img)input), this.radius1[c.getId()], this.radius2[c.getId()], (float)this.threshold[c.getId()], this.localization, this.imageSigmaX, this.imageSigmaY, this.imageSigmaZ, this.findMin[c.getId()], this.findMax[c.getId()], this.minIntensity, this.maxIntensity, this.limitDetections);
                img.close();
                this.correctForDownsampling(ips, correctCoordinates);
                if (this.limitDetections) {
                    ips = DifferenceOfMean.limitList(this.maxDetections, this.maxDetectionsTypeIndex, ips);
                }
                interestPoints.put((ViewId)vd, ips);
                this.benchmark.computation += System.currentTimeMillis() - time2;
            }
            catch (Exception e) {
                IOFunctions.println("An error occured (DOM): " + e);
                IOFunctions.println("Failed to segment angleId: " + ((ViewSetup)vd.getViewSetup()).getAngle().getId() + " channelId: " + ((ViewSetup)vd.getViewSetup()).getChannel().getId() + " illumId: " + ((ViewSetup)vd.getViewSetup()).getIllumination().getId() + ". Continuing with next one.");
                e.printStackTrace();
            }
        }
        return interestPoints;
    }

    @Override
    protected boolean setDefaultValues(Channel channel, int brightness) {
        int channelId = channel.getId();
        this.radius1[channelId] = defaultR1;
        this.radius2[channelId] = defaultR2;
        this.findMin[channelId] = false;
        this.findMax[channelId] = true;
        if (brightness == 0) {
            this.threshold[channelId] = 0.0025f;
        } else if (brightness == 1) {
            this.threshold[channelId] = 0.02f;
        } else if (brightness == 2) {
            this.threshold[channelId] = 0.075f;
        } else if (brightness == 3) {
            this.threshold[channelId] = 0.25;
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected boolean setAdvancedValues(Channel channel) {
        int channelId = channel.getId();
        GenericDialog gd = new GenericDialog("Advanced values for channel " + channel.getName());
        String ch = this.channelsToProcess.size() > 1 ? "_" + channel.getName().replace(' ', '_') : "";
        gd.addMessage("Advanced values for channel " + channel.getName());
        gd.addNumericField("Radius_1" + ch, (double)defaultRadius1[channelId], 0);
        gd.addNumericField("Radius_2" + ch, (double)defaultRadius2[channelId], 0);
        gd.addNumericField("Threshold" + ch, defaultThreshold[channelId], 4);
        gd.addCheckbox("Find_minima" + ch, defaultFindMin[channelId]);
        gd.addCheckbox("Find_maxima" + ch, defaultFindMax[channelId]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.radius1[channelId] = DifferenceOfMean.defaultRadius1[channelId] = (int)Math.round(gd.getNextNumber());
        this.radius2[channelId] = DifferenceOfMean.defaultRadius2[channelId] = (int)Math.round(gd.getNextNumber());
        this.threshold[channelId] = DifferenceOfMean.defaultThreshold[channelId] = gd.getNextNumber();
        this.findMin[channelId] = DifferenceOfMean.defaultFindMin[channelId] = gd.getNextBoolean();
        this.findMax[channelId] = DifferenceOfMean.defaultFindMax[channelId] = gd.getNextBoolean();
        return true;
    }

    @Override
    protected boolean setInteractiveValues(Channel channel) {
        ViewId view = this.getViewSelection("Interactive Difference-of-Mean", "Please select view to use for channel " + channel.getName(), channel);
        if (view == null) {
            return false;
        }
        ViewDescription viewDescription = ((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(view.getTimePointId(), view.getViewSetupId());
        if (!viewDescription.isPresent()) {
            IOFunctions.println("You defined the view you selected as not present at this timepoint.");
            IOFunctions.println("timepoint: " + viewDescription.getTimePoint().getName() + " angle: " + ((ViewSetup)viewDescription.getViewSetup()).getAngle().getName() + " channel: " + ((ViewSetup)viewDescription.getViewSetup()).getChannel().getName() + " illum: " + ((ViewSetup)viewDescription.getViewSetup()).getIllumination().getName());
            return false;
        }
        RandomAccessibleInterval<net.imglib2.type.numeric.real.FloatType> img = this.openAndDownsample(this.spimData, viewDescription, new AffineTransform3D());
        if (img == null) {
            IOFunctions.println("View not found: " + viewDescription);
            return false;
        }
        this.preSmooth(img);
        ImagePlus imp = ImageJFunctions.wrapFloat(img, (String)"").duplicate();
        img = null;
        imp.setDimensions(1, imp.getStackSize(), 1);
        imp.setTitle("tp: " + viewDescription.getTimePoint().getName() + " viewSetup: " + viewDescription.getViewSetupId());
        imp.show();
        imp.setSlice(imp.getStackSize() / 2);
        InteractiveIntegral ii = new InteractiveIntegral();
        int channelId = channel.getId();
        ii.setInitialRadius(Math.round(defaultRadius1[channelId]));
        ii.setThreshold((float)defaultThreshold[channelId]);
        ii.setLookForMinima(defaultFindMin[channelId]);
        ii.setLookForMaxima(defaultFindMax[channelId]);
        ii.setMinIntensityImage(this.minIntensity);
        ii.setMaxIntensityImage(this.maxIntensity);
        ii.run(null);
        while (!ii.isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        imp.close();
        if (ii.wasCanceld()) {
            return false;
        }
        this.radius1[channelId] = DifferenceOfMean.defaultRadius1[channelId] = ii.getRadius1();
        this.radius2[channelId] = DifferenceOfMean.defaultRadius2[channelId] = ii.getRadius2();
        this.threshold[channelId] = DifferenceOfMean.defaultThreshold[channelId] = ii.getThreshold();
        this.findMin[channelId] = DifferenceOfMean.defaultFindMin[channelId] = ii.getLookForMinima();
        this.findMax[channelId] = DifferenceOfMean.defaultFindMax[channelId] = ii.getLookForMaxima();
        return true;
    }

    @Override
    protected void init(int numChannels) {
        this.radius1 = new int[numChannels];
        this.radius2 = new int[numChannels];
        this.threshold = new double[numChannels];
        this.findMin = new boolean[numChannels];
        this.findMax = new boolean[numChannels];
        if (defaultRadius1 == null || defaultRadius1.length != numChannels) {
            defaultRadius1 = new int[numChannels];
            defaultRadius2 = new int[numChannels];
            defaultThreshold = new double[numChannels];
            defaultFindMin = new boolean[numChannels];
            defaultFindMax = new boolean[numChannels];
            for (int c = 0; c < numChannels; ++c) {
                DifferenceOfMean.defaultRadius1[c] = defaultR1;
                DifferenceOfMean.defaultRadius2[c] = defaultR2;
                DifferenceOfMean.defaultThreshold[c] = defaultT;
                DifferenceOfMean.defaultFindMin[c] = false;
                DifferenceOfMean.defaultFindMax[c] = true;
            }
        }
    }

    @Override
    public String getParameters(int channelId) {
        return "DOM r1=" + this.radius1[channelId] + " t=" + this.threshold[channelId] + " min=" + this.findMin[channelId] + " max=" + this.findMax[channelId] + " imageSigmaX=" + this.imageSigmaX + " imageSigmaY=" + this.imageSigmaY + " imageSigmaZ=" + this.imageSigmaZ + " downsampleXY=" + this.downsampleXY + " downsampleZ=" + this.downsampleZ + " additionalSigmaX=" + this.additionalSigmaX + " additionalSigmaY=" + this.additionalSigmaY + " additionalSigmaZ=" + this.additionalSigmaZ + " minIntensity=" + this.minIntensity + " maxIntensity=" + this.maxIntensity;
    }

    @Override
    protected void addAddtionalParameters(GenericDialog gd) {
    }

    @Override
    protected boolean queryAdditionalParameters(GenericDialog gd) {
        return true;
    }
}

