/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.interestpoint;

import bdv.BigDataViewer;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.TransformListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.sequence.ViewId;
import net.imglib2.RealLocalizable;
import net.imglib2.realtransform.AffineTransform3D;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.interestpoint.InterestPointExplorerPanel;
import spim.fiji.spimdata.explorer.interestpoint.InterestPointOverlay;
import spim.fiji.spimdata.explorer.popup.BDVPopup;
import spim.fiji.spimdata.interestpoints.CorrespondingInterestPoints;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class InterestPointTableModel
extends AbstractTableModel
implements InterestPointOverlay.InterestPointSource {
    private static final long serialVersionUID = -1263388435427674269L;
    ViewInterestPoints viewInterestPoints;
    final ArrayList<String> columnNames;
    BasicViewDescription<?> currentVD;
    final InterestPointExplorerPanel panel;
    private int selectedRow = -1;
    private int selectedCol = -1;
    final ArrayList<InterestPointOverlay.InterestPointSource> interestPointSources;
    volatile InterestPointOverlay interestPointOverlay = null;
    Collection<? extends RealLocalizable> points = new ArrayList<RealLocalizable>();

    public InterestPointTableModel(ViewInterestPoints viewInterestPoints, InterestPointExplorerPanel panel) {
        this.columnNames = new ArrayList();
        this.columnNames.add("Interest Point Label");
        this.columnNames.add("#Detections");
        this.columnNames.add("#Corresponding");
        this.columnNames.add("#Correspondences");
        this.columnNames.add("Parameters");
        this.viewInterestPoints = viewInterestPoints;
        this.currentVD = null;
        this.panel = panel;
        this.interestPointSources = new ArrayList();
        this.interestPointSources.add(this);
    }

    protected void update(ViewInterestPoints viewInterestPoints) {
        this.viewInterestPoints = viewInterestPoints;
    }

    protected ViewInterestPoints getViewInterestPoints() {
        return this.viewInterestPoints;
    }

    protected BasicViewDescription<?> getCurrentViewDescription() {
        return this.currentVD;
    }

    protected void updateViewDescription(BasicViewDescription<?> vd, boolean isFirst) {
        this.currentVD = vd;
        this.fireTableDataChanged();
        if (isFirst) {
            this.setSelected(0, 1);
        } else {
            this.setSelected(this.selectedRow, this.selectedCol);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        if (this.currentVD == null) {
            return 1;
        }
        return Math.max(1, this.viewInterestPoints.getViewInterestPointLists((ViewId)this.currentVD).getHashMap().keySet().size());
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 4;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column == 4) {
            String label = InterestPointTableModel.label(this.viewInterestPoints, this.currentVD, row);
            this.viewInterestPoints.getViewInterestPointLists((ViewId)this.currentVD).getInterestPointList(label).setParameters(value.toString());
            this.fireTableCellUpdated(row, column);
        }
    }

    public static String label(ViewInterestPoints viewInterestPoints, BasicViewDescription<?> vd, int row) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.addAll(viewInterestPoints.getViewInterestPointLists((ViewId)vd).getHashMap().keySet());
        Collections.sort(labels);
        return (String)labels.get(row);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.currentVD == null) {
            return column == 0 ? "No View Description selected" : "";
        }
        HashMap<String, InterestPointList> hash = this.viewInterestPoints.getViewInterestPointLists((ViewId)this.currentVD).getHashMap();
        if (hash.keySet().size() == 0) {
            return column == 0 ? "No interest points segmented" : "";
        }
        String label = InterestPointTableModel.label(this.viewInterestPoints, this.currentVD, row);
        if (column == 0) {
            return label;
        }
        if (column == 1) {
            return this.numDetections(this.viewInterestPoints, (ViewId)this.currentVD, label);
        }
        if (column == 2) {
            return this.numCorresponding(this.viewInterestPoints, (ViewId)this.currentVD, label);
        }
        if (column == 3) {
            return this.numCorrespondences(this.viewInterestPoints, (ViewId)this.currentVD, label);
        }
        if (column == 4) {
            return hash.get(label).getParameters();
        }
        return -1;
    }

    protected int numCorresponding(ViewInterestPoints vip, ViewId v, String label) {
        HashSet<Integer> cips = new HashSet<Integer>();
        for (CorrespondingInterestPoints c : this.panel.getCorrespondingInterestPoints(vip, v, label)) {
            cips.add(c.getDetectionId());
        }
        return cips.size();
    }

    protected int numCorrespondences(ViewInterestPoints vip, ViewId v, String label) {
        return this.panel.getCorrespondingInterestPoints(vip, v, label).size();
    }

    protected int numDetections(ViewInterestPoints vip, ViewId v, String label) {
        return this.panel.getInterestPoints(vip, v, label).size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    public boolean getState(int row, int column) {
        return row == this.selectedRow && column == this.selectedCol;
    }

    public void setSelected(int row, int col) {
        if (this.currentVD != null && BDVPopup.bdvRunning() && row >= 0 && row < this.getRowCount() && col >= 1 && col <= 2) {
            this.selectedRow = row;
            this.selectedCol = col;
            String label = InterestPointTableModel.label(this.viewInterestPoints, this.currentVD, row);
            if (col == 1) {
                this.points = this.panel.getInterestPoints(this.viewInterestPoints, (ViewId)this.currentVD, label);
            } else {
                HashMap<Integer, InterestPoint> map = new HashMap<Integer, InterestPoint>();
                for (InterestPoint ip : this.panel.getInterestPoints(this.viewInterestPoints, (ViewId)this.currentVD, label)) {
                    map.put(ip.getId(), ip);
                }
                ArrayList<? extends RealLocalizable> tmp = new ArrayList<RealLocalizable>();
                for (CorrespondingInterestPoints ip : this.panel.getCorrespondingInterestPoints(this.viewInterestPoints, (ViewId)this.currentVD, label)) {
                    tmp.add((RealLocalizable)map.get(ip.getDetectionId()));
                }
                this.points = tmp;
            }
            if (this.interestPointOverlay == null) {
                BigDataViewer bdv = ViewSetupExplorerPanel.bdvPopup().bdv;
                this.interestPointOverlay = new InterestPointOverlay(bdv.getViewer(), this.interestPointSources);
                bdv.getViewer().addRenderTransformListener((TransformListener)this.interestPointOverlay);
                bdv.getViewer().getDisplay().addOverlayRenderer((OverlayRenderer)this.interestPointOverlay);
                ViewSetupExplorerPanel.bdvPopup().updateBDV();
            }
        } else {
            this.selectedCol = -1;
            this.selectedRow = -1;
            this.points = new ArrayList<RealLocalizable>();
        }
        if (BDVPopup.bdvRunning()) {
            ViewSetupExplorerPanel.bdvPopup().updateBDV();
        }
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public int getSelectedCol() {
        return this.selectedCol;
    }

    @Override
    public Collection<? extends RealLocalizable> getLocalCoordinates(int timepointIndex) {
        if (this.currentVD != null && timepointIndex == ViewSetupExplorerPanel.getBDVTimePointIndex(this.currentVD.getTimePoint(), this.panel.viewSetupExplorer.getSpimData())) {
            return this.points;
        }
        return new ArrayList();
    }

    @Override
    public void getLocalToGlobalTransform(int timepointIndex, AffineTransform3D transform) {
        if (this.currentVD != null) {
            ViewRegistration vr = this.panel.viewSetupExplorer.getSpimData().getViewRegistrations().getViewRegistration(this.currentVD);
            vr.updateModel();
            transform.set(vr.getModel());
        }
    }
}

