/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration;

import ij.gui.GenericDialog;
import mpicbg.models.AbstractModel;
import mpicbg.models.AffineModel3D;
import mpicbg.models.IdentityModel;
import mpicbg.models.InterpolatedAffineModel3D;
import mpicbg.models.Model;
import mpicbg.models.RigidModel3D;
import mpicbg.models.TranslationModel3D;

public class TransformationModel {
    public static String[] modelChoice = new String[]{"Translation", "Rigid", "Affine"};
    public static String[] regularizationModelChoice = new String[]{"Identity", "Translation", "Rigid", "Affine"};
    public static double defaultLambda = 0.1;
    public static int defaultRegularizationModelIndex = 2;
    int modelIndex;
    int regularizedModelIndex;
    double lambda;
    boolean regularize;

    public TransformationModel(int modelIndex) {
        this(modelIndex, -1, 0.1, false);
    }

    public TransformationModel(int modelIndex, int regularizedModelIndex, double lambda, boolean regularize) {
        this.modelIndex = modelIndex;
        this.regularize = regularize;
        this.regularizedModelIndex = regularizedModelIndex;
        this.lambda = lambda;
    }

    public AbstractModel getModel() {
        Object model = this.modelIndex == 0 ? new TranslationModel3D() : (this.modelIndex == 1 ? new RigidModel3D() : new AffineModel3D());
        if (this.regularize) {
            if (this.regularizedModelIndex == 0) {
                model = new InterpolatedAffineModel3D((Model)model, (Model)new IdentityModel(), (double)((float)this.lambda));
            } else if (this.regularizedModelIndex == 1) {
                model = new InterpolatedAffineModel3D((Model)model, (Model)new TranslationModel3D(), (double)((float)this.lambda));
            } else if (this.regularizedModelIndex == 2) {
                model = new InterpolatedAffineModel3D((Model)model, (Model)new RigidModel3D(), (double)((float)this.lambda));
            } else if (this.regularizedModelIndex == 3) {
                model = new InterpolatedAffineModel3D((Model)model, (Model)new AffineModel3D(), (double)((float)this.lambda));
            }
        }
        return model;
    }

    public boolean queryRegularizedModel() {
        GenericDialog gd = new GenericDialog("Regularization Parameters");
        gd.addChoice("Model_to_regularize_with", regularizationModelChoice, regularizationModelChoice[defaultRegularizationModelIndex]);
        gd.addNumericField("Lamba", defaultLambda, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.regularize = false;
            return false;
        }
        this.regularizedModelIndex = gd.getNextChoiceIndex();
        this.lambda = gd.getNextNumber();
        this.regularize = true;
        return true;
    }

    public String getDescription() {
        String d = this.modelIndex == 0 ? "TranslationModel3D" : (this.modelIndex == 1 ? "RigidModel3D" : "AffineModel3D");
        if (this.regularize) {
            if (this.regularizedModelIndex == 0) {
                d = d + " regularized with an IdentityModel, lambda = " + this.lambda;
            } else if (this.regularizedModelIndex == 1) {
                d = d + " regularized with an TranslationModel3D, lambda = " + this.lambda;
            } else if (this.regularizedModelIndex == 2) {
                d = d + " regularized with an RigidModel3D, lambda = " + this.lambda;
            } else if (this.regularizedModelIndex == 3) {
                d = d + " regularized with an AffineModel3D, lambda = " + this.lambda;
            }
        }
        return d;
    }
}

