/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.centerofmass;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import net.imglib2.util.RealSum;
import net.imglib2.util.Util;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.interestpointregistration.Detection;
import spim.process.interestpointregistration.PairwiseMatch;

public class CenterOfMassPairwise
implements Callable<PairwiseMatch> {
    final PairwiseMatch pair;
    final String description;
    final int centerType;

    public CenterOfMassPairwise(PairwiseMatch pair, int centerType, String description) {
        this.pair = pair;
        this.centerType = centerType;
        this.description = description;
    }

    @Override
    public PairwiseMatch call() {
        double[] centerB;
        double[] centerA;
        if (this.pair.getListA().size() < 1 || this.pair.getListB().size() < 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): " + this.description + ": Not enough detections to match (1  required per list, |listA|= " + this.pair.getListA().size() + ", |listB|= " + this.pair.getListB().size() + ")");
            this.pair.setCandidates(new ArrayList<PointMatchGeneric<Detection>>());
            this.pair.setInliers(new ArrayList<PointMatchGeneric<Detection>>(), Double.NaN);
            return this.pair;
        }
        if (this.centerType == 0) {
            centerA = CenterOfMassPairwise.average(this.pair.getListA());
            centerB = CenterOfMassPairwise.average(this.pair.getListB());
        } else {
            centerA = CenterOfMassPairwise.median(this.pair.getListA());
            centerB = CenterOfMassPairwise.median(this.pair.getListB());
        }
        ArrayList<PointMatchGeneric<Detection>> inliers = new ArrayList<PointMatchGeneric<Detection>>();
        inliers.add(new PointMatchGeneric<Detection>(new Detection(0, centerA), new Detection(0, centerB)));
        this.pair.setCandidates(inliers);
        this.pair.setInliers(inliers, 0.0);
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): " + this.description + ": Center A: " + Util.printCoordinates((double[])centerA) + "Center B: " + Util.printCoordinates((double[])centerB));
        return this.pair;
    }

    private static final double[] average(List<InterestPoint> list) {
        int n = list.get(0).getL().length;
        RealSum[] sum = new RealSum[n];
        for (int d = 0; d < n; ++d) {
            sum[d] = new RealSum();
        }
        for (InterestPoint i : list) {
            double[] l = i.getL();
            for (int d = 0; d < n; ++d) {
                sum[d].add(l[d]);
            }
        }
        double[] center = new double[n];
        for (int d = 0; d < n; ++d) {
            center[d] = sum[d].getSum() / (double)list.size();
        }
        return center;
    }

    private static final double[] median(List<InterestPoint> list) {
        int n = list.get(0).getL().length;
        double[][] values = new double[n][list.size()];
        for (int j = 0; j < list.size(); ++j) {
            double[] l = list.get(j).getL();
            for (int d = 0; d < n; ++d) {
                values[d][j] = l[d];
            }
        }
        double[] center = new double[n];
        for (int d = 0; d < n; ++d) {
            center[d] = Util.median((double[])values[d]);
        }
        return center;
    }
}

