/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.EuclideanSpace;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;

public interface RealLocalizable
extends EuclideanSpace {
    default public void localize(float[] position) {
        int n = this.numDimensions();
        for (int d = 0; d < n; ++d) {
            position[d] = this.getFloatPosition(d);
        }
    }

    default public void localize(double[] position) {
        int n = this.numDimensions();
        for (int d = 0; d < n; ++d) {
            position[d] = this.getDoublePosition(d);
        }
    }

    default public void localize(RealPositionable position) {
        if (position.numDimensions() == this.numDimensions()) {
            position.setPosition(this);
        } else {
            int n = this.numDimensions();
            for (int d = 0; d < n; ++d) {
                position.setPosition(this.getDoublePosition(d), d);
            }
        }
    }

    default public double[] positionAsDoubleArray() {
        double[] out = new double[this.numDimensions()];
        this.localize(out);
        return out;
    }

    default public RealPoint positionAsRealPoint() {
        return new RealPoint(this);
    }

    default public float getFloatPosition(int d) {
        return (float)this.getDoublePosition(d);
    }

    public double getDoublePosition(int var1);
}

