/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.imglib2.loops.ClassCopier;
import net.imglib2.loops.ListUtils;

public class ClassCopyProvider<T> {
    private final Map<Object, Class<? extends T>> map = new ConcurrentHashMap<Object, Class<? extends T>>();
    private final ClassCopier<T> copier;
    private final Class<?>[] signature;

    public ClassCopyProvider(Class<? extends T> clazz, Class<T> interfaceOfClazz, Class<?> ... constructorSignature) {
        this.copier = new ClassCopier<T>(clazz, interfaceOfClazz);
        this.signature = constructorSignature == null || constructorSignature.length == 0 ? ClassCopyProvider.assumeConstructorSignature(clazz) : constructorSignature;
    }

    private static Class<?>[] assumeConstructorSignature(Class<?> clazz) {
        if (ClassCopyProvider.hasDefaultConstructor(clazz)) {
            return new Class[0];
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            return constructors[0].getParameterTypes();
        }
        if (constructors.length == 0) {
            throw new IllegalArgumentException("ClassCopyProvider: Class and it's constructor need to be public (" + clazz.getName() + ").");
        }
        throw new IllegalArgumentException("ClassCopyProvider: Please specify constructor signature.");
    }

    private static boolean hasDefaultConstructor(Class<?> clazz) {
        return ListUtils.anyMatch(constructor -> constructor.getParameterCount() == 0, clazz.getConstructors());
    }

    private Class<? extends T> classForKey(Object key) {
        return this.map.computeIfAbsent(key, k -> this.copier.copy());
    }

    public boolean matches(Object ... parameters) {
        if (parameters.length != this.signature.length) {
            return false;
        }
        for (int i = 0; i < this.signature.length; ++i) {
            if (this.signature[i].isInstance(parameters[i])) continue;
            return false;
        }
        return true;
    }

    public T newInstanceForKey(Object key, Object ... parameters) {
        try {
            return this.classForKey(key).getConstructor(this.signature).newInstance(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

