/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.neighborsearch;

import net.imglib2.IterableRealInterval;
import net.imglib2.RealCursor;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.neighborsearch.NearestNeighborSearch;

public class NearestNeighborSearchOnIterableRealInterval<T>
implements NearestNeighborSearch<T> {
    protected final IterableRealInterval<T> iterable;
    protected final int n;
    protected RealCursor<T> element = null;
    protected double squareDistance = Double.MAX_VALUE;
    protected final double[] referenceLocation;

    protected final double squareDistance(RealLocalizable query) {
        double squareSum = 0.0;
        for (int d = 0; d < this.n; ++d) {
            double distance = query.getDoublePosition(d) - this.referenceLocation[d];
            squareSum += distance * distance;
        }
        return squareSum;
    }

    public NearestNeighborSearchOnIterableRealInterval(IterableRealInterval<T> iterable) {
        this.iterable = iterable;
        this.n = iterable.numDimensions();
        this.referenceLocation = new double[this.n];
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public void search(RealLocalizable reference) {
        this.squareDistance = Double.MAX_VALUE;
        reference.localize(this.referenceLocation);
        RealCursor<T> cursor = this.iterable.localizingCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            double cursorSquareDistance = this.squareDistance(cursor);
            if (!(this.squareDistance > cursorSquareDistance)) continue;
            this.squareDistance = cursorSquareDistance;
            this.element = cursor.copy();
        }
    }

    @Override
    public RealLocalizable getPosition() {
        return this.element;
    }

    @Override
    public Sampler<T> getSampler() {
        return this.element;
    }

    @Override
    public double getSquareDistance() {
        return this.squareDistance;
    }

    @Override
    public double getDistance() {
        return Math.sqrt(this.squareDistance);
    }

    @Override
    public NearestNeighborSearchOnIterableRealInterval<T> copy() {
        NearestNeighborSearchOnIterableRealInterval<T> copy = new NearestNeighborSearchOnIterableRealInterval<T>(this.iterable);
        System.arraycopy(this.referenceLocation, 0, copy.referenceLocation, 0, this.referenceLocation.length);
        copy.element = this.element;
        copy.squareDistance = this.squareDistance;
        return copy;
    }
}

