/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.transform.Transform;
import net.imglib2.view.TransformBuilder;
import net.imglib2.view.TransformedRandomAccessible;

public class TransformView<T>
implements TransformedRandomAccessible<T> {
    protected final int n;
    protected final RandomAccessible<T> source;
    protected final Transform transformToSource;
    protected RandomAccessible<T> fullViewRandomAccessible;

    public TransformView(RandomAccessible<T> source, Transform transformToSource) {
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.n = transformToSource.numSourceDimensions();
        this.source = source;
        this.transformToSource = transformToSource;
        this.fullViewRandomAccessible = null;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public RandomAccessible<T> getSource() {
        return this.source;
    }

    @Override
    public Transform getTransformToSource() {
        return this.transformToSource;
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return TransformBuilder.getEfficientRandomAccessible(interval, this).randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess() {
        if (this.fullViewRandomAccessible == null) {
            this.fullViewRandomAccessible = TransformBuilder.getEfficientRandomAccessible(null, this);
        }
        return this.fullViewRandomAccessible.randomAccess();
    }
}

