/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader.reconstruct;

import edu.utexas.clm.reconstructreader.Utils;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructProfile;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructTranslator;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReconstructSection {
    private final int index;
    private final int oid;
    private final Document doc;
    private final ReconstructTranslator translator;
    private final ArrayList<ReconstructProfile> profiles;
    private final double mag;
    private double z;
    private double thickness;

    public ReconstructSection(ReconstructTranslator t, Document d) {
        this.translator = t;
        this.index = Integer.valueOf(d.getDocumentElement().getAttribute("index"));
        this.oid = t.nextOID();
        this.doc = d;
        this.profiles = new ArrayList();
        double m = Utils.getMag(d);
        this.mag = Double.isNaN(m) ? t.getMag() : m;
        this.z = -1.0;
        this.thickness = -1.0;
    }

    public int getOID() {
        return this.oid;
    }

    public int getIndex() {
        return this.index;
    }

    public Document getDocument() {
        return this.doc;
    }

    public double getMag() {
        return this.mag;
    }

    public void addProfile(ReconstructProfile rp) {
        this.profiles.add(rp);
    }

    public void setZ(double inZ) {
        this.z = inZ;
    }

    public double getThickness() {
        if (this.thickness < 0.0) {
            String thickStr = this.doc.getDocumentElement().getAttribute("thickness");
            this.thickness = Double.valueOf(thickStr);
        }
        return this.thickness;
    }

    public double getPixelThickness() {
        return this.thickness / this.getMag();
    }

    public void setThickness(double inThickness) {
        this.thickness = inThickness;
    }

    public void setZFromPrevious(ReconstructSection prev) {
        if (prev.getIndex() > this.getIndex()) {
            this.translator.log("Whoa! Sections not sorted!");
        }
        this.setZ(prev.getZ() + this.getThickness() * (double)(this.getIndex() - prev.getIndex()));
    }

    public double getZ() {
        return this.z;
    }

    public double getHeight() {
        NodeList imageList = this.getDocument().getElementsByTagName("Image");
        double[] wh = Utils.getReconstructImageWH(imageList.item(0));
        return Double.isNaN(wh[1]) ? this.translator.getStackHeight() : wh[1];
    }

    public void appendXML(StringBuilder sb) {
        NodeList imageList = this.doc.getElementsByTagName("Image");
        sb.append("<t2_layer oid=\"").append(this.oid).append("\"\nthickness=\"").append(this.getPixelThickness()).append("\"\nz=\"").append(this.getZ()).append("\"\ntitle=\"\"\n>\n");
        for (int i = 0; i < imageList.getLength(); ++i) {
            this.appendPatch(sb, (Element)imageList.item(i));
        }
        for (ReconstructProfile profile : this.profiles) {
            profile.appendXML(sb);
        }
        sb.append("</t2_layer>\n");
    }

    protected void appendPatch(StringBuilder sb, Element image) {
        Element rTransform = (Element)image.getParentNode();
        double[] wh = Utils.getReconstructImageWH(image);
        double h = Double.isNaN(wh[1]) ? this.translator.getStackHeight() : wh[1];
        double w = Double.isNaN(wh[0]) ? this.translator.getStackWidth() : wh[0];
        String src = image.getAttribute("src");
        AffineTransform trans = Utils.reconstructTransform(rTransform, Double.valueOf(image.getAttribute("mag")), h);
        String transString = Utils.transformToString(trans);
        sb.append("<t2_patch\noid=\"").append(this.translator.nextOID()).append("\"\nwidth=\"").append(w).append("\"\nheight=\"").append(h).append("\"\ntransform=\"").append(transString).append("\"\ntitle=\"").append(src).append("\"\nlinks=\"\"\ntype=\"0\"\nfile_path=\"").append(src).append("\"\nstyle=\"fill-opacity:1.0;stroke:#ffff00;\"\no_width=\"").append((int)w).append("\"\no_height=\"").append((int)h).append("\"\nmin=\"0.0\"\nmax=\"255.0\"\n>\n</t2_patch>\n");
    }
}

