/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Volume_Viewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Gradient
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private int height;
    private int width;
    private int wA = 100;
    private Control control;
    private int[][] lut;
    private Volume_Viewer vv;

    public Gradient(Control control, Volume_Viewer vv, int width, int height) {
        this.control = control;
        this.vv = vv;
        this.lut = vv.lookupTable.lut;
        this.width = width;
        if (width != 256) {
            height += 7;
        }
        this.height = height;
        this.setPreferredSize(new Dimension(width, height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDragged(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        if (this.width == 256) {
            if (x < 0) {
                x = 0;
            }
            if (x > 255) {
                x = 255;
            }
            this.control.rPaint = this.lut[x][0];
            this.control.gPaint = this.lut[x][1];
            this.control.bPaint = this.lut[x][2];
            this.control.indexPaint = x;
            if (this.control.LOG) {
                System.out.println(this.control.rPaint + " " + this.control.gPaint + " " + this.control.bPaint);
            }
        } else if (x >= 0 && x <= this.wA) {
            int xv = x;
            if (xv < 0) {
                xv = 0;
            }
            if (xv > this.wA) {
                xv = this.wA;
            }
            if (this.control.alphaMode == 1) {
                this.control.alphaPaint2 = xv;
            } else if (this.control.alphaMode == 2) {
                this.control.alphaPaint3 = xv;
            } else if (this.control.alphaMode == 3) {
                this.control.alphaPaint4 = xv;
            }
        }
        if (this.control.alphaMode == 1 && this.vv.gradient2 != null) {
            this.vv.gradient2.repaint();
        }
        if (this.control.alphaMode == 2 && this.vv.gradient3 != null) {
            this.vv.gradient3.repaint();
        }
        if (this.control.alphaMode == 3 && this.vv.gradient4 != null) {
            this.vv.gradient4.repaint();
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int[] pixels = new int[this.width * this.height];
        if (this.width == 256) {
            for (int x = 0; x < this.width; ++x) {
                int r = this.lut[x][0];
                int gr = this.lut[x][1];
                int b = this.lut[x][2];
                for (int y = 0; y < this.height; ++y) {
                    int pos = y * this.width + x;
                    pixels[pos] = x == 0 || x == this.width - 1 || y == 0 || y == this.height - 1 ? -8947849 : 0xFF000000 | r << 16 | gr << 8 | b;
                }
            }
        } else {
            Color color = UIManager.getColor("Panel.background");
            int cBack = color.getRGB();
            int alphaPaint = 0;
            if (this.control.alphaMode == 1) {
                alphaPaint = this.control.alphaPaint2;
            } else if (this.control.alphaMode == 2) {
                alphaPaint = this.control.alphaPaint3;
            } else if (this.control.alphaMode == 3) {
                alphaPaint = this.control.alphaPaint4;
            }
            int cc = 0xFF000000 | this.control.rPaint << 16 | this.control.gPaint << 8 | this.control.bPaint;
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = cBack;
            }
            int yc = 9;
            int xc2 = this.wA + 22;
            for (int y = 0; y < 19; ++y) {
                int dy = Math.abs(y - yc);
                for (int x = 0; x < this.width; ++x) {
                    int pos = y * this.width + x;
                    if (x >= 0 && x <= this.wA) {
                        int xv = x;
                        pixels[pos] = x == 0 || x == this.wA || y == 0 || y == 18 ? -16777216 : 0xFF000000 | 255 - xv << 16 | 255 - xv << 8 | 255 - xv;
                    }
                    if (!this.control.pickColor && this.control.alphaMode != 3 || this.control.isRGB && this.control.lutNr == 0) continue;
                    int dx = Math.abs(x - xc2);
                    int d = Math.max(dx, dy);
                    if (d == 9) {
                        pixels[pos] = -16777216;
                        continue;
                    }
                    if (d >= 9) continue;
                    pixels[pos] = cc;
                }
            }
            int apos = alphaPaint;
            if (apos < 3) {
                apos = 3;
            }
            pixels[23 * this.width + apos + 3] = -16777216;
            pixels[23 * this.width + apos + 2] = -16777216;
            pixels[23 * this.width + apos + 1] = -16777216;
            pixels[23 * this.width + apos] = -16777216;
            pixels[23 * this.width + apos - 1] = -16777216;
            pixels[23 * this.width + apos - 2] = -16777216;
            pixels[23 * this.width + apos - 3] = -16777216;
            pixels[22 * this.width + apos + 3] = -16777216;
            pixels[22 * this.width + apos + 2] = -16777216;
            pixels[22 * this.width + apos + 1] = -16777216;
            pixels[22 * this.width + apos] = -16777216;
            pixels[22 * this.width + apos - 1] = -16777216;
            pixels[22 * this.width + apos - 2] = -16777216;
            pixels[22 * this.width + apos - 3] = -16777216;
            pixels[21 * this.width + apos + 2] = -16777216;
            pixels[21 * this.width + apos + 1] = -16777216;
            pixels[21 * this.width + apos] = -16777216;
            pixels[21 * this.width + apos - 1] = -16777216;
            pixels[21 * this.width + apos - 2] = -16777216;
            pixels[20 * this.width + apos + 1] = -16777216;
            pixels[20 * this.width + apos] = -16777216;
            pixels[20 * this.width + apos - 1] = -16777216;
            pixels[19 * this.width + apos] = -16777216;
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        image.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        g2.drawImage((Image)image, 0, 0, null);
    }
}

