/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;
import org.scijava.log.IgnoreAsCallingClass;
import org.scijava.log.LogListener;
import org.scijava.log.LogMessage;
import org.scijava.log.LogSource;
import org.scijava.plugin.Parameter;
import org.scijava.prefs.PrefService;
import org.scijava.thread.ThreadService;
import org.scijava.ui.swing.console.ItemTextPane;
import org.scijava.ui.swing.console.LogFormatter;
import org.scijava.ui.swing.console.LogRecorder;
import org.scijava.ui.swing.console.LogSourcesPanel;
import org.scijava.ui.swing.console.TextFilterField;

@IgnoreAsCallingClass
public class LoggingPanel
extends JPanel
implements LogListener {
    private static final AttributeSet STYLE_ERROR = LoggingPanel.normal(new Color(200, 0, 0));
    private static final AttributeSet STYLE_WARN = LoggingPanel.normal(new Color(200, 140, 0));
    private static final AttributeSet STYLE_INFO = LoggingPanel.normal(LoggingPanel.defaultInfoColor());
    private static final AttributeSet STYLE_DEBUG = LoggingPanel.normal(new Color(0, 0, 200));
    private static final AttributeSet STYLE_TRACE = LoggingPanel.normal(Color.GRAY);
    private static final AttributeSet STYLE_OTHERS = LoggingPanel.normal(Color.GRAY);
    private final TextFilterField textFilter = new TextFilterField(" Text Search (Alt-F)");
    private final LogSourcesPanel sourcesPanel = this.initSourcesPanel();
    private final ItemTextPane textArea;
    private final JPanel textFilterPanel = new JPanel();
    private final JSplitPane splitPane = new JSplitPane(1);
    private final Set<LogSource> sources = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LogFormatter logFormatter;
    private LogRecorder recorder;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private PrefService prefService;

    public LoggingPanel(Context context) {
        this(context, null);
    }

    public LoggingPanel(Context context, String prefKey) {
        context.inject((Object)this);
        this.textArea = new ItemTextPane(context);
        this.logFormatter = new LogFormatter(context, prefKey);
        this.initGui();
        this.setRecorder(new LogRecorder());
    }

    public void setRecorder(LogRecorder recorder) {
        if (recorder != null) {
            recorder.removeObserver(this.textArea::update);
        }
        this.recorder = recorder;
        this.updateFilter();
        if (recorder != null) {
            recorder.addObservers(this.textArea::update);
        }
    }

    public void toggleSourcesPanel() {
        boolean isVisible = this.splitPane.getDividerLocation() > 10;
        this.setSourcesPanelVisible(!isVisible);
    }

    public void setSourcesPanelVisible(boolean visible) {
        if (visible) {
            this.reloadSources();
            this.splitPane.setResizeWeight(0.2);
            this.splitPane.resetToPreferredSizes();
        } else {
            this.splitPane.setResizeWeight(0.0);
            this.splitPane.setDividerLocation(0);
        }
    }

    public void setTextFilterVisible(boolean visible) {
        this.textFilterPanel.setVisible(visible);
    }

    public void copySelectionToClipboard() {
        this.textArea.copySelectionToClipboard();
    }

    public void focusTextFilter() {
        this.textFilter.getComponent().requestFocus();
    }

    public void clear() {
        this.recorder.clear();
        this.updateFilter();
    }

    @Override
    public void updateUI() {
        StyleConstants.setForeground((MutableAttributeSet)STYLE_INFO, LoggingPanel.defaultInfoColor());
        super.updateUI();
    }

    public void messageLogged(LogMessage message) {
        this.sources.add(message.source());
        this.recorder.messageLogged(message);
    }

    private static Color defaultInfoColor() {
        Color color = UIManager.getColor("TextPane.foreground");
        return color == null ? Color.BLACK : color;
    }

    private void initGui() {
        this.textFilter.setChangeListener(this::updateFilter);
        JPopupMenu menu = this.initMenu();
        JButton menuButton = new JButton("\u22ee");
        menuButton.addActionListener(a -> menu.show(menuButton, 0, menuButton.getHeight()));
        this.textFilterPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[][grow]", "[]"));
        this.textFilterPanel.add(menuButton);
        this.textFilterPanel.add((Component)this.textFilter.getComponent(), "grow");
        this.sourcesPanel.setChangeListener(this::updateFilter);
        this.sourcesPanel.setMinimumSize(new Dimension());
        this.textArea.setPopupMenu(menu);
        this.textArea.getJComponent().setPreferredSize(new Dimension(200, 100));
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.splitPane.setOneTouchExpandable(true);
        this.setSourcesPanelVisible(false);
        this.splitPane.add(this.sourcesPanel);
        this.splitPane.add(this.textArea.getJComponent());
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.add((Component)this.textFilterPanel, "grow, wrap");
        this.add((Component)this.splitPane, "grow");
        this.registerKeyStroke("alt F", "focusTextFilter", this::focusTextFilter);
    }

    private LogSourcesPanel initSourcesPanel() {
        JButton reloadButton = new JButton("Reload");
        reloadButton.addActionListener(actionEvent -> this.reloadSources());
        return new LogSourcesPanel(reloadButton);
    }

    private void reloadSources() {
        this.sourcesPanel.updateSources(this.sources);
    }

    private void registerKeyStroke(String keyStroke, String id, final Runnable action) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(keyStroke), id);
        this.getActionMap().put(id, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                action.run();
            }
        });
    }

    private JPopupMenu initMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(LoggingPanel.newMenuItem("Copy", "control C", this::copySelectionToClipboard));
        this.registerKeyStroke("control C", "copyToClipBoard", this::copySelectionToClipboard);
        menu.add(LoggingPanel.newMenuItem("Clear", "alt C", this::clear));
        this.registerKeyStroke("alt C", "clearLoggingPanel", this::clear);
        menu.add(LoggingPanel.newMenuItem("Log Sources", this::toggleSourcesPanel));
        menu.add(this.initSettingsMenu());
        return menu;
    }

    private JMenu initSettingsMenu() {
        JMenu menu = new JMenu("Settings");
        menu.add(this.checkboxItem(LogFormatter.Field.TIME, "Show time stamp"));
        menu.add(this.checkboxItem(LogFormatter.Field.SOURCE, "Show log source"));
        menu.add(this.checkboxItem(LogFormatter.Field.LEVEL, "Show log level"));
        menu.add(this.checkboxItem(LogFormatter.Field.THROWABLE, "Show exception"));
        menu.add(this.checkboxItem(LogFormatter.Field.ATTACHMENT, "Show attached data"));
        menu.addSeparator();
        menu.add(this.recordCallingClassMenuItem());
        return menu;
    }

    private JCheckBoxMenuItem recordCallingClassMenuItem() {
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.setState(false);
        menuItem.setAction(new AbstractAction("Record calling class"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggingPanel.this.recorder.setRecordCallingClass(menuItem.getState());
                LoggingPanel.this.updateFilter();
            }
        });
        return menuItem;
    }

    private JMenuItem checkboxItem(final LogFormatter.Field field, String text) {
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(text, this.logFormatter.isVisible(field));
        menuItem.setAction(new AbstractAction(text){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggingPanel.this.logFormatter.setVisible(field, menuItem.getState());
                LoggingPanel.this.updateFilter();
            }
        });
        return menuItem;
    }

    private static JMenuItem newMenuItem(String text, String keyStroke, Runnable runnable) {
        JMenuItem item = LoggingPanel.newMenuItem(text, runnable);
        item.setAccelerator(KeyStroke.getKeyStroke(keyStroke));
        return item;
    }

    private static JMenuItem newMenuItem(String text, Runnable runnable) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(actionEvent -> runnable.run());
        return item;
    }

    private void updateFilter() {
        Predicate<String> quickSearchFilter = this.textFilter.getFilter();
        Predicate<LogMessage> logLevelFilter = this.sourcesPanel.getFilter();
        Function<LogMessage, ItemTextPane.Item> transform = logMessage -> {
            if (!logLevelFilter.test((LogMessage)logMessage)) {
                return null;
            }
            ItemTextPane.Item item = new ItemTextPane.Item(LoggingPanel.getLevelStyle(logMessage.level()), this.logFormatter.format((LogMessage)logMessage));
            if (!quickSearchFilter.test(item.text())) {
                return null;
            }
            return item;
        };
        Stream<ItemTextPane.Item> stream = this.recorder.stream().map(transform).filter(Objects::nonNull);
        this.textArea.setData(stream.iterator());
    }

    private static AttributeSet getLevelStyle(int i) {
        switch (i) {
            case 1: {
                return STYLE_ERROR;
            }
            case 2: {
                return STYLE_WARN;
            }
            case 3: {
                return STYLE_INFO;
            }
            case 4: {
                return STYLE_DEBUG;
            }
            case 5: {
                return STYLE_TRACE;
            }
        }
        return STYLE_OTHERS;
    }

    private static MutableAttributeSet normal(Color color) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        StyleConstants.setForeground(style, color);
        return style;
    }

    JTextPane getTextPane() {
        return this.textArea.getTextPane();
    }
}

