/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import java.util.LinkedList;
import mpicbg.imglib.algorithm.ROIAlgorithm;
import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.RealType;

public abstract class StatisticalOperation<T extends RealType<T>>
extends ROIAlgorithm<T, T> {
    private final StructuringElement strel;
    private final LinkedList<T> statList;
    private final int[] lastPosition;
    private final LocalizableByDimCursor<T> outputCursor;
    private boolean init = false;
    private StatisticsCollectionStrategy<T> statsStrategy;

    public StatisticalOperation(Image<T> imageIn, StructuringElement strel) {
        this(imageIn, strel, (OutOfBoundsStrategyFactory<T>)null);
    }

    public StatisticalOperation(Image<T> imageIn, StructuringElement inStrel, OutOfBoundsStrategyFactory<T> inOutFactory) {
        super((RealType)imageIn.createType(), imageIn, inStrel.getDimensions(), inOutFactory);
        this.strel = inStrel;
        this.statList = new LinkedList();
        this.lastPosition = new int[this.strel.getNumDimensions()];
        this.outputCursor = this.getOutputImage().createLocalizableByDimCursor();
        this.statsStrategy = new SimpleCollectionStrategy<T>();
    }

    public void reset() {
        this.init = false;
    }

    public boolean isInit() {
        return this.init;
    }

    public StructuringElement getStrel() {
        return this.strel;
    }

    protected LinkedList<T> getList() {
        return this.statList;
    }

    public int[] getLastPosition() {
        return this.lastPosition;
    }

    @Override
    public void close() {
        super.close();
        this.outputCursor.close();
    }

    @Override
    public boolean checkInput() {
        return super.checkInput() && this.outputCursor.isActive();
    }

    @Override
    protected boolean patchOperation(int[] position, RegionOfInterestCursor<T> cursor) {
        this.statsStrategy.collectStats(this.statList, cursor, position);
        this.outputCursor.setPosition(position);
        this.statsOp(this.outputCursor);
        System.arraycopy(position, 0, this.lastPosition, 0, position.length);
        this.init = true;
        return true;
    }

    protected abstract void statsOp(LocalizableByDimCursor<T> var1);

    public class SimpleCollectionStrategy<R extends RealType<R>>
    implements StatisticsCollectionStrategy<R> {
        private final LocalizableByDimCursor<BitType> strelCursor;

        public SimpleCollectionStrategy() {
            this.strelCursor = StatisticalOperation.this.strel.createLocalizableByDimCursor();
        }

        @Override
        public void collectStats(LinkedList<R> list, RegionOfInterestCursor<R> cursor, int[] pos) {
            list.clear();
            while (cursor.hasNext()) {
                int i;
                cursor.fwd();
                this.strelCursor.setPosition(cursor);
                if (!((BitType)this.strelCursor.getType()).get()) continue;
                RealType type = (RealType)((RealType)cursor.getType()).copy();
                for (i = 0; i < list.size() && type.compareTo(list.get(i)) > 0; ++i) {
                }
                list.add(i, type.copy());
            }
        }
    }

    public static interface StatisticsCollectionStrategy<R extends RealType<R>> {
        public void collectStats(LinkedList<R> var1, RegionOfInterestCursor<R> var2, int[] var3);
    }
}

