/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.cell;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.CharArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.type.Type;

public class CellContainerFactory
extends DirectAccessContainerFactory {
    protected int[] cellSize;
    protected int standardCellSize = 10;

    public CellContainerFactory() {
    }

    public CellContainerFactory(int cellSize) {
        this.standardCellSize = cellSize;
    }

    public CellContainerFactory(int[] cellSize) {
        if (cellSize == null || cellSize.length == 0) {
            System.err.println("CellContainerFactory(): cellSize is null. Using equal cell size of 10.");
            this.cellSize = null;
            return;
        }
        for (int i = 0; i < cellSize.length; ++i) {
            if (cellSize[i] > 0) continue;
            System.err.println("CellContainerFactory(): cell size in dimension " + i + " is <= 0, using a size of " + this.standardCellSize + ".");
            cellSize[i] = this.standardCellSize;
        }
        this.cellSize = cellSize;
    }

    protected int[] checkDimensions(int[] dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            System.err.println("CellContainerFactory(): dimensionality is null. Creating a 1D cell with size 1.");
            dimensions = new int[]{1};
        }
        for (int i = 0; i < dimensions.length; ++i) {
            if (dimensions[i] > 0) continue;
            System.err.println("CellContainerFactory(): size of dimension " + i + " is <= 0, using a size of 1.");
            dimensions[i] = 1;
        }
        return dimensions;
    }

    protected int[] checkCellSize(int[] cellSize, int[] dimensions) {
        if (cellSize == null) {
            cellSize = new int[dimensions.length];
            for (int i = 0; i < cellSize.length; ++i) {
                cellSize[i] = this.standardCellSize;
            }
            return cellSize;
        }
        if (cellSize.length != dimensions.length) {
            System.err.println("CellContainerFactory(): dimensionality of image is unequal to dimensionality of cells, adjusting cell dimensionality.");
            int[] cellSizeNew = new int[dimensions.length];
            for (int i = 0; i < dimensions.length; ++i) {
                cellSizeNew[i] = i < cellSize.length ? cellSize[i] : this.standardCellSize;
            }
            return cellSizeNew;
        }
        return cellSize;
    }

    public <T extends Type<T>> DirectAccessContainer<T, BitArray> createBitInstance(int[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(this, new BitArray(1), dimensions, cellSize, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, ByteArray> createByteInstance(int[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(this, new ByteArray(1), dimensions, cellSize, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, CharArray> createCharInstance(int[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(this, new CharArray(1), dimensions, cellSize, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, DoubleArray> createDoubleInstance(int[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(this, new DoubleArray(1), dimensions, cellSize, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, FloatArray> createFloatInstance(int[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(this, new FloatArray(1), dimensions, cellSize, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, IntArray> createIntInstance(int[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(this, new IntArray(1), dimensions, cellSize, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, LongArray> createLongInstance(int[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(this, new LongArray(1), dimensions, cellSize, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, ShortArray> createShortInstance(int[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(this, new ShortArray(1), dimensions, cellSize, entitiesPerPixel);
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void printProperties() {
    }

    @Override
    public void setParameters(String configuration) {
    }
}

