/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display.imagej;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.Collection;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImagePlusAdapter;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.image.display.imagej.ImageJVirtualDisplay;
import mpicbg.imglib.image.display.imagej.ImageJVirtualStack;
import mpicbg.imglib.image.display.imagej.InverseTransformDescription;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.integer.UnsignedShortType;
import mpicbg.imglib.type.numeric.real.FloatType;

public class ImageJFunctions {
    public static final int GRAY8 = 0;
    public static final int GRAY32 = 2;
    public static final int COLOR_RGB = 4;

    public static <T extends Type<T>> ImagePlus displayAsVirtualStack(Collection<InverseTransformDescription<T>> interpolators, int type, int[] dim, int[] dimensionPositions) {
        return ImageJFunctions.displayAsVirtualStack(interpolators, type, dim, dimensionPositions, null);
    }

    public static <T extends Type<T>> ImagePlus displayAsVirtualStack(Collection<InverseTransformDescription<T>> interpolators, int type, int[] dim, int[] dimensionPositions, float[][] minMaxDim) {
        int d;
        dim = ImageJFunctions.getDim3(dim);
        if (minMaxDim == null || minMaxDim.length != 3 || minMaxDim[0].length != 2 || minMaxDim[1].length != 2 || minMaxDim[2].length != 2) {
            minMaxDim = new float[3][2];
            minMaxDim[0][0] = Float.MAX_VALUE;
            minMaxDim[1][0] = Float.MAX_VALUE;
            minMaxDim[2][0] = Float.MAX_VALUE;
            minMaxDim[0][1] = -3.4028235E38f;
            minMaxDim[1][1] = -3.4028235E38f;
            minMaxDim[2][1] = -3.4028235E38f;
            for (InverseTransformDescription<T> ti : interpolators) {
                double[] min = new double[3];
                double[] max = new double[3];
                for (d = 0; d < 3; ++d) {
                    max[d] = ti.getImage().getDimension(d);
                }
                ti.getTransform().estimateBounds(min, max);
                for (int i = 0; i < dim.length; ++i) {
                    if (dim[i] >= min.length) continue;
                    if (min[dim[i]] < (double)minMaxDim[dim[i]][0]) {
                        minMaxDim[dim[i]][0] = (float)min[dim[i]];
                    }
                    if (!(max[dim[i]] > (double)minMaxDim[dim[i]][1])) continue;
                    minMaxDim[dim[i]][1] = (float)max[dim[i]];
                }
            }
        }
        int[] dimensions = new int[]{1, 1, 1};
        for (int d2 = 0; d2 < dim.length; ++d2) {
            if (!(minMaxDim[d2][0] < Float.MAX_VALUE) || !(minMaxDim[d2][1] > -3.4028235E38f)) continue;
            dimensions[d2] = Math.round(minMaxDim[d2][1]) - Math.round(minMaxDim[d2][0]);
        }
        for (InverseTransformDescription<T> ti : interpolators) {
            float[] offset = new float[ti.getImage().getNumDimensions()];
            for (d = 0; d < dim.length; ++d) {
                offset[dim[d]] = minMaxDim[d][0];
            }
            ti.setOffset(offset);
        }
        ImageJVirtualDisplay<T> virtualDisplay = new ImageJVirtualDisplay<T>(interpolators, dimensions, type, dim, dimensionPositions);
        ImagePlus imp = new ImagePlus(virtualDisplay.toString(), virtualDisplay);
        virtualDisplay.setParent(imp);
        imp.setSlice(dim[2] / 2);
        return imp;
    }

    public static <T extends RealType<T>> Image<T> wrap(ImagePlus imp) {
        return ImagePlusAdapter.wrap(imp);
    }

    public static Image<UnsignedByteType> wrapByte(ImagePlus imp) {
        return ImagePlusAdapter.wrapByte(imp);
    }

    public static Image<UnsignedShortType> wrapShort(ImagePlus imp) {
        return ImagePlusAdapter.wrapShort(imp);
    }

    public static Image<RGBALegacyType> wrapRGBA(ImagePlus imp) {
        return ImagePlusAdapter.wrapRGBA(imp);
    }

    public static Image<FloatType> wrapFloat(ImagePlus imp) {
        return ImagePlusAdapter.wrapFloat(imp);
    }

    public static Image<FloatType> convertFloat(ImagePlus imp) {
        return ImagePlusAdapter.convertFloat(imp);
    }

    public static <T extends Type<T>> ImagePlus displayAsVirtualStack(Image<T> img) {
        if (RGBALegacyType.class.isInstance(img.createType())) {
            return new ImagePlus(img.getName(), new ImageJVirtualStack<T>(img, 4, ImageJFunctions.getDim3(ImageJFunctions.getStandardDimensions()), new int[img.getNumDimensions()]));
        }
        return new ImagePlus(img.getName(), new ImageJVirtualStack<T>(img, 2, ImageJFunctions.getDim3(ImageJFunctions.getStandardDimensions()), new int[img.getNumDimensions()]));
    }

    public static <T extends Type<T>> ImagePlus displayAsVirtualStack(Image<T> img, int type) {
        return new ImagePlus(img.getName(), new ImageJVirtualStack<T>(img, type, ImageJFunctions.getDim3(ImageJFunctions.getStandardDimensions()), new int[img.getNumDimensions()]));
    }

    public static <T extends Type<T>> ImagePlus displayAsVirtualStack(Image<T> img, int type, int[] dim) {
        return new ImagePlus(img.getName(), new ImageJVirtualStack<T>(img, type, ImageJFunctions.getDim3(dim), new int[img.getNumDimensions()]));
    }

    public static <T extends Type<T>> ImagePlus displayAsVirtualStack(Image<T> img, int[] dim) {
        if (RGBALegacyType.class.isInstance(img.createType())) {
            return new ImagePlus(img.getName(), new ImageJVirtualStack<T>(img, 4, ImageJFunctions.getDim3(dim), new int[img.getNumDimensions()]));
        }
        return new ImagePlus(img.getName(), new ImageJVirtualStack<T>(img, 2, ImageJFunctions.getDim3(dim), new int[img.getNumDimensions()]));
    }

    public static <T extends Type<T>> ImagePlus displayAsVirtualStack(Image<T> img, int type, int[] dim, int[] dimensionPositions) {
        return new ImagePlus(img.getName(), new ImageJVirtualStack<T>(img, type, ImageJFunctions.getDim3(dim), dimensionPositions));
    }

    public static <T extends Type<T>> ImagePlus show(Image<T> img) {
        img.getDisplay().setMinMax();
        ImagePlus imp = ImageJFunctions.displayAsVirtualStack(img);
        imp.show();
        return imp;
    }

    public static <T extends Type<T>> ImagePlus copyToImagePlus(Image<T> img) {
        if (RGBALegacyType.class.isInstance(img.createType())) {
            return ImageJFunctions.createImagePlus(img, img.getName(), 4, ImageJFunctions.getDim3(ImageJFunctions.getStandardDimensions()), new int[img.getNumDimensions()]);
        }
        return ImageJFunctions.createImagePlus(img, img.getName(), 2, ImageJFunctions.getDim3(ImageJFunctions.getStandardDimensions()), new int[img.getNumDimensions()]);
    }

    public static <T extends Type<T>> ImagePlus copyToImagePlus(Image<T> img, int type) {
        return ImageJFunctions.createImagePlus(img, img.getName(), type, ImageJFunctions.getDim3(ImageJFunctions.getStandardDimensions()), new int[img.getNumDimensions()]);
    }

    public static <T extends Type<T>> ImagePlus copyToImagePlus(Image<T> img, int[] dim) {
        return ImageJFunctions.createImagePlus(img, img.getName(), 2, ImageJFunctions.getDim3(dim), new int[img.getNumDimensions()]);
    }

    public static <T extends Type<T>> ImagePlus copyToImagePlus(Image<T> img, int type, int[] dim) {
        return ImageJFunctions.createImagePlus(img, img.getName(), type, ImageJFunctions.getDim3(dim), new int[img.getNumDimensions()]);
    }

    public static <T extends Type<T>> ImagePlus copyToImagePlus(Image<T> img, int type, int[] dim, int[] dimensionPositions) {
        return ImageJFunctions.createImagePlus(img, img.getName(), type, ImageJFunctions.getDim3(dim), dimensionPositions);
    }

    protected static int[] getStandardDimensions() {
        int[] dim = new int[]{0, 1, 2};
        return dim;
    }

    protected static int[] getDim3(int[] dim) {
        int[] dimReady = new int[]{-1, -1, -1};
        for (int d = 0; d < Math.min(dim.length, dimReady.length); ++d) {
            dimReady[d] = dim[d];
        }
        return dimReady;
    }

    public static <T extends Type<T>> boolean saveAsTiffs(Image<T> img, String directory, int type) {
        return ImageJFunctions.saveAsTiffs(img, directory, img.getName(), type);
    }

    public static <T extends Type<T>> boolean saveAsTiffs(Image<T> img, String directory, String name, int type) {
        Display<T> display = img.getDisplay();
        boolean everythingOK = true;
        if (directory == null) {
            directory = "";
        }
        directory = directory.replace('\\', '/');
        if ((directory = directory.trim()).length() > 0 && !directory.endsWith("/")) {
            directory = directory + "/";
        }
        int numDimensions = img.getNumDimensions();
        int[] dimensionPositions = new int[numDimensions];
        boolean dimX = false;
        boolean dimY = true;
        if (numDimensions <= 2) {
            ImageProcessor ip = ImageJFunctions.extract2DSlice(img, display, type, 0, 1, dimensionPositions);
            ImagePlus slice = new ImagePlus(name + ".tif", ip);
            FileSaver fs = new FileSaver(slice);
            everythingOK = everythingOK && fs.saveAsTiff(directory + slice.getTitle());
            slice.close();
        } else {
            int[] extraDimensions = new int[numDimensions - 2];
            int[] extraDimPos = new int[extraDimensions.length];
            for (int d = 2; d < numDimensions; ++d) {
                extraDimensions[d - 2] = img.getDimension(d);
            }
            int[] maxLengthDim = new int[extraDimensions.length];
            for (int d = 2; d < numDimensions; ++d) {
                String num = "" + (img.getDimension(d) - 1);
                maxLengthDim[d - 2] = num.length();
            }
            ArrayLocalizableCursor<FakeType> cursor = ArrayLocalizableCursor.createLinearCursor(extraDimensions);
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.getPosition(extraDimPos);
                for (int d = 2; d < numDimensions; ++d) {
                    dimensionPositions[d] = extraDimPos[d - 2];
                }
                ImageProcessor ip = ImageJFunctions.extract2DSlice(img, display, type, 0, 1, dimensionPositions);
                String desc = "";
                for (int d = 2; d < numDimensions; ++d) {
                    String descDim = "" + dimensionPositions[d];
                    while (descDim.length() < maxLengthDim[d - 2]) {
                        descDim = "0" + descDim;
                    }
                    desc = desc + "_" + descDim;
                }
                ImagePlus slice = new ImagePlus(name + desc + ".tif", ip);
                FileSaver fs = new FileSaver(slice);
                everythingOK = everythingOK && fs.saveAsTiff(directory + slice.getTitle());
                slice.close();
            }
        }
        return everythingOK;
    }

    protected static <T extends Type<T>> ImageProcessor extract2DSlice(Image<T> img, Display<T> display, int type, int dimX, int dimY, int[] dimensionPositions) {
        ColorProcessor ip;
        switch (type) {
            case 0: {
                ip = new ByteProcessor(img.getDimension(dimX), img.getDimension(dimY), ImageJVirtualStack.extractSliceByte(img, display, dimX, dimY, dimensionPositions), null);
                break;
            }
            case 4: {
                ip = new ColorProcessor(img.getDimension(dimX), img.getDimension(dimY), ImageJVirtualStack.extractSliceRGB(img, display, dimX, dimY, dimensionPositions));
                break;
            }
            default: {
                ip = new FloatProcessor(img.getDimension(dimX), img.getDimension(dimY), ImageJVirtualStack.extractSliceFloat(img, display, dimX, dimY, dimensionPositions), null);
                ip.setMinAndMax(display.getMin(), display.getMax());
            }
        }
        return ip;
    }

    protected static <T extends Type<T>> ImagePlus createImagePlus(Image<T> img, String name, int type, int[] dim, int[] dimensionPositions) {
        Display<T> display = img.getDisplay();
        int[] size = new int[]{img.getDimension(dim[0]), img.getDimension(dim[1]), img.getDimension(dim[2])};
        ImageStack stack = new ImageStack(size[0], size[1]);
        int[] dimPos = (int[])dimensionPositions.clone();
        int dimX = dim[0];
        int dimY = dim[1];
        int dimZ = dim[2];
        switch (type) {
            case 0: {
                int z;
                for (z = 0; z < size[2]; ++z) {
                    if (dimZ < img.getNumDimensions()) {
                        dimPos[dimZ] = z;
                    }
                    ByteProcessor bp = new ByteProcessor(size[0], size[1]);
                    bp.setPixels((Object)ImageJVirtualStack.extractSliceByte(img, display, dimX, dimY, dimPos));
                    stack.addSlice("" + z, (ImageProcessor)bp);
                }
                break;
            }
            case 4: {
                int z;
                for (z = 0; z < size[2]; ++z) {
                    if (dimZ < img.getNumDimensions()) {
                        dimPos[dimZ] = z;
                    }
                    ColorProcessor bp = new ColorProcessor(size[0], size[1]);
                    bp.setPixels((Object)ImageJVirtualStack.extractSliceRGB(img, display, dimX, dimY, dimPos));
                    stack.addSlice("" + z, (ImageProcessor)bp);
                }
                break;
            }
            default: {
                int z;
                for (z = 0; z < size[2]; ++z) {
                    if (dimZ < img.getNumDimensions()) {
                        dimPos[dimZ] = z;
                    }
                    FloatProcessor bp = new FloatProcessor(size[0], size[1]);
                    bp.setPixels((Object)ImageJVirtualStack.extractSliceFloat(img, display, dimX, dimY, dimPos));
                    bp.setMinAndMax(display.getMin(), display.getMax());
                    stack.addSlice("" + z, (ImageProcessor)bp);
                }
            }
        }
        ImagePlus imp = new ImagePlus(name, stack);
        return imp;
    }
}

