/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.linear;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class LinearInterpolator2DRealType<T extends RealType<T>>
extends LinearInterpolator<T> {
    final int[] tmpLocation = new int[2];

    protected LinearInterpolator2DRealType(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory, false);
        this.moveTo(this.position);
    }

    @Override
    public T getType() {
        return (T)((RealType)this.tmp2);
    }

    protected void moveTo(float x, float y) {
        this.position[0] = x;
        this.position[1] = y;
        int baseX1 = x > 0.0f ? (int)x : (int)x - 1;
        int baseX2 = y > 0.0f ? (int)y : (int)y - 1;
        this.tmpLocation[0] = baseX1;
        this.tmpLocation[1] = baseX2;
        this.cursor.moveTo(this.tmpLocation);
        float t = x - (float)baseX1;
        float u = y - (float)baseX2;
        float t1 = 1.0f - t;
        float u1 = 1.0f - u;
        float y1 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float y2 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(1);
        float y3 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float y4 = ((RealType)this.cursor.getType()).getRealFloat();
        ((RealType)this.tmp2).setReal(y1 * t1 * u1 + y2 * t * u1 + y3 * t * u + y4 * t1 * u);
    }

    @Override
    public void moveTo(float[] pos) {
        this.moveTo(pos[0], pos[1]);
    }

    @Override
    public void moveTo(double[] pos) {
        this.moveTo((float)pos[0], (float)pos[1]);
    }

    protected void setPosition(float x, float y) {
        this.position[0] = x;
        this.position[1] = y;
        int baseX1 = x > 0.0f ? (int)x : (int)x - 1;
        int baseX2 = y > 0.0f ? (int)y : (int)y - 1;
        this.tmpLocation[0] = baseX1;
        this.tmpLocation[1] = baseX2;
        this.cursor.setPosition(this.tmpLocation);
        float t = x - (float)baseX1;
        float u = y - (float)baseX2;
        float t1 = 1.0f - t;
        float u1 = 1.0f - u;
        float y1 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float y2 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(1);
        float y3 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float y4 = ((RealType)this.cursor.getType()).getRealFloat();
        ((RealType)this.tmp2).setReal(y1 * t1 * u1 + y2 * t * u1 + y3 * t * u + y4 * t1 * u);
    }

    @Override
    public void setPosition(float[] pos) {
        this.setPosition(pos[0], pos[1]);
    }

    @Override
    public void setPosition(double[] pos) {
        this.setPosition((float)pos[0], (float)pos[1]);
    }
}

