/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.linear;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class LinearInterpolator3DRealType<T extends RealType<T>>
extends LinearInterpolator<T> {
    final int[] tmpLocation = new int[3];

    protected LinearInterpolator3DRealType(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory, false);
        this.moveTo(this.position);
    }

    @Override
    public T getType() {
        return (T)((RealType)this.tmp2);
    }

    protected void moveTo(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        int baseX1 = x > 0.0f ? (int)x : (int)x - 1;
        int baseX2 = y > 0.0f ? (int)y : (int)y - 1;
        int baseX3 = z > 0.0f ? (int)z : (int)z - 1;
        this.tmpLocation[0] = baseX1;
        this.tmpLocation[1] = baseX2;
        this.tmpLocation[2] = baseX3;
        this.cursor.moveTo(this.tmpLocation);
        float y0 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float y1 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(1);
        float y2 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float y3 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(2);
        float y7 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float y6 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(1);
        float y5 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float y4 = ((RealType)this.cursor.getType()).getRealFloat();
        float t = x - (float)baseX1;
        float u = y - (float)baseX2;
        float v = z - (float)baseX3;
        float t1 = 1.0f - t;
        float u1 = 1.0f - u;
        float v1 = 1.0f - v;
        float value = t1 * u1 * v1 * y0 + t * u1 * v1 * y1 + t * u * v1 * y2 + t1 * u * v1 * y3 + t1 * u1 * v * y4 + t * u1 * v * y5 + t * u * v * y6 + t1 * u * v * y7;
        ((RealType)this.tmp2).setReal(value);
    }

    @Override
    public void moveTo(float[] pos) {
        this.moveTo(pos[0], pos[1], pos[2]);
    }

    @Override
    public void moveTo(double[] pos) {
        this.moveTo((float)pos[0], (float)pos[1], (float)pos[2]);
    }

    protected void setPosition(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        int baseX1 = x > 0.0f ? (int)x : (int)x - 1;
        int baseX2 = y > 0.0f ? (int)y : (int)y - 1;
        int baseX3 = z > 0.0f ? (int)z : (int)z - 1;
        this.tmpLocation[0] = baseX1;
        this.tmpLocation[1] = baseX2;
        this.tmpLocation[2] = baseX3;
        this.cursor.setPosition(this.tmpLocation);
        float y0 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float y1 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(1);
        float y2 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float y3 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(2);
        float y7 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float y6 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(1);
        float y5 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float y4 = ((RealType)this.cursor.getType()).getRealFloat();
        float t = x - (float)baseX1;
        float u = y - (float)baseX2;
        float v = z - (float)baseX3;
        float t1 = 1.0f - t;
        float u1 = 1.0f - u;
        float v1 = 1.0f - v;
        float value = t1 * u1 * v1 * y0 + t * u1 * v1 * y1 + t * u * v1 * y2 + t1 * u * v1 * y3 + t1 * u1 * v * y4 + t * u1 * v * y5 + t * u * v * y6 + t1 * u * v * y7;
        ((RealType)this.tmp2).setReal(value);
    }

    @Override
    public void setPosition(float[] pos) {
        this.setPosition(pos[0], pos[1], pos[2]);
    }

    @Override
    public void setPosition(double[] pos) {
        this.setPosition((float)pos[0], (float)pos[1], (float)pos[2]);
    }
}

