/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.outofbounds;

import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorExpWindowing;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.util.Util;

public class OutOfBoundsStrategyMirrorExpWindowingFactory<T extends RealType<T>>
extends OutOfBoundsStrategyFactory<T> {
    int[] fadeOutDistance = null;
    int minFadeOutDistance = 6;
    int commonFadeOutDistance = 6;
    float commonRelativeDistanceFadeOut = Float.NaN;
    float exponent = 10.0f;

    public OutOfBoundsStrategyMirrorExpWindowingFactory() {
    }

    public OutOfBoundsStrategyMirrorExpWindowingFactory(float relativeDistanceFadeOut) {
        this.commonRelativeDistanceFadeOut = relativeDistanceFadeOut;
    }

    public OutOfBoundsStrategyMirrorExpWindowingFactory(int fadeOutDistance) {
        this.commonFadeOutDistance = fadeOutDistance;
    }

    public OutOfBoundsStrategyMirrorExpWindowingFactory(int[] fadeOutDistance) {
        this.fadeOutDistance = (int[])fadeOutDistance.clone();
    }

    public void setExponent(float exponent) {
        this.exponent = exponent;
    }

    public float getExponent() {
        return this.exponent;
    }

    public void setMinFadeOutDistance(int minFadeOutDistance) {
        this.minFadeOutDistance = minFadeOutDistance;
    }

    public int getMinFadeOutDistance() {
        return this.minFadeOutDistance;
    }

    public void setCommonFadeOutDistance(int fadeOutDistance) {
        this.commonFadeOutDistance = fadeOutDistance;
    }

    public int getCommonFadeOutDistance() {
        return this.commonFadeOutDistance;
    }

    public void setCommonRelativeFadeOutDistance(float commonRelativeDistanceFadeOut) {
        this.commonRelativeDistanceFadeOut = commonRelativeDistanceFadeOut;
    }

    public float getCommonRelativeFadeOutDistance() {
        return this.commonRelativeDistanceFadeOut;
    }

    public void setFadeOutDistance(int[] fadeOutDistance) {
        this.fadeOutDistance = (int[])fadeOutDistance.clone();
    }

    public int[] getFadeOutDistance() {
        return (int[])this.fadeOutDistance.clone();
    }

    @Override
    public OutOfBoundsStrategyMirrorExpWindowing<T> createStrategy(LocalizableCursor<T> cursor) {
        if (Float.isNaN(this.commonRelativeDistanceFadeOut)) {
            if (this.fadeOutDistance == null) {
                this.fadeOutDistance = new int[cursor.getImage().getNumDimensions()];
                for (int d = 0; d < cursor.getNumDimensions(); ++d) {
                    this.fadeOutDistance[d] = Math.max(this.minFadeOutDistance, this.commonFadeOutDistance);
                }
            } else {
                for (int d = 0; d < cursor.getNumDimensions(); ++d) {
                    this.fadeOutDistance[d] = Math.max(this.minFadeOutDistance, this.fadeOutDistance[d]);
                }
            }
        } else {
            if (this.commonRelativeDistanceFadeOut <= 0.0f) {
                this.commonRelativeDistanceFadeOut = 0.1f;
            }
            this.fadeOutDistance = new int[cursor.getNumDimensions()];
            for (int d = 0; d < cursor.getNumDimensions(); ++d) {
                this.fadeOutDistance[d] = Math.max(this.minFadeOutDistance, Util.round((float)cursor.getImage().getDimension(d) * this.commonRelativeDistanceFadeOut) / 2);
            }
        }
        return new OutOfBoundsStrategyMirrorExpWindowing<T>(cursor, this.fadeOutDistance, this.exponent);
    }
}

