/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.create.kernelGauss;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Create.KernelGauss.class)
public class DefaultCreateKernelGauss<T extends ComplexType<T>>
extends AbstractUnaryFunctionOp<double[], RandomAccessibleInterval<T>>
implements Ops.Create.KernelGauss {
    @Parameter
    private T type;
    private UnaryFunctionOp<Interval, RandomAccessibleInterval<T>> createOp;

    @Override
    public void initialize() {
        this.createOp = Functions.unary(this.ops(), Ops.Create.Img.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{this.type});
    }

    @Override
    public RandomAccessibleInterval<T> calculate(double[] input) {
        double[] sigmaPixels = new double[input.length];
        long[] dims = new long[input.length];
        double[][] kernelArrays = new double[input.length][];
        for (int d = 0; d < input.length; ++d) {
            sigmaPixels[d] = input[d];
            dims[d] = Math.max(3, 2 * (int)(3.0 * sigmaPixels[d] + 0.5) + 1);
            kernelArrays[d] = Util.createGaussianKernel1DDouble((double)sigmaPixels[d], (boolean)true);
        }
        RandomAccessibleInterval<T> out = this.createOp.calculate((Interval)new FinalInterval(dims));
        Cursor cursor = Views.iterable(out).cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            double result = 1.0;
            for (int d = 0; d < input.length; ++d) {
                result *= kernelArrays[d][cursor.getIntPosition(d)];
            }
            ((ComplexType)cursor.get()).setReal(result);
        }
        return out;
    }
}

