/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class BinaryRealTypeMath {
    private BinaryRealTypeMath() {
    }

    @Plugin(type=Ops.Math.Xor.class)
    public static class Xor<I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>>
    extends AbstractBinaryComputerOp<I1, I2, O>
    implements Ops.Math.Xor {
        @Override
        public void compute(I1 input1, I2 input2, O output) {
            output.setReal((float)((long)input1.getRealDouble() ^ (long)input2.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class Subtract<I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>>
    extends AbstractBinaryComputerOp<I1, I2, O>
    implements Ops.Math.Subtract {
        @Override
        public void compute(I1 input1, I2 input2, O output) {
            output.setReal(input1.getRealDouble() - input2.getRealDouble());
        }
    }

    @Plugin(type=Ops.Math.Or.class)
    public static class Or<I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>>
    extends AbstractBinaryComputerOp<I1, I2, O>
    implements Ops.Math.Or {
        @Override
        public void compute(I1 input1, I2 input2, O output) {
            output.setReal((float)((long)input1.getRealDouble() | (long)input2.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class Multiply<I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>>
    extends AbstractBinaryComputerOp<I1, I2, O>
    implements Ops.Math.Multiply {
        @Override
        public void compute(I1 input1, I2 input2, O output) {
            output.setReal(input1.getRealDouble() * input2.getRealDouble());
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class Divide<I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>>
    extends AbstractBinaryComputerOp<I1, I2, O>
    implements Ops.Math.Divide {
        @Parameter
        private double dbzVal;

        @Override
        public void compute(I1 input1, I2 input2, O output) {
            if (input2.getRealDouble() == 0.0) {
                output.setReal(this.dbzVal);
            } else {
                output.setReal(input1.getRealDouble() / input2.getRealDouble());
            }
        }
    }

    @Plugin(type=Ops.Math.And.class)
    public static class And<I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>>
    extends AbstractBinaryComputerOp<I1, I2, O>
    implements Ops.Math.And {
        @Override
        public void compute(I1 input1, I2 input2, O output) {
            output.setReal((float)((long)input1.getRealDouble() & (long)input2.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class Add<I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>>
    extends AbstractBinaryComputerOp<I1, I2, O>
    implements Ops.Math.Add {
        @Override
        public void compute(I1 input1, I2 input2, O output) {
            output.setReal(input1.getRealDouble() + input2.getRealDouble());
        }
    }
}

