/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.Material;
import org.scijava.java3d.Node;
import org.scijava.java3d.QuadArray;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Texture;
import org.scijava.java3d.Texture2D;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Tuple3f;

public class Text2D
extends Shape3D {
    private static Hashtable metricsTable = new Hashtable();
    private float rectangleScaleFactor = 0.00390625f;
    private boolean enableTextureWrite = false;
    private Color3f color = new Color3f();
    private String fontName;
    private int fontSize;
    private int fontStyle;
    private String text;
    private int MAX_TEXTURE_DIM = 2048;
    private int vWidth;
    private int vHeight;

    public Text2D(String text, Color3f color, String fontName, int fontSize, int fontStyle) {
        this.color.set((Tuple3f)color);
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.text = text;
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.updateText2D(text, color, fontName, fontSize, fontStyle);
    }

    private Text2D() {
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Text2D t2d = new Text2D();
        t2d.color.set((Tuple3f)this.color);
        t2d.fontName = this.fontName;
        t2d.fontSize = this.fontSize;
        t2d.fontStyle = this.fontStyle;
        t2d.text = this.text;
        t2d.duplicateNode(this, forceDuplicate);
        return t2d;
    }

    public void setString(String text) {
        this.text = text;
        Texture tex = this.getAppearance().getTexture();
        if (tex == null) {
            tex = this.getAppearance().getTextureUnitState(0).getTexture();
        }
        int width = tex.getWidth();
        int height = tex.getHeight();
        int oldVW = this.vWidth;
        int oldVH = this.vHeight;
        ImageComponent imageComponent = this.setupImage(text, this.color, this.fontName, this.fontSize, this.fontStyle);
        if (imageComponent.getWidth() == width && imageComponent.getHeight() == height) {
            tex.setImage(0, imageComponent);
        } else {
            Texture2D newTex = this.setupTexture(imageComponent);
            newTex.setBoundaryModeS(tex.getBoundaryModeS());
            newTex.setBoundaryModeT(tex.getBoundaryModeT());
            newTex.setMinFilter(tex.getMinFilter());
            newTex.setMagFilter(tex.getMagFilter());
            newTex.setEnable(tex.getEnable());
            newTex.setAnisotropicFilterMode(tex.getAnisotropicFilterMode());
            newTex.setAnisotropicFilterDegree(tex.getAnisotropicFilterDegree());
            int pcount = tex.getFilter4FuncPointsCount();
            if (pcount > 0) {
                float[] weights = new float[pcount];
                tex.getFilter4Func(weights);
                newTex.setFilter4Func(weights);
            }
            Color4f c = new Color4f();
            tex.getBoundaryColor(c);
            newTex.setBoundaryColor(c);
            newTex.setUserData(tex.getUserData());
            if (this.getAppearance().getTexture() != null) {
                this.getAppearance().setTexture(newTex);
            } else {
                this.getAppearance().getTextureUnitState(0).setTexture(newTex);
            }
        }
        if (oldVH != this.vHeight || oldVW != this.vWidth) {
            QuadArray rect = this.setupGeometry(this.vWidth, this.vHeight);
            this.setGeometry(rect);
        }
    }

    private void updateText2D(String text, Color3f color, String fontName, int fontSize, int fontStyle) {
        ImageComponent imageComponent = this.setupImage(text, color, fontName, fontSize, fontStyle);
        Texture2D t2d = this.setupTexture(imageComponent);
        QuadArray rect = this.setupGeometry(this.vWidth, this.vHeight);
        this.setGeometry(rect);
        Appearance appearance = this.setupAppearance(t2d);
        this.setAppearance(appearance);
    }

    public void setRectangleScaleFactor(float newScaleFactor) {
        this.rectangleScaleFactor = newScaleFactor;
        this.updateText2D(this.text, this.color, this.fontName, this.fontSize, this.fontStyle);
    }

    public float getRectangleScaleFactor() {
        return this.rectangleScaleFactor;
    }

    private Texture2D setupTexture(ImageComponent imageComponent) {
        Texture2D t2d = new Texture2D(1, 6, imageComponent.getWidth(), imageComponent.getHeight());
        t2d.setMinFilter(3);
        t2d.setMagFilter(3);
        t2d.setImage(0, imageComponent);
        t2d.setEnable(true);
        t2d.setCapability(7);
        t2d.setCapability(8);
        t2d.setCapability(0);
        t2d.setCapability(2);
        t2d.setCapability(3);
        t2d.setCapability(6);
        t2d.setCapability(12);
        t2d.setCapability(14);
        return t2d;
    }

    private ImageComponent setupImage(String text, Color3f color, String fontName, int fontSize, int fontStyle) {
        int i;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics metrics = (FontMetrics)metricsTable.get(font);
        if (metrics == null) {
            metrics = toolkit.getFontMetrics(font);
            metricsTable.put(font, metrics);
        }
        int width = metrics.stringWidth(text);
        int descent = metrics.getMaxDescent();
        int ascent = metrics.getMaxAscent();
        int leading = metrics.getLeading();
        int height = descent + ascent;
        int pow = 1;
        for (i = 1; i < 32 && width > (pow *= 2); ++i) {
        }
        width = Math.max(width, pow);
        pow = 1;
        for (i = 1; i < 32 && height > (pow *= 2); ++i) {
        }
        height = Math.max(height, pow);
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D offscreenGraphics = bImage.createGraphics();
        Color myFill = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        offscreenGraphics.setColor(myFill);
        offscreenGraphics.fillRect(0, 0, width, height);
        offscreenGraphics.setFont(font);
        Color myTextColor = new Color(color.x, color.y, color.z, 1.0f);
        offscreenGraphics.setColor(myTextColor);
        offscreenGraphics.drawString(text, 0, height - descent);
        offscreenGraphics.dispose();
        this.vWidth = width;
        this.vHeight = height;
        if (width > this.MAX_TEXTURE_DIM || height > this.MAX_TEXTURE_DIM) {
            bImage = this.rescaleImage(bImage);
        }
        ImageComponent2D imageComponent = new ImageComponent2D(2, bImage);
        imageComponent.setCapability(0);
        return imageComponent;
    }

    private BufferedImage rescaleImage(BufferedImage bImage) {
        int width = bImage.getWidth();
        int height = bImage.getHeight();
        float sx = width > this.MAX_TEXTURE_DIM ? (float)this.MAX_TEXTURE_DIM / (float)width : 1.0f;
        float sy = height > this.MAX_TEXTURE_DIM ? (float)this.MAX_TEXTURE_DIM / (float)height : 1.0f;
        width = Math.round((float)width * sx);
        height = Math.round((float)height * sy);
        Image scaledImage = bImage.getScaledInstance(width, height, 16);
        bImage = new BufferedImage(width, height, 2);
        Graphics2D g = bImage.createGraphics();
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
        return bImage;
    }

    private QuadArray setupGeometry(int width, int height) {
        float zPosition = 0.0f;
        float rectWidth = (float)width * this.rectangleScaleFactor;
        float rectHeight = (float)height * this.rectangleScaleFactor;
        float[] verts1 = new float[]{rectWidth, 0.0f, zPosition, rectWidth, rectHeight, zPosition, 0.0f, rectHeight, zPosition, 0.0f, 0.0f, zPosition};
        float[] texCoords = new float[]{0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, -1.0f};
        QuadArray rect = new QuadArray(4, 33);
        rect.setCoordinates(0, verts1);
        rect.setTextureCoordinates(0, 0, texCoords);
        return rect;
    }

    private Appearance setupAppearance(Texture2D t2d) {
        Appearance appearance = this.getAppearance();
        if (appearance == null) {
            TransparencyAttributes transp = new TransparencyAttributes();
            transp.setTransparencyMode(2);
            transp.setTransparency(0.0f);
            appearance = new Appearance();
            appearance.setTransparencyAttributes(transp);
            appearance.setTexture(t2d);
            Material m = new Material();
            m.setLightingEnable(false);
            appearance.setMaterial(m);
            appearance.setCapability(3);
            appearance.setCapability(2);
            appearance.setCapabilityIsFrequent(2);
        } else {
            appearance.setTexture(t2d);
        }
        return appearance;
    }

    public String getString() {
        return this.text;
    }

    public Color3f getColor() {
        return this.color;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }
}

