/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class Analyze_Reader
extends ImagePlus
implements PlugIn {
    public boolean littleEndian = false;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open Analyze...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        IJ.showStatus((String)("Opening: " + directory + name));
        FileInfo fi = this.load(directory, name);
        FileOpener fo = new FileOpener(fi);
        ImagePlus imp = fo.open(false);
        if (imp == null) {
            return;
        }
        ImageStack stack = imp.getStack();
        for (int i = 1; i <= stack.getSize(); ++i) {
            ImageProcessor ip = stack.getProcessor(i);
            ip.flipVertical();
        }
        if (imp.getStackSize() > 1) {
            this.setStack(name, stack);
        } else {
            this.setProcessor(name, imp.getProcessor());
        }
        this.setCalibration(imp.getCalibration());
        this.setFileInfo(fi);
        if (arg.equals("")) {
            this.show();
        }
    }

    FileInfo load(String directory, String name) {
        FileInfo fi = new FileInfo();
        if (name == null || name == "") {
            return null;
        }
        if (name.endsWith(".img") || name.endsWith(".IMG")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.endsWith(".hdr") || name.endsWith(".HDR")) {
            name = name.substring(0, name.length() - 4);
        }
        IJ.showStatus((String)("Loading Analyze File: " + directory + name));
        try {
            fi = this.readHeader(directory + name + ".hdr");
        }
        catch (IOException e) {
            IJ.log((String)("Analyze Reader: " + e.getMessage()));
        }
        fi.fileName = name + ".img";
        fi.directory = directory;
        fi.fileFormat = 1;
        return fi;
    }

    public FileInfo readHeader(String hdrfile) throws IOException {
        int i;
        FileInputStream filein = new FileInputStream(hdrfile);
        DataInputStream input = new DataInputStream(filein);
        FileInfo fi = new FileInfo();
        byte[] units = new byte[4];
        this.littleEndian = false;
        input.readInt();
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 18; ++i) {
            input.read();
        }
        input.readInt();
        input.readShort();
        input.readByte();
        input.readByte();
        short endian = this.readShort(input);
        if (endian < 0 || endian > 15) {
            this.littleEndian = true;
            fi.intelByteOrder = true;
        }
        fi.width = this.readShort(input);
        fi.height = this.readShort(input);
        fi.nImages = this.readShort(input);
        input.readShort();
        for (i = 0; i < 3; ++i) {
            input.readShort();
        }
        input.read(units, 0, 4);
        fi.unit = new String(units, 0, 4);
        for (i = 0; i < 8; ++i) {
            input.read();
        }
        input.readShort();
        short datatype = this.readShort(input);
        int bitsallocated = this.readShort(input);
        input.readShort();
        input.readFloat();
        fi.pixelWidth = this.readFloat(input);
        fi.pixelHeight = this.readFloat(input);
        fi.pixelDepth = this.readFloat(input);
        for (i = 0; i < 4; ++i) {
            input.readFloat();
        }
        fi.offset = (int)this.readFloat(input);
        input.readFloat();
        input.readFloat();
        input.readFloat();
        input.readFloat();
        input.readFloat();
        input.readInt();
        input.readInt();
        this.readInt(input);
        this.readInt(input);
        for (i = 0; i < 80; ++i) {
            input.read();
        }
        for (i = 0; i < 24; ++i) {
            input.read();
        }
        input.read();
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 10; ++i) {
            input.read();
        }
        for (i = 0; i < 3; ++i) {
            input.read();
        }
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.readInt();
        input.close();
        filein.close();
        switch (datatype) {
            case 2: {
                fi.fileType = 0;
                bitsallocated = 8;
                break;
            }
            case 4: {
                fi.fileType = 1;
                bitsallocated = 16;
                break;
            }
            case 8: {
                fi.fileType = 3;
                bitsallocated = 32;
                break;
            }
            case 16: {
                fi.fileType = 4;
                bitsallocated = 32;
                break;
            }
            case 128: {
                fi.fileType = 7;
                bitsallocated = 24;
                break;
            }
            default: {
                fi.fileType = 0;
            }
        }
        return fi;
    }

    public int readInt(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readInt();
        }
        byte b1 = input.readByte();
        byte b2 = input.readByte();
        byte b3 = input.readByte();
        byte b4 = input.readByte();
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public short readShort(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readShort();
        }
        byte b1 = input.readByte();
        byte b2 = input.readByte();
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public float readFloat(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readFloat();
        }
        int orig = this.readInt(input);
        return Float.intBitsToFloat(orig);
    }
}

