/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.VirtualStack;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.ImageWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

class DeflateExtendedFileSaver
extends FileSaver {
    private ImagePlus mimp;
    private FileInfo mfi;

    public DeflateExtendedFileSaver(ImagePlus imp) {
        super(imp);
        this.mimp = imp;
        this.mfi = imp.getFileInfo();
    }

    void showErrorMessage(IOException e) {
        String msg = e.getMessage();
        if (msg.length() > 100) {
            msg = msg.substring(0, 100);
        }
        this.error("An error occured writing the file.\n \n" + msg);
    }

    private void error(String msg) {
        IJ.error((String)"FileSaver", (String)msg);
    }

    public boolean saveAsRaw(String path) {
        this.mfi.nImages = 1;
        this.mfi.intelByteOrder = Prefs.intelByteOrder;
        boolean signed16Bit = false;
        short[] pixels = null;
        int n = 0;
        try {
            signed16Bit = this.mimp.getCalibration().isSigned16Bit();
            if (signed16Bit) {
                pixels = (short[])this.mimp.getProcessor().getPixels();
                n = this.mimp.getWidth() * this.mimp.getHeight();
                for (int i = 0; i < n; ++i) {
                    pixels[i] = (short)(pixels[i] - 32768);
                }
            }
            DeflaterOutputStream out = path.endsWith(".mha") ? new DeflaterOutputStream(new FileOutputStream(path, true)) : new DeflaterOutputStream(new FileOutputStream(path));
            ImageWriter file = new ImageWriter(this.mfi);
            file.write((OutputStream)out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        if (signed16Bit) {
            for (int i = 0; i < n; ++i) {
                pixels[i] = (short)(pixels[i] + 32768);
            }
        }
        return true;
    }

    public boolean saveAsRawStack(String path) {
        int i;
        short[] pixels;
        boolean virtualStack;
        if (this.mfi.nImages == 1) {
            IJ.error((String)"This is not a stack");
            return false;
        }
        this.mfi.intelByteOrder = Prefs.intelByteOrder;
        boolean signed16Bit = false;
        Object[] stack = null;
        int n = 0;
        boolean bl = virtualStack = this.mimp.getStackSize() > 1 && this.mimp.getStack().isVirtual();
        if (virtualStack) {
            this.mfi.virtualStack = (VirtualStack)this.mimp.getStack();
            if (this.mimp.getProperty("AnalyzeFormat") != null) {
                this.mfi.fileName = "FlipTheseImages";
            }
        }
        try {
            signed16Bit = this.mimp.getCalibration().isSigned16Bit();
            if (signed16Bit && !virtualStack) {
                stack = (Object[])this.mfi.pixels;
                n = this.mimp.getWidth() * this.mimp.getHeight();
                for (int slice = 0; slice < this.mfi.nImages; ++slice) {
                    pixels = (short[])stack[slice];
                    for (i = 0; i < n; ++i) {
                        pixels[i] = (short)(pixels[i] - 32768);
                    }
                }
            }
            DeflaterOutputStream out = path.endsWith(".mha") ? new DeflaterOutputStream(new FileOutputStream(path, true)) : new DeflaterOutputStream(new FileOutputStream(path));
            ImageWriter file = new ImageWriter(this.mfi);
            file.write((OutputStream)out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        if (signed16Bit) {
            for (int slice = 0; slice < this.mfi.nImages; ++slice) {
                pixels = (short[])stack[slice];
                for (i = 0; i < n; ++i) {
                    pixels[i] = (short)(pixels[i] + 32768);
                }
            }
        }
        return true;
    }
}

