/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import sc.fiji.labkit.pixel_classification.gui.FeatureInfo;
import sc.fiji.labkit.pixel_classification.gui.IconResources;
import sc.fiji.labkit.pixel_classification.gui.InfoDialog;
import sc.fiji.labkit.pixel_classification.gui.SelectableRow;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSettings;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class NonParametrizedRow
extends JPanel
implements SelectableRow {
    private static final ImageIcon INFO_ICON = IconResources.getIcon("info_icon_16px.png");
    private FeatureInfo featureInfo;
    private JCheckBox checkbox;

    public NonParametrizedRow(FeatureInfo featureInfo, FeatureSettings featureSettings) {
        this.featureInfo = featureInfo;
        this.initUI(NonParametrizedRow.isSelected(featureInfo, featureSettings));
        this.setGlobalSettings(featureSettings.globals());
    }

    private static boolean isSelected(FeatureInfo featureInfo, FeatureSettings featureSettings) {
        return featureSettings.features().stream().anyMatch(f -> featureInfo.pluginClass().equals(f.pluginClass()));
    }

    private void initUI(boolean selected) {
        this.setLayout(new BorderLayout());
        this.add(Box.createHorizontalStrut(30), "West");
        this.checkbox = new JCheckBox(this.featureInfo.getName());
        this.checkbox.setSelected(selected);
        this.add((Component)this.checkbox, "Center");
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(0));
        btnPanel.add(this.createInfoButton());
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, btnPanel.getPreferredSize().height));
    }

    private JButton createInfoButton() {
        JButton infoButton = new JButton(INFO_ICON);
        infoButton.setFocusPainted(false);
        infoButton.setMargin(new Insets(0, 0, 0, 0));
        infoButton.setContentAreaFilled(false);
        infoButton.setBorderPainted(false);
        infoButton.setOpaque(false);
        infoButton.setToolTipText("Filter information");
        infoButton.addActionListener(this::showInfoDialog);
        return infoButton;
    }

    private void showInfoDialog(ActionEvent e) {
        InfoDialog docoDiag = new InfoDialog(this, "example", "If you use this filter you will do great things");
        docoDiag.setVisible(true);
    }

    @Override
    public List<FeatureSetting> getSelectedFeatureSettings() {
        ArrayList<FeatureSetting> selected = new ArrayList<FeatureSetting>();
        if (this.checkbox.isSelected()) {
            selected.add(new FeatureSetting(this.featureInfo.pluginClass(), new Object[0]));
        }
        return selected;
    }

    @Override
    public void setGlobalSettings(GlobalSettings globalSettings) {
        try {
            boolean isValid = this.featureInfo.pluginClass().newInstance().checkGlobalSettings(globalSettings);
            NonParametrizedRow.enableRecursively(this, isValid);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static void enableRecursively(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof JPanel) {
            JPanel panel = (JPanel)component;
            for (Component child : panel.getComponents()) {
                NonParametrizedRow.enableRecursively(child, enabled);
            }
        }
    }
}

