/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;

public class ImagesToStack
implements PlugIn {
    private static final int rgb = 33;
    private static final int COPY_CENTER = 0;
    private static final int COPY_TOP_LEFT = 1;
    private static final int SCALE_SMALL = 2;
    private static final int SCALE_LARGE = 3;
    private static final String[] methods = new String[]{"Copy (center)", "Copy (top-left)", "Scale (smallest)", "Scale (largest)"};
    private static int staticMethod = 0;
    private static boolean staticBicubic;
    private static boolean staticKeep;
    private static boolean staticTitlesAsLabels;
    private int method = 0;
    private boolean bicubic;
    private boolean keep;
    private boolean titlesAsLabels = true;
    private String filter;
    private int width;
    private int height;
    private int maxWidth;
    private int maxHeight;
    private int minWidth;
    private int minHeight;
    private int minSize;
    private int maxSize;
    private boolean allInvertedLuts;
    private Calibration cal2;
    private int stackType;
    private ImagePlus[] images;
    private String name = "Stack";
    private Color fillColor;

    public static ImagePlus run(ImagePlus[] images) {
        ImagesToStack itos = new ImagesToStack();
        int count = itos.findMinMaxSize(images, images.length);
        return itos.convert(images, count);
    }

    @Override
    public void run(String arg) {
        this.convertImagesToStack();
    }

    public void convertImagesToStack() {
        boolean scale = false;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No images are open.");
            return;
        }
        int count = 0;
        int stackCount = 0;
        this.images = new ImagePlus[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp.getStackSize() == 1) {
                this.images[count++] = imp;
                continue;
            }
            ++stackCount;
        }
        if (count < 2) {
            String msg = "";
            if (stackCount > 1) {
                msg = "\n \nUse the Image>Stacks>Tools>Concatenate\ncommand to combine stacks.";
            }
            IJ.error("Images to Stack", "At least two open 2D images required." + msg);
            return;
        }
        this.filter = null;
        count = this.findMinMaxSize(this.images, count);
        boolean sizesDiffer = this.width != this.minWidth || this.height != this.minHeight;
        boolean showDialog = true;
        String macroOptions = Macro.getOptions();
        if (IJ.macroRunning() && macroOptions == null) {
            if (sizesDiffer) {
                IJ.error("Images are not all the same size");
                return;
            }
            showDialog = false;
        }
        if (showDialog) {
            GenericDialog gd = new GenericDialog("Images to Stack");
            if (sizesDiffer) {
                String msg = "The " + count + " images differ in size (smallest=" + this.minWidth + "x" + this.minHeight + ",\nlargest=" + this.maxWidth + "x" + this.maxHeight + "). They will be converted\nto a stack using the specified method.";
                gd.setInsets(0, 0, 5);
                gd.addMessage(msg);
                gd.addChoice("Method:", methods, methods[staticMethod]);
            }
            gd.setSmartRecording(true);
            gd.addStringField("Name:", this.name, 12);
            gd.addStringField("Title contains:", "", 12);
            gd.addStringField("Fill color:", "", 12);
            if (sizesDiffer) {
                gd.addCheckbox("Bicubic interpolation", staticBicubic);
            }
            gd.addCheckbox("Use titles as labels", staticTitlesAsLabels);
            gd.addCheckbox("Keep source images", staticKeep);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            if (sizesDiffer) {
                this.method = gd.getNextChoiceIndex();
            }
            this.name = gd.getNextString();
            this.filter = gd.getNextString();
            String fillc = gd.getNextString();
            this.fillColor = Colors.decode(fillc, null);
            if (sizesDiffer) {
                this.bicubic = gd.getNextBoolean();
            }
            this.titlesAsLabels = gd.getNextBoolean();
            this.keep = gd.getNextBoolean();
            if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                this.filter = null;
            }
            if (this.filter != null && (count = this.findMinMaxSize(this.images, count)) == 0) {
                IJ.error("Images to Stack", "None of the images have a title containing \"" + this.filter + "\"");
            }
            if (!IJ.isMacro()) {
                staticMethod = this.method;
                staticBicubic = this.bicubic;
                staticKeep = this.keep;
                staticTitlesAsLabels = this.titlesAsLabels;
            }
            if (IJ.recording()) {
                Recorder.recordCall("imp = ImagesToStack.run(arrayOfImages);");
            }
        } else {
            this.keep = false;
        }
        if (this.method == 2) {
            this.width = this.minWidth;
            this.height = this.minHeight;
        } else if (this.method == 3) {
            this.width = this.maxWidth;
            this.height = this.maxHeight;
        }
        ImagePlus stack = this.convert(this.images, count);
        if (stack != null) {
            stack.show();
        }
    }

    private ImagePlus convert(ImagePlus[] images, int count) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        ImageStack stack = new ImageStack(this.width, this.height);
        FileInfo fi = images[0].getOriginalFileInfo();
        if (fi != null && fi.directory == null) {
            fi = null;
        }
        Overlay overlay = new Overlay();
        for (int i = 0; i < count; ++i) {
            FileInfo fi2;
            String info;
            String label;
            ImageProcessor ip = images[i].getProcessor();
            boolean invertedLut = ip.isInvertedLut();
            if (ip.getMin() < min) {
                min = ip.getMin();
            }
            if (ip.getMax() > max) {
                max = ip.getMax();
            }
            String string = label = this.titlesAsLabels ? images[i].getTitle() : null;
            if (label == null) {
                label = images[i].getProp("Slice_Label");
            }
            if (label != null && (info = (String)images[i].getProperty("Info")) != null) {
                label = label + "\n" + info;
            }
            if (fi != null && (fi2 = images[i].getOriginalFileInfo()) != null && !fi.directory.equals(fi2.directory)) {
                fi = null;
            }
            switch (this.stackType) {
                case 16: {
                    ip = ip.convertToShort(false);
                    break;
                }
                case 32: {
                    ip = ip.convertToFloat();
                    break;
                }
                case 33: {
                    ip = ip.convertToRGB();
                    break;
                }
            }
            if (invertedLut && !this.allInvertedLuts) {
                if (this.keep) {
                    ip = ip.duplicate();
                }
                ip.invert();
            }
            if (ip.getWidth() != this.width || ip.getHeight() != this.height) {
                switch (this.method) {
                    case 0: 
                    case 1: {
                        ImageProcessor ip2 = null;
                        switch (this.stackType) {
                            case 8: {
                                ip2 = new ByteProcessor(this.width, this.height);
                                break;
                            }
                            case 16: {
                                ip2 = new ShortProcessor(this.width, this.height);
                                break;
                            }
                            case 32: {
                                ip2 = new FloatProcessor(this.width, this.height);
                                break;
                            }
                            case 33: {
                                ip2 = new ColorProcessor(this.width, this.height);
                            }
                        }
                        if (this.fillColor != null) {
                            ip2.setColor(this.fillColor);
                            ip2.fill();
                        }
                        int xoff = 0;
                        int yoff = 0;
                        if (this.method == 0) {
                            xoff = (this.width - ip.getWidth()) / 2;
                            yoff = (this.height - ip.getHeight()) / 2;
                        }
                        ip2.insert(ip, xoff, yoff);
                        ip = ip2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ip.setInterpolationMethod(this.bicubic ? 2 : 1);
                        ip.resetRoi();
                        ip = ip.resize(this.width, this.height);
                    }
                }
            } else {
                Overlay overlay2;
                if (this.keep) {
                    ip = ip.duplicate();
                }
                if ((overlay2 = images[i].getOverlay()) != null) {
                    for (int j = 0; j < overlay2.size(); ++j) {
                        Roi roi = overlay2.get(j);
                        roi.setPosition(i + 1);
                        overlay.add((Roi)roi.clone());
                    }
                }
            }
            stack.addSlice(label, ip);
            if (i == 0 && invertedLut && !this.allInvertedLuts) {
                stack.setColorModel(null);
            }
            if (this.keep) continue;
            images[i].changes = false;
            images[i].close();
        }
        if (stack.size() == 0) {
            return null;
        }
        ImagePlus imp = new ImagePlus(this.name, stack);
        if (this.stackType == 16 || this.stackType == 32) {
            imp.getProcessor().setMinAndMax(min, max);
        }
        if (this.cal2 != null) {
            imp.setCalibration(this.cal2);
        }
        if (fi != null) {
            fi.fileName = "";
            fi.nImages = imp.getStackSize();
            imp.setFileInfo(fi);
        }
        if (overlay.size() > 0) {
            imp.setOverlay(overlay);
        }
        return imp;
    }

    private int findMinMaxSize(ImagePlus[] images, int count) {
        int index = 0;
        this.stackType = 8;
        this.width = 0;
        this.height = 0;
        this.cal2 = images[0].getCalibration();
        this.maxWidth = 0;
        this.maxHeight = 0;
        this.minWidth = Integer.MAX_VALUE;
        this.minHeight = Integer.MAX_VALUE;
        this.minSize = Integer.MAX_VALUE;
        this.allInvertedLuts = true;
        this.maxSize = 0;
        for (int i = 0; i < count; ++i) {
            int size;
            int type;
            if (this.exclude(images[i].getTitle())) continue;
            if (images[i].getType() == 3) {
                this.stackType = 33;
            }
            if (!images[i].getProcessor().isInvertedLut()) {
                this.allInvertedLuts = false;
            }
            if ((type = images[i].getBitDepth()) == 24) {
                type = 33;
            }
            if (type > this.stackType) {
                this.stackType = type;
            }
            int w = images[i].getWidth();
            int h = images[i].getHeight();
            if (w > this.width) {
                this.width = w;
            }
            if (h > this.height) {
                this.height = h;
            }
            if ((size = w * h) < this.minSize) {
                this.minSize = size;
                this.minWidth = w;
                this.minHeight = h;
            }
            if (size > this.maxSize) {
                this.maxSize = size;
                this.maxWidth = w;
                this.maxHeight = h;
            }
            Calibration cal = images[i].getCalibration();
            if (!images[i].getCalibration().equals(this.cal2)) {
                this.cal2 = null;
            }
            images[index++] = images[i];
        }
        return index;
    }

    final boolean exclude(String title) {
        return this.filter != null && title != null && title.indexOf(this.filter) == -1;
    }

    static {
        staticTitlesAsLabels = true;
    }
}

