/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.Executer;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.io.SaveDialog;
import ij.macro.Debugger;
import ij.macro.FunctionFinder;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.plugin.JavaScriptEvaluator;
import ij.plugin.MacroInstaller;
import ij.plugin.Macro_Runner;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

public class Editor
extends PlugInFrame
implements ActionListener,
ItemListener,
TextListener,
KeyListener,
MouseListener,
ClipboardOwner,
MacroConstants,
Runnable,
Debugger {
    public static String JavaScriptIncludes = "importPackage(Packages.ij);importPackage(Packages.ij.gui);importPackage(Packages.ij.process);importPackage(Packages.ij.measure);importPackage(Packages.ij.util);importPackage(Packages.ij.macro);importPackage(Packages.ij.plugin);importPackage(Packages.ij.io);importPackage(Packages.ij.text);importPackage(Packages.ij.plugin.filter);importPackage(Packages.ij.plugin.frame);importPackage(Packages.ij.plugin.tool);importPackage(java.lang);importPackage(java.awt);importPackage(java.awt.image);importPackage(java.awt.geom);importPackage(java.awt.event);importPackage(java.util);importPackage(java.io);function print(s) {IJ.log(s);};";
    private static String JS_EXAMPLES = "img = IJ.openImage(\"http://imagej.net/images/blobs.gif\")\nimg = IJ.createImage(\"Untitled\", \"16-bit ramp\", 500, 500, 1)\nimg.show()\nip = img.getProcessor()\nip.getStats()\nIJ.setAutoThreshold(img, \"IsoData\")\nIJ.run(img, \"Analyze Particles...\", \"show=Overlay display clear\")\nip.invert()\nip.blurGaussian(5)\nip.get(10,10)\nip.set(10,10,222)\n(To run, move cursor to end of a line and press 'enter'.\nVisible images are automatically updated.)\n";
    public static final int MAX_SIZE = 28000;
    public static final int XINC = 10;
    public static final int YINC = 18;
    public static final int MONOSPACED = 1;
    public static final int MENU_BAR = 2;
    public static final int RUN_BAR = 4;
    public static final int INSTALL_BUTTON = 8;
    public static final int MACROS_MENU_ITEMS = 15;
    public static final String INTERACTIVE_NAME = "Interactive Interpreter";
    static final String FONT_SIZE = "editor.font.size";
    static final String FONT_MONO = "editor.font.mono";
    static final String CASE_SENSITIVE = "editor.case-sensitive";
    static final String DEFAULT_DIR = "editor.dir";
    static final String INSERT_SPACES = "editor.spaces";
    static final String TAB_INC = "editor.tab-inc";
    private static final int MACRO = 0;
    private static final int JAVASCRIPT = 1;
    private static final int BEANSHELL = 2;
    private static final int PYTHON = 3;
    private static final String[] languages = new String[]{"Macro", "JavaScript", "BeanShell", "Python"};
    private static final String[] extensions = new String[]{".ijm", ".js", ".bsh", ".py"};
    public static Editor currentMacroEditor;
    private TextArea ta;
    private String path;
    protected boolean changes;
    private static String searchString;
    private static boolean caseSensitive;
    private static int lineNumber;
    private static int xoffset;
    private static int yoffset;
    private static int nWindows;
    private Menu fileMenu;
    private Menu editMenu;
    private Properties p = new Properties();
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb;
    private Menu macrosMenu;
    private int nMacros;
    private Program pgm;
    private int eventCount;
    private String shortcutsInUse;
    private int inUseCount;
    private MacroInstaller installer;
    private static String defaultDir;
    private boolean dontShowWindow;
    private int[] sizes = new int[]{9, 10, 11, 12, 13, 14, 16, 18, 20, 24, 36, 48, 60, 72};
    private int fontSizeIndex = (int)Prefs.get("editor.font.size", 6.0);
    private CheckboxMenuItem monospaced;
    private static boolean wholeWords;
    private boolean isMacroWindow;
    private int debugStart;
    private int debugEnd;
    private static TextWindow debugWindow;
    private boolean step;
    private int previousLine;
    private static Editor instance;
    private int runToLine;
    private String downloadUrl;
    private boolean downloading;
    private FunctionFinder functionFinder;
    private ArrayList undoBuffer = new ArrayList();
    private boolean performingUndo;
    private boolean checkForCurlyQuotes;
    private static int tabInc;
    private static boolean insertSpaces;
    private CheckboxMenuItem insertSpacesItem;
    private boolean interactiveMode;
    private Interpreter interpreter;
    private JavaScriptEvaluator evaluator;
    private int messageCount;
    private String rejectMacrosMsg;
    private Button runButton;
    private Button installButton;
    private Choice language;

    public Editor() {
        this(24, 80, 0, 2);
    }

    public Editor(String name) {
        this(24, 80, 0, Editor.getOptions(name));
    }

    public Editor(int rows, int columns, int fontSize, int options) {
        super("Editor");
        WindowManager.addWindow(this);
        this.addMenuBar(options);
        boolean addRunBar = (options & 4) != 0;
        ImageJ ij = IJ.getInstance();
        if (addRunBar) {
            Panel panel = new Panel(new FlowLayout(0, 0, 0));
            panel.addKeyListener(ij);
            this.runButton = new Button("Run");
            this.runButton.addActionListener(this);
            this.runButton.addKeyListener(ij);
            panel.setFont(new Font("SansSerif", 0, this.sizes[this.fontSizeIndex]));
            panel.add(this.runButton);
            if ((options & 8) != 0) {
                this.installButton = new Button("Install");
                this.installButton.addActionListener(this);
                this.installButton.addKeyListener(ij);
                panel.add(this.installButton);
            }
            this.language = new Choice();
            for (int i = 0; i < languages.length; ++i) {
                this.language.addItem(languages[i]);
            }
            this.language.addItemListener(this);
            this.language.addKeyListener(ij);
            panel.add(this.language);
            this.add("North", panel);
        }
        this.ta = new TextArea(rows, columns);
        this.ta.addTextListener(this);
        this.ta.addKeyListener(this);
        if (IJ.isLinux()) {
            this.ta.setBackground(Color.white);
        }
        this.addKeyListener(ij);
        this.ta.addMouseListener(this);
        this.add(this.ta);
        this.pack();
        this.setFont();
        this.positionWindow();
        if (addRunBar) {
            this.ta.requestFocus();
        }
        if (!IJ.isJava18() && !IJ.isLinux()) {
            insertSpaces = false;
        }
    }

    private static int getOptions(String name) {
        int options = 2;
        if (name == null) {
            return options;
        }
        if (name.endsWith(".ijm") || name.endsWith(".js") || name.endsWith(".bsh") || name.endsWith(".py")) {
            options |= 4;
        }
        if (name.endsWith(".ijm")) {
            options |= 8;
        }
        return options;
    }

    void addMenuBar(int options) {
        this.mb = new MenuBar();
        if (Menus.getFontSize() != 0) {
            this.mb.setFont(Menus.getFont());
        }
        Menu m = new Menu("File");
        m.add(new MenuItem("New...", new MenuShortcut(78, true)));
        m.add(new MenuItem("Open...", new MenuShortcut(79)));
        m.add(new MenuItem("Save", new MenuShortcut(83)));
        m.add(new MenuItem("Save As..."));
        m.add(new MenuItem("Revert"));
        m.add(new MenuItem("Print..."));
        m.addActionListener(this);
        this.fileMenu = m;
        this.mb.add(m);
        m = new Menu("Edit");
        MenuItem item = null;
        item = IJ.isWindows() ? new MenuItem("Undo  Ctrl+Z") : new MenuItem("Undo", new MenuShortcut(90));
        m.add(item);
        m.addSeparator();
        item = IJ.isWindows() ? new MenuItem("Cut  Ctrl+X") : new MenuItem("Cut", new MenuShortcut(88));
        m.add(item);
        item = IJ.isWindows() ? new MenuItem("Copy  Ctrl+C") : new MenuItem("Copy", new MenuShortcut(67));
        m.add(item);
        item = IJ.isWindows() ? new MenuItem("Paste  Ctrl+V") : new MenuItem("Paste", new MenuShortcut(86));
        m.add(item);
        m.addSeparator();
        m.add(new MenuItem("Find...", new MenuShortcut(70)));
        m.add(new MenuItem("Find Next", new MenuShortcut(71)));
        m.add(new MenuItem("Go to Line...", new MenuShortcut(76)));
        m.addSeparator();
        m.add(new MenuItem("Select All", new MenuShortcut(65)));
        m.add(new MenuItem("Balance", new MenuShortcut(66, false)));
        m.add(new MenuItem("Detab..."));
        this.insertSpacesItem = new CheckboxMenuItem("Tab Key Inserts Spaces");
        this.insertSpacesItem.addItemListener(this);
        this.insertSpacesItem.setState(insertSpaces);
        m.add(this.insertSpacesItem);
        m.add(new MenuItem("Zap Gremlins"));
        m.add(new MenuItem("Copy to Image Info"));
        m.addActionListener(this);
        this.mb.add(m);
        this.editMenu = m;
        if ((options & 2) != 0) {
            this.setMenuBar(this.mb);
        }
        m = new Menu("Font");
        m.add(new MenuItem("Make Text Smaller"));
        m.add(new MenuItem("Make Text Larger"));
        m.addSeparator();
        this.monospaced = new CheckboxMenuItem("Monospaced Font", Prefs.get(FONT_MONO, false));
        if ((options & 1) != 0) {
            this.monospaced.setState(true);
        }
        this.monospaced.addItemListener(this);
        m.add(this.monospaced);
        m.add(new MenuItem("Save Settings"));
        m.addActionListener(this);
        this.mb.add(m);
        m = Menus.getExamplesMenu(this);
        this.mb.add(m);
    }

    public void positionWindow() {
        Dimension screen = IJ.getScreenSize();
        Dimension window = this.getSize();
        if (window.width == 0) {
            return;
        }
        int left = screen.width / 2 - window.width / 2;
        int top = screen.height / (IJ.isWindows() ? 6 : 5);
        if (IJ.isMacOSX()) {
            top = (screen.height - window.height) / 4;
        }
        if (top < 0) {
            top = 0;
        }
        if (nWindows <= 0 || xoffset > 80) {
            xoffset = 0;
            yoffset = 0;
        }
        this.setLocation(left + xoffset, top + yoffset);
        xoffset += 10;
        yoffset += 18;
        ++nWindows;
    }

    void setWindowTitle(String title) {
        Menus.updateWindowMenuItem(this.getTitle(), title);
        this.setTitle(title);
    }

    public void create(String name, String text) {
        boolean macroExtension;
        this.ta.append(text);
        if (IJ.isMacOSX()) {
            IJ.wait(25);
        }
        this.ta.setCaretPosition(0);
        this.setWindowTitle(name);
        boolean bl = macroExtension = name.endsWith(".txt") || name.endsWith(".ijm");
        if (macroExtension || name.endsWith(".js") || name.endsWith(".bsh") || name.endsWith(".py") || name.indexOf(".") == -1) {
            this.macrosMenu = new Menu("Macros");
            this.macrosMenu.add(new MenuItem("Run Macro", new MenuShortcut(82)));
            this.macrosMenu.add(new MenuItem("Evaluate Line", new MenuShortcut(89)));
            this.macrosMenu.add(new MenuItem("Abort Macro"));
            this.macrosMenu.add(new MenuItem("Install Macros", new MenuShortcut(73)));
            this.macrosMenu.add(new MenuItem("Macro Functions...", new MenuShortcut(77, true)));
            this.macrosMenu.add(new MenuItem("Function Finder...", new MenuShortcut(70, true)));
            this.macrosMenu.add(new MenuItem("Enter Interactive Mode"));
            this.macrosMenu.add(new MenuItem("Assign to Repeat Cmd", new MenuShortcut(65, true)));
            this.macrosMenu.addSeparator();
            this.macrosMenu.add(new MenuItem("Evaluate Macro"));
            this.macrosMenu.add(new MenuItem("Evaluate JavaScript", new MenuShortcut(74, false)));
            this.macrosMenu.add(new MenuItem("Evaluate BeanShell", new MenuShortcut(66, true)));
            this.macrosMenu.add(new MenuItem("Evaluate Python", new MenuShortcut(80, false)));
            this.macrosMenu.add(new MenuItem("Show Log Window", new MenuShortcut(76, true)));
            this.macrosMenu.addSeparator();
            this.macrosMenu.addActionListener(this);
            this.mb.add(this.macrosMenu);
            if (!(name.endsWith(".js") || name.endsWith(".bsh") || name.endsWith(".py"))) {
                Menu debugMenu = new Menu("Debug");
                debugMenu.add(new MenuItem("Debug Macro", new MenuShortcut(68)));
                debugMenu.add(new MenuItem("Step", new MenuShortcut(69)));
                debugMenu.add(new MenuItem("Trace", new MenuShortcut(84)));
                debugMenu.add(new MenuItem("Fast Trace", new MenuShortcut(84, true)));
                debugMenu.add(new MenuItem("Run"));
                debugMenu.add(new MenuItem("Run to Insertion Point", new MenuShortcut(69, true)));
                debugMenu.add(new MenuItem("Abort"));
                debugMenu.addActionListener(this);
                this.mb.add(debugMenu);
            }
        } else {
            this.fileMenu.addSeparator();
            this.fileMenu.add(new MenuItem("Compile and Run", new MenuShortcut(82)));
        }
        if (this.language != null) {
            for (int i = 0; i < languages.length; ++i) {
                if (!name.endsWith(extensions[i])) continue;
                this.language.select(languages[i]);
                break;
            }
        }
        if (text.startsWith("//@AutoInstall") && (name.endsWith(".ijm") || name.endsWith(".txt"))) {
            boolean installInPluginsMenu = !name.contains("Tool.");
            this.installMacros(text, installInPluginsMenu);
            if (text.startsWith("//@AutoInstallAndHide")) {
                this.dontShowWindow = true;
            }
        }
        if (IJ.getInstance() != null && !this.dontShowWindow) {
            this.show();
        }
        if (this.dontShowWindow) {
            this.dispose();
            this.dontShowWindow = false;
        }
        if (name.equals(INTERACTIVE_NAME)) {
            this.enterInteractiveMode();
            String txt = this.ta.getText();
            this.ta.setCaretPosition(txt.length());
        }
        WindowManager.setWindow(this);
        this.checkForCurlyQuotes = true;
        this.changes = false;
    }

    public void createMacro(String name, String text) {
        this.create(name, text);
    }

    public void setRejectMacrosMsg(String msg) {
        this.rejectMacrosMsg = msg;
    }

    public String getRejectMacrosMsg() {
        return this.rejectMacrosMsg;
    }

    void installMacros(String text, boolean installInPluginsMenu) {
        if (this.rejectMacrosMsg != null) {
            if (this.rejectMacrosMsg.length() > 0) {
                IJ.showMessage("", this.rejectMacrosMsg);
            }
            return;
        }
        String functions = Interpreter.getAdditionalFunctions();
        if (functions != null && text != null) {
            text = !text.endsWith("\n") && !functions.startsWith("\n") ? text + "\n" + functions : text + functions;
        }
        this.installer = new MacroInstaller();
        this.installer.setFileName(this.getTitle());
        int nShortcuts = this.installer.install(text, this.macrosMenu);
        if (installInPluginsMenu || nShortcuts > 0) {
            this.installer.install(null);
        }
        this.dontShowWindow = this.installer.isAutoRunAndHide();
        currentMacroEditor = this;
    }

    public void open(String dir, String name) {
        this.path = dir + name;
        File file = new File(this.path);
        if (!file.exists()) {
            IJ.error("File not found: " + this.path);
            return;
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            if (this.ta != null && this.ta.getText().length() > 0) {
                this.ta.setText("");
                this.eventCount = 0;
            }
            this.create(name, new String(sb));
            this.changes = false;
        }
        catch (Exception e) {
            IJ.handleException(e);
            return;
        }
    }

    public String getText() {
        if (this.ta == null) {
            return "";
        }
        return this.ta.getText();
    }

    public TextArea getTextArea() {
        return this.ta;
    }

    public void display(String title, String text) {
        this.ta.selectAll();
        this.ta.replaceRange(text, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.ta.setCaretPosition(0);
        this.setWindowTitle(title);
        this.changes = false;
        if (IJ.getInstance() != null) {
            this.show();
        }
        WindowManager.setWindow(this);
    }

    void save() {
        if (this.path == null) {
            this.saveAs();
            return;
        }
        File f = new File(this.path);
        if (f.exists() && !f.canWrite()) {
            IJ.showMessage("Editor", "Unable to save because file is write-protected. \n \n" + this.path);
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        try {
            String s;
            BufferedReader br = new BufferedReader(new CharArrayReader(chars));
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.path));
            while ((s = br.readLine()) != null) {
                bw.write(s, 0, s.length());
                bw.newLine();
            }
            bw.close();
            IJ.showStatus(text.length() + " chars saved to " + this.path);
            this.changes = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void compileAndRun() {
        if (this.path == null) {
            this.saveAs();
        }
        if (this.path != null) {
            this.save();
            String text = this.ta.getText();
            if (text.contains("implements PlugInFilter") && text.contains("IJ.run(")) {
                IJ.log("<<Plugins that call IJ.run() should probably implement PlugIn, not PlugInFilter.>>");
            }
            IJ.runPlugIn("ij.plugin.Compiler", this.path);
        }
    }

    final void runMacro(boolean debug) {
        int end;
        if (this.path != null) {
            Macro_Runner.setFilePath(this.path);
        }
        if (this.getTitle().endsWith(".js")) {
            this.evaluateJavaScript();
            return;
        }
        if (this.getTitle().endsWith(".bsh")) {
            this.evaluateScript(".bsh");
            return;
        }
        if (this.getTitle().endsWith(".py")) {
            this.evaluateScript(".py");
            return;
        }
        int start = this.ta.getSelectionStart();
        String text = start == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        Interpreter.abort();
        if (this.checkForCurlyQuotes) {
            text = text.replaceAll("\u201c", "\"");
            text = text.replaceAll("\u201d", "\"");
            if (start == end) {
                this.ta.setText(text);
            } else {
                String text2 = this.ta.getText();
                text2 = text2.replaceAll("\u201c", "\"");
                text2 = text2.replaceAll("\u201d", "\"");
                this.ta.setText(text2);
            }
            this.checkForCurlyQuotes = false;
        }
        currentMacroEditor = this;
        text = Editor.doInclude(text);
        MacroRunner mr = new MacroRunner();
        if (debug) {
            mr.setEditor(this);
        }
        mr.run(text);
    }

    public static String doInclude(String code) {
        if (code.startsWith("#include ") || code.startsWith("// include ")) {
            boolean isURL;
            if (IJ.isWindows()) {
                code = code.replaceAll("\r\n", "\n");
            }
            int offset = code.startsWith("#include ") ? 9 : 11;
            int eol = code.indexOf("\n");
            String path = code.substring(offset, eol);
            boolean bl = isURL = path.startsWith("http://") || path.startsWith("https://");
            if (!isURL) {
                File f;
                String macrosDir;
                boolean fullPath;
                boolean bl2 = fullPath = path.startsWith("/") || path.startsWith("\\") || path.indexOf(":\\") == 1 || path.indexOf(":/") == 1;
                if (!fullPath && (macrosDir = Menus.getMacrosPath()) != null) {
                    path = Menus.getMacrosPath() + path;
                }
                if (!(f = new File(path)).exists()) {
                    IJ.error("Include file not found:\n" + path);
                }
            }
            code = code.substring(eol + 1, code.length());
            code = isURL ? "//\n" + code + IJ.openUrlAsString(path) : "//\n" + code + IJ.openAsString(path);
        }
        return code;
    }

    void evaluateMacro() {
        String title = this.getTitle();
        if (title.endsWith(".js") || title.endsWith(".bsh") || title.endsWith(".py")) {
            this.setWindowTitle(title.substring(0, title.length() - 3) + ".ijm");
        }
        this.runMacro(false);
    }

    void evaluateJavaScript() {
        int end;
        int start;
        String text;
        if (!this.getTitle().endsWith(".js")) {
            this.setWindowTitle(SaveDialog.setExtension(this.getTitle(), ".js"));
        }
        if ((text = (start = this.ta.getSelectionStart()) == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText()).equals("")) {
            return;
        }
        boolean strictMode = false;
        if (IJ.isJava18()) {
            String text40 = text.substring(0, Math.min(40, text.length()));
            strictMode = text40.contains("'use strict'") || text40.contains("\"use strict\"");
        }
        text = Editor.getJSPrefix("") + text;
        if (IJ.isJava18()) {
            text = "load(\"nashorn:mozilla_compat.js\");" + text;
            if (strictMode) {
                text = "'use strict';" + text;
            }
        }
        if (!IJ.isMacOSX() || IJ.is64Bit()) {
            IJ.runPlugIn("ij.plugin.JavaScriptEvaluator", text);
        } else {
            Object js = IJ.runPlugIn("JavaScript", text);
            if (js == null) {
                this.download("/download/tools/JavaScript.jar");
            }
        }
    }

    public void evaluateScript(String ext) {
        String url;
        String plugin;
        int end;
        int start;
        String text;
        if (this.downloading) {
            IJ.beep();
            IJ.showStatus("Download in progress");
            return;
        }
        if (ext.endsWith(".js")) {
            this.evaluateJavaScript();
            return;
        }
        if (!this.getTitle().endsWith(ext)) {
            this.setWindowTitle(SaveDialog.setExtension(this.getTitle(), ext));
        }
        if ((text = (start = this.ta.getSelectionStart()) == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText()).equals("")) {
            return;
        }
        if (ext.equals(".bsh")) {
            plugin = "bsh";
            url = "/plugins/bsh/BeanShell.jar";
        } else {
            plugin = "Jython";
            url = "/plugins/jython/Jython.jar";
        }
        Object obj = IJ.runPlugIn(plugin, text);
        if (obj == null) {
            this.download(url);
        }
    }

    private void download(String url) {
        this.downloadUrl = url;
        Thread thread = new Thread((Runnable)this, "Downloader");
        thread.setPriority(Math.max(thread.getPriority() - 2, 1));
        thread.start();
    }

    void evaluateLine() {
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        if (end > start) {
            this.runMacro(false);
            return;
        }
        String text = this.ta.getText();
        while (start > 0) {
            if (text.charAt(--start) != '\n') continue;
            ++start;
            break;
        }
        while (end < text.length() - 1 && text.charAt(++end) != '\n') {
        }
        this.ta.setSelectionStart(start);
        this.ta.setSelectionEnd(end);
        this.runMacro(false);
    }

    void print() {
        PrintJob pjob = Toolkit.getDefaultToolkit().getPrintJob(this, "Cool Stuff", this.p);
        if (pjob != null) {
            Graphics pg = pjob.getGraphics();
            if (pg != null) {
                String s = this.ta.getText();
                this.printString(pjob, pg, s);
                pg.dispose();
            }
            pjob.end();
        }
    }

    void printString(PrintJob pjob, Graphics pg, String s) {
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        int topMargin = 30;
        int leftMargin = 30;
        int bottomMargin = 30;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics contextt not PrintGraphics");
        }
        if (IJ.isMacintosh()) {
            topMargin = 0;
            leftMargin = 0;
            bottomMargin = 0;
        }
        StringReader sr = new StringReader(s);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height - bottomMargin;
        Font helv = new Font(this.getFontName(), 0, 10);
        pg.setFont(helv);
        FontMetrics fm = pg.getFontMetrics(helv);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = topMargin;
        try {
            String nextLine;
            do {
                if ((nextLine = lnr.readLine()) == null) continue;
                nextLine = this.detabLine(nextLine);
                if (curHeight + fontHeight > pageHeight) {
                    ++pageNum;
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(helv);
                    }
                    curHeight = topMargin;
                }
                curHeight += fontHeight;
                if (pg == null) continue;
                pg.drawString(nextLine, leftMargin, curHeight - fontDescent);
                ++linesForThisPage;
                ++linesForThisJob;
            } while (nextLine != null);
        }
        catch (EOFException eOFException) {
        }
        catch (Throwable t) {
            IJ.handleException(t);
        }
    }

    String detabLine(String s) {
        if (s.indexOf(9) < 0) {
            return s;
        }
        int tabSize = 4;
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.25));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\t') {
                for (int j = 0; j < tabSize; ++j) {
                    sb.append(' ');
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    void undo() {
        if (IJ.isWindows()) {
            IJ.showMessage("Editor", "Press Ctrl-Z to undo");
            return;
        }
        if (IJ.debugMode) {
            IJ.log("Undo1: " + this.undoBuffer.size());
        }
        int position = this.ta.getCaretPosition();
        if (this.undoBuffer.size() > 1) {
            this.undoBuffer.remove(this.undoBuffer.size() - 1);
            String text = (String)this.undoBuffer.get(this.undoBuffer.size() - 1);
            this.performingUndo = true;
            this.ta.setText(text);
            if (position <= text.length()) {
                this.ta.setCaretPosition(position - this.offset(position));
            }
            if (IJ.debugMode) {
                IJ.log("Undo2: " + this.undoBuffer.size() + " " + text);
            }
        }
    }

    boolean copy() {
        String s = this.ta.getSelectedText();
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip != null) {
            StringSelection cont = new StringSelection(s);
            clip.setContents(cont, this);
            return true;
        }
        return false;
    }

    void cut() {
        if (this.copy()) {
            int start = this.ta.getSelectionStart();
            int end = this.ta.getSelectionEnd();
            this.ta.replaceRange("", start - this.offset(start), end - this.offset(end - 2 >= start ? end - 2 : start));
            if (IJ.isMacOSX()) {
                this.ta.setCaretPosition(start);
            }
        }
    }

    private void assignToRepeatCommand() {
        int end;
        String title = this.getTitle();
        if (!title.endsWith(".ijm") && !title.endsWith(".txt") && title.contains(".")) {
            IJ.error("Assign to Repeat Command", "One or more lines of macro code required.");
            return;
        }
        int start = this.ta.getSelectionStart();
        String text = start == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        Executer.setAsRepeatCommand(text);
    }

    void paste() {
        String s = this.ta.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(s);
        try {
            s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            s = e.toString();
        }
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        this.ta.replaceRange(s, start - this.offset(start), end - this.offset(end - 2 >= start ? end - 2 : start));
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(start + s.length());
        }
        this.checkForCurlyQuotes = true;
    }

    private int offset(int pos) {
        if (!IJ.isWindows()) {
            return 0;
        }
        String text = this.ta.getText();
        int rcount = 0;
        for (int i = 0; i <= pos; ++i) {
            if (text.charAt(i) != '\r') continue;
            ++rcount;
        }
        if (IJ.debugMode) {
            IJ.log("offset: " + pos + " " + rcount);
        }
        return pos - rcount >= 0 ? rcount : 0;
    }

    void copyToInfo() {
        int end;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        int start = this.ta.getSelectionStart();
        String text = start == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        imp.setProperty("Info", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean altKeyDown;
        String what = e.getActionCommand();
        int flags = e.getModifiers();
        boolean bl = altKeyDown = (flags & 8) != 0;
        if (e.getSource() == this.runButton) {
            this.runMacro(false);
            return;
        }
        if (e.getSource() == this.installButton) {
            String text = this.ta.getText();
            if (text.contains("macro \"") || text.contains("macro\"")) {
                this.installMacros(text, true);
            } else {
                IJ.error("Editor", "File must contain at least one macro or macro tool.");
            }
            return;
        }
        if ("Save".equals(what)) {
            this.save();
        } else if ("Compile and Run".equals(what)) {
            this.compileAndRun();
        } else if ("Run Macro".equals(what)) {
            if (altKeyDown) {
                this.enableDebugging();
                this.runMacro(true);
            } else {
                this.runMacro(false);
            }
        } else if ("Debug Macro".equals(what)) {
            this.enableDebugging();
            this.runMacro(true);
        } else if ("Step".equals(what)) {
            this.setDebugMode(1);
        } else if ("Trace".equals(what)) {
            this.setDebugMode(2);
        } else if ("Fast Trace".equals(what)) {
            this.setDebugMode(3);
        } else if ("Run".equals(what)) {
            this.setDebugMode(4);
        } else if ("Run to Insertion Point".equals(what)) {
            this.runToInsertionPoint();
        } else if ("Abort".equals(what) || "Abort Macro".equals(what)) {
            Interpreter.abort();
            IJ.beep();
        } else if ("Evaluate Line".equals(what)) {
            this.evaluateLine();
        } else if ("Install Macros".equals(what)) {
            this.installMacros(this.ta.getText(), true);
        } else if ("Macro Functions...".equals(what)) {
            this.showMacroFunctions();
        } else if ("Function Finder...".equals(what)) {
            this.functionFinder = new FunctionFinder(this);
        } else if ("Evaluate Macro".equals(what)) {
            this.evaluateMacro();
        } else if ("Evaluate JavaScript".equals(what)) {
            this.evaluateJavaScript();
        } else if ("Evaluate BeanShell".equals(what)) {
            this.evaluateScript(".bsh");
        } else if ("Evaluate Python".equals(what)) {
            this.evaluateScript(".py");
        } else if ("Show Log Window".equals(what)) {
            this.showLogWindow();
        } else if ("Revert".equals(what)) {
            this.revert();
        } else if ("Print...".equals(what)) {
            this.print();
        } else if (what.startsWith("Undo")) {
            this.undo();
        } else if (what.startsWith("Paste")) {
            this.paste();
        } else if (what.equals("Copy to Image Info")) {
            this.copyToInfo();
        } else if (what.startsWith("Copy")) {
            this.copy();
        } else if (what.startsWith("Cut")) {
            this.cut();
        } else if ("Save As...".equals(what)) {
            this.saveAs();
        } else if ("Select All".equals(what)) {
            this.selectAll();
        } else if ("Find...".equals(what)) {
            this.find(null);
        } else if ("Find Next".equals(what)) {
            this.find(searchString);
        } else if ("Go to Line...".equals(what)) {
            this.gotoLine();
        } else if ("Balance".equals(what)) {
            this.balance();
        } else if ("Detab...".equals(what)) {
            this.detab();
        } else if ("Zap Gremlins".equals(what)) {
            this.zapGremlins();
        } else if ("Make Text Larger".equals(what)) {
            this.changeFontSize(true);
        } else if ("Make Text Smaller".equals(what)) {
            this.changeFontSize(false);
        } else if ("Save Settings".equals(what)) {
            this.saveSettings();
        } else if ("New...".equals(what)) {
            IJ.run("Text Window");
        } else if ("Open...".equals(what)) {
            IJ.open();
        } else if (what.equals("Enter Interactive Mode")) {
            this.enterInteractiveMode();
        } else if (what.equals("Assign to Repeat Cmd")) {
            this.assignToRepeatCommand();
        } else if (what.endsWith(".ijm") || what.endsWith(".java") || what.endsWith(".js") || what.endsWith(".bsh") || what.endsWith(".py")) {
            Editor.openExample(what);
        } else if (altKeyDown) {
            this.enableDebugging();
            this.installer.runMacro(what, this);
        } else {
            this.installer.runMacro(what, null);
        }
    }

    public static boolean openExample(String name) {
        boolean isJava = name.endsWith(".java");
        boolean isJavaScript = name.endsWith(".js");
        boolean isBeanShell = name.endsWith(".bsh");
        boolean isPython = name.endsWith(".py");
        boolean isMacro = name.endsWith(".ijm");
        if (!(isMacro || isJava || isJavaScript || isBeanShell || isPython)) {
            return false;
        }
        boolean run = !isJava && !name.contains("_Tool") && Prefs.autoRunExamples;
        int rows = 24;
        int columns = 70;
        int options = 6;
        if (isMacro) {
            options += 8;
        }
        String text = null;
        Editor ed = new Editor(rows, columns, 0, options);
        String dir = "Macro/";
        if (isJava) {
            dir = "Java/";
        } else if (isJavaScript) {
            dir = "JavaScript/";
        } else if (isBeanShell) {
            dir = "BeanShell/";
        } else if (isPython) {
            dir = "Python/";
        }
        String url = "http://wsr.imagej.net/download/Examples/" + dir + name;
        text = IJ.openUrlAsString(url);
        if (text.startsWith("<Error: ")) {
            IJ.error("Open Example", text);
            return true;
        }
        ed.create(name, text);
        if (run) {
            ed.runMacro(false);
        }
        return true;
    }

    protected void showMacroFunctions() {
        String url = "/developer/macro/functions.html";
        String selText = this.ta.getSelectedText().replace("\n", " ");
        String[] selectedWords = Tools.split(selText, "/,(,[\"'&+");
        if (selectedWords.length == 1 && selectedWords[0].length() > 0) {
            url = url + "#" + selectedWords[0];
        }
        IJ.runPlugIn("ij.plugin.BrowserLauncher", "http://imagej.net/ij" + url);
    }

    final void runToInsertionPoint() {
        Interpreter interp = Interpreter.getInstance();
        if (interp == null) {
            IJ.beep();
        } else {
            this.runToLine = this.getCurrentLine();
            this.setDebugMode(5);
        }
    }

    final int getCurrentLine() {
        int pos = this.ta.getCaretPosition();
        int currentLine = 0;
        String text = this.ta.getText();
        if (IJ.isWindows()) {
            text = text.replaceAll("\r\n", "\n");
        }
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 0;
        int start = 0;
        int end = 0;
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] != '\n') continue;
            ++count;
            start = end;
            end = i;
            if (pos < start || pos >= end) continue;
            currentLine = count;
            break;
        }
        if (currentLine == 0 && pos > end) {
            currentLine = count;
        }
        return currentLine;
    }

    final void enableDebugging() {
        this.step = true;
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        if (start == this.debugStart && end == this.debugEnd) {
            this.ta.select(start, start);
        }
    }

    final void setDebugMode(int mode) {
        this.step = true;
        Interpreter interp = Interpreter.getInstance();
        if (interp != null) {
            if (interp.getDebugger() == null) {
                this.fixLineEndings();
            }
            interp.setDebugger(this);
            interp.setDebugMode(mode);
        }
    }

    @Override
    public void textValueChanged(TextEvent e) {
        String text = this.ta.getText();
        int length = 0;
        if (!this.performingUndo) {
            int i;
            for (i = 0; i < this.undoBuffer.size(); ++i) {
                length += ((String)this.undoBuffer.get(i)).length();
            }
            if (length < 2000000) {
                this.undoBuffer.add(text);
            } else {
                for (i = 1; i < this.undoBuffer.size(); ++i) {
                    this.undoBuffer.set(i - 1, this.undoBuffer.get(i));
                }
                this.undoBuffer.set(this.undoBuffer.size() - 1, text);
            }
        }
        this.performingUndo = false;
        if (this.isMacroWindow) {
            return;
        }
        ++this.eventCount;
        if (this.eventCount > 2 || !IJ.isMacOSX() && this.eventCount > 1) {
            this.changes = true;
        }
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(this.ta.getCaretPosition());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showLinePos();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.showLinePos();
    }

    private void showLinePos() {
        char[] chars = this.ta.getText().toCharArray();
        if ((double)chars.length > 1000000.0) {
            return;
        }
        int selStart = this.ta.getSelectionStart();
        int selEnd = this.ta.getSelectionEnd();
        int line = 0;
        int startLine = 1;
        int endLine = 1;
        for (int i = 1; i <= chars.length; ++i) {
            if (chars[i - 1] == '\n') {
                ++line;
            }
            if (i == selStart) {
                startLine = line + 1;
            }
            if (i <= selEnd) {
                endLine = line + 1;
            }
            if (i >= selEnd) break;
        }
        String msg = "Line " + startLine;
        if (startLine != endLine) {
            msg = msg + "-" + endLine;
        }
        IJ.showStatus(msg);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int pos = this.ta.getCaretPosition();
        if (insertSpaces && pos > 0 && e.getKeyCode() == 9) {
            String spaces = " ";
            for (int i = 1; i < tabInc; ++i) {
                spaces = spaces + " ";
            }
            this.ta.replaceRange(spaces, pos - 1, pos);
        }
        if (this.interactiveMode && e.getKeyChar() == '\n') {
            this.runMacro(e);
        }
    }

    private void runMacro(KeyEvent e) {
        String rtn;
        String code;
        boolean isScript = this.getTitle().endsWith(".js");
        String text = this.ta.getText();
        int pos2 = this.ta.getCaretPosition() - 2;
        if (pos2 < 0) {
            pos2 = 0;
        }
        int pos1 = 0;
        for (int i = pos2; i >= 0; --i) {
            if (i != 0 && text.charAt(i) != '\n') continue;
            pos1 = i;
            break;
        }
        if (isScript) {
            if (this.evaluator == null) {
                this.interpreter = null;
                this.evaluator = new JavaScriptEvaluator();
            }
        } else if (this.interpreter == null) {
            this.evaluator = null;
            this.interpreter = new Interpreter();
        }
        if ((code = text.substring(pos1, pos2 + 1)).length() == 0 || code.equals("\n")) {
            return;
        }
        if (code.length() <= 6 && code.contains("help")) {
            this.ta.appendText("  Type a statement (e.g., \"run('Invert')\") to run it.\n");
            this.ta.appendText("  Enter an expression (e.g., \"x/2\" or \"log(2)\") to evaluate it.\n");
            this.ta.appendText("  Move cursor to end of line and press 'enter' to repeat.\n");
            this.ta.appendText("  \"quit\" - exit interactive mode\n");
            this.ta.appendText("  " + (IJ.isMacOSX() ? "cmd" : "ctrl") + "+M - enter interactive mode\n");
            if (isScript) {
                this.ta.appendText("  \"macro\" - switch language to macro\n");
                this.ta.appendText("  \"examples\" - show JavaScript examples\n");
            } else {
                this.ta.appendText("  " + (IJ.isMacOSX() ? "cmd" : "ctrl") + "+shift+F - open Function Finder\n");
                this.ta.appendText("  \"js\" - switch language to JavaScript\n");
            }
        } else if (isScript && code.length() == 9 && code.contains("examples")) {
            this.ta.appendText(JS_EXAMPLES);
        } else if (code.length() <= 3 && code.contains("js")) {
            this.interactiveMode = false;
            this.interpreter = null;
            this.evaluator = null;
            this.changeExtension(".js");
            this.enterInteractiveMode();
        } else if (code.length() <= 6 && code.contains("macro")) {
            this.interactiveMode = false;
            this.interpreter = null;
            this.evaluator = null;
            this.changeExtension(".txt");
            this.enterInteractiveMode();
        } else if (code.length() <= 6 && code.contains("quit")) {
            this.interactiveMode = false;
            this.interpreter = null;
            this.evaluator = null;
            this.ta.appendText("[Exiting interactive mode.]\n");
        } else if (isScript) {
            ImagePlus imp;
            boolean updateImage = code.contains("ip.");
            code = "load(\"nashorn:mozilla_compat.js\");" + JavaScriptIncludes + code;
            String rtn2 = this.evaluator.eval(code);
            if (rtn2 != null && rtn2.length() > 0) {
                int index = rtn2.indexOf("at line number ");
                if (index > -1) {
                    rtn2 = rtn2.substring(0, index);
                }
                this.insertText(rtn2);
            }
            if (updateImage && (rtn2 == null || rtn2.length() == 0) && (imp = WindowManager.getCurrentImage()) != null) {
                imp.updateAndDraw();
            }
        } else if (!code.startsWith("[Macro ") && !code.contains("waitForUser") && (rtn = this.interpreter.eval(code)) != null) {
            this.insertText(rtn);
        }
    }

    private void changeExtension(String ext) {
        String title = this.getTitle();
        int index = title.indexOf(".");
        if (index > -1) {
            title = title.substring(0, index);
        }
        this.setTitle(title + ext);
    }

    private void enterInteractiveMode() {
        if (this.interactiveMode) {
            return;
        }
        String title = this.getTitle();
        if (this.ta != null && this.ta.getText().length() > 400 && !title.startsWith("Untitled") && !title.startsWith(INTERACTIVE_NAME)) {
            GenericDialog gd = new GenericDialog("Enter Interactive Mode");
            gd.addMessage("Enter mode that supports interactive\nediting and running of macros and scripts?");
            gd.setOKLabel("Enter");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
        }
        String language = title.endsWith(".js") ? "JavaScript " : "Macro ";
        ++this.messageCount;
        String help = this.messageCount <= 2 ? " Type \"help\" for info." : "";
        this.ta.appendText("[" + language + "interactive mode." + help + "]\n");
        this.interactiveMode = true;
    }

    public void insertText(String text) {
        if (this.ta == null) {
            return;
        }
        int start = this.ta.getSelectionStart();
        this.ta.replaceRange("  " + text + "\n", start, start);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String cmd = e.getItem().toString();
        if (e.getSource() == this.language) {
            this.setExtension(cmd);
            return;
        }
        CheckboxMenuItem item = (CheckboxMenuItem)e.getSource();
        if ("Tab Key Inserts Spaces".equals(cmd)) {
            insertSpaces = e.getStateChange() == 1;
            Prefs.set(INSERT_SPACES, insertSpaces);
        } else {
            this.setFont();
        }
    }

    private void setExtension(String language) {
        String title = this.getTitle();
        int dot = title.lastIndexOf(".");
        if (dot >= 0) {
            title = title.substring(0, dot);
        }
        for (int i = 0; i < languages.length; ++i) {
            if (!language.equals(languages[i])) continue;
            title = title + extensions[i];
            break;
        }
        this.setWindowTitle(title);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (IJ.debugMode) {
            IJ.log("Editor.windowActivated");
        }
        WindowManager.setWindow(this);
        instance = this;
    }

    @Override
    public void close() {
        boolean okayToClose = true;
        ImageJ ij = IJ.getInstance();
        if (!this.getTitle().equals("Errors") && this.changes && !IJ.isMacro() && ij != null && !ij.quittingViaMacro()) {
            String msg = "Save changes to \"" + this.getTitle() + "\"?";
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "Editor", msg);
            if (d.cancelPressed()) {
                okayToClose = false;
            } else if (d.yesPressed()) {
                this.save();
            }
        }
        if (okayToClose) {
            this.dispose();
            WindowManager.removeWindow(this);
            --nWindows;
            instance = null;
            this.changes = false;
            if (this.functionFinder != null) {
                this.functionFinder.close();
            }
        }
    }

    public void saveAs() {
        String name1 = this.getTitle();
        if (name1.indexOf(".") == -1) {
            name1 = name1 + ".txt";
        }
        if (defaultDir != null && name1.endsWith(".java") && !defaultDir.startsWith(Menus.getPlugInsPath())) {
            defaultDir = null;
        }
        if (defaultDir == null) {
            defaultDir = name1.endsWith(".txt") || name1.endsWith(".ijm") ? Menus.getMacrosPath() : Menus.getPlugInsPath();
        }
        SaveDialog sd = new SaveDialog("Save As...", defaultDir, name1, null);
        String name2 = sd.getFileName();
        String dir = sd.getDirectory();
        if (name2 != null) {
            if (name2.endsWith(".java")) {
                this.updateClassName(name1, name2);
            }
            this.path = dir + name2;
            this.save();
            this.changes = false;
            this.setWindowTitle(name2);
            Editor.setDefaultDirectory(dir);
            if (defaultDir != null) {
                Prefs.set(DEFAULT_DIR, defaultDir);
            }
            if (IJ.recording()) {
                Recorder.record("saveAs", "Text", this.path);
            }
        }
    }

    protected void revert() {
        if (!this.changes) {
            return;
        }
        String title = this.getTitle();
        if (this.path == null || !new File(this.path).exists() || !this.path.endsWith(title)) {
            IJ.showStatus("Cannot revert, no file " + this.getTitle());
            return;
        }
        if (!IJ.showMessageWithCancel("Revert?", "Revert to saved version of\n\"" + this.getTitle() + "\"?")) {
            return;
        }
        String directory = this.path.substring(0, this.path.length() - title.length());
        this.open(directory, title);
        this.undoBuffer = new ArrayList();
    }

    public void updateClassName(String oldName, String newName) {
        if (newName.indexOf("_") < 0) {
            IJ.showMessage("Plugin Editor", "Plugins without an underscore in their name will not\nbe automatically installed when ImageJ is restarted.");
        }
        if (oldName.equals(newName) || !oldName.endsWith(".java") || !newName.endsWith(".java")) {
            return;
        }
        oldName = oldName.substring(0, oldName.length() - 5);
        newName = newName.substring(0, newName.length() - 5);
        String text1 = this.ta.getText();
        int index = text1.indexOf("public class " + oldName);
        if (index < 0) {
            return;
        }
        String text2 = text1.substring(0, index + 13) + newName + text1.substring(index + 13 + oldName.length(), text1.length());
        this.ta.setText(text2);
    }

    void find(String s) {
        if (s == null) {
            GenericDialog gd = new GenericDialog("Find", this);
            gd.addStringField("Find: ", searchString, 20);
            String[] labels = new String[]{"Case Sensitive", "Whole Words"};
            boolean[] states = new boolean[]{caseSensitive, wholeWords};
            gd.addCheckboxGroup(1, 2, labels, states);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            s = gd.getNextString();
            caseSensitive = gd.getNextBoolean();
            wholeWords = gd.getNextBoolean();
            Prefs.set(CASE_SENSITIVE, caseSensitive);
        }
        if (s.equals("")) {
            return;
        }
        String text = this.ta.getText();
        String s2 = s;
        if (!caseSensitive) {
            text = text.toLowerCase(Locale.US);
            s = s.toLowerCase(Locale.US);
        }
        int index = -1;
        if (wholeWords) {
            int position = this.ta.getCaretPosition() + 1;
            while ((index = text.indexOf(s, position)) != -1 && !this.isWholeWordMatch(text, s, index)) {
                position = index + 1;
                if (position < text.length() - 1) continue;
                index = -1;
                break;
            }
        } else {
            index = text.indexOf(s, this.ta.getCaretPosition() + 1);
        }
        searchString = s2;
        if (index < 0) {
            IJ.beep();
            return;
        }
        this.ta.select(index, index + s.length());
    }

    boolean isWholeWordMatch(String text, String word, int index) {
        char c;
        char c2 = c = index == 0 ? (char)' ' : text.charAt(index - 1);
        if (Character.isLetterOrDigit(c) || c == '_') {
            return false;
        }
        char c3 = c = index + word.length() >= text.length() ? (char)' ' : text.charAt(index + word.length());
        return !Character.isLetterOrDigit(c) && c != 95;
    }

    void gotoLine() {
        GenericDialog gd = new GenericDialog("Go to Line", this);
        gd.addNumericField("Go to line number: ", lineNumber, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        if (n < 1) {
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 1;
        int loc = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\n') {
                ++count;
            }
            if (count != n) continue;
            loc = i + 1;
            break;
        }
        this.ta.setCaretPosition(loc);
        lineNumber = n;
    }

    private void balance() {
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        this.maskComments(chars);
        this.maskQuotes(chars);
        int position = this.ta.getCaretPosition();
        if (position == 0) {
            IJ.error("Balance", "This command locates the pair of brackets, curly braces or\nparentheses that surround the insertion point.");
            return;
        }
        int start = -1;
        int stop = -1;
        String leftBows = "";
        for (int i = position - 1; i >= 0; --i) {
            char ch = chars[i];
            if ("({[]})".indexOf(ch) < 0) continue;
            leftBows = ch + leftBows;
            leftBows = leftBows.replace("[]", "");
            leftBows = leftBows.replace("()", "");
            if (!(leftBows = leftBows.replace("{}", "")).equals("[") && !leftBows.equals("{") && !leftBows.equals("(")) continue;
            start = i;
            break;
        }
        String rightBows = "";
        for (int i = position; i < chars.length; ++i) {
            char ch = chars[i];
            if ("({[]})".indexOf(ch) < 0) continue;
            rightBows = rightBows + ch;
            rightBows = rightBows.replace("[]", "");
            rightBows = rightBows.replace("()", "");
            rightBows = rightBows.replace("{}", "");
            String pair = leftBows + rightBows;
            if (!pair.equals("[]") && !pair.equals("{}") && !pair.equals("()")) continue;
            stop = i;
            break;
        }
        if (start == -1 || stop == -1) {
            IJ.beep();
            return;
        }
        this.ta.setSelectionStart(start);
        this.ta.setSelectionEnd(stop + 1);
        IJ.showStatus(chars.length + " " + position + " " + start + " " + stop);
    }

    private void maskComments(char[] chars) {
        int n = chars.length;
        boolean inSlashSlashComment = false;
        boolean inSlashStarComment = false;
        for (int i = 0; i < n - 1; ++i) {
            if (chars[i] == '/' && chars[i + 1] == '/') {
                inSlashSlashComment = true;
            }
            if (chars[i] == '\n') {
                inSlashSlashComment = false;
            }
            if (!inSlashSlashComment) {
                if (chars[i] == '/' && chars[i + 1] == '*') {
                    inSlashStarComment = true;
                }
                if (chars[i] == '*' && chars[i + 1] == '/') {
                    inSlashStarComment = false;
                }
            }
            if (!inSlashSlashComment && !inSlashStarComment) continue;
            chars[i] = 32;
        }
    }

    private void maskQuotes(char[] chars) {
        int n = chars.length;
        char quote = '\'';
        for (int loop = 1; loop <= 2; ++loop) {
            if (loop == 2) {
                quote = '\"';
            }
            boolean inQuotes = false;
            int startMask = 0;
            int stopMask = 0;
            for (int i = 0; i < n - 1; ++i) {
                boolean escaped;
                boolean bl = escaped = i > 0 && chars[i - 1] == '\\';
                if (chars[i] == '\n') {
                    inQuotes = false;
                }
                if (chars[i] != quote || escaped) continue;
                if (!inQuotes) {
                    startMask = i;
                    inQuotes = true;
                    continue;
                }
                stopMask = i;
                for (int jj = startMask; jj <= stopMask; ++jj) {
                    chars[jj] = 32;
                }
                inQuotes = false;
            }
        }
    }

    private void rmaskComments(char[] chars) {
        int n = chars.length;
        boolean inSlashSlashComment = false;
        boolean inSlashStarComment = false;
        for (int i = 0; i < n - 1; ++i) {
            if (chars[i] == '/' && chars[i + 1] == '/') {
                inSlashSlashComment = true;
            }
            if (chars[i] == '\n') {
                inSlashSlashComment = false;
            }
            if (chars[i] == '/' && chars[i + 1] == '*') {
                inSlashStarComment = true;
            }
            if (chars[i] == '*' && chars[i + 1] == '/') {
                inSlashStarComment = false;
            }
            if (!inSlashSlashComment && !inSlashStarComment) continue;
            chars[i] = 32;
        }
    }

    void zapGremlins() {
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!(inQuotes || c != '\"' && c != '\'')) {
                inQuotes = true;
                quoteChar = c;
            } else if (inQuotes && (c == quoteChar || c == '\n')) {
                inQuotes = false;
            }
            if (inQuotes || c == '\n' || c == '\t' || c >= ' ' && c <= '\u007f') continue;
            ++count;
            chars[i] = 32;
        }
        if (count > 0) {
            text = new String(chars);
            this.ta.setText(text);
        }
        if (count > 0) {
            IJ.showMessage("Zap Gremlins", count + " invalid characters converted to spaces");
        } else {
            IJ.showMessage("Zap Gremlins", "No invalid characters found");
        }
    }

    private void detab() {
        GenericDialog gd = new GenericDialog("Detab", this);
        gd.addNumericField("Spaces per tab: ", tabInc, 0);
        gd.addCheckbox("Tab key inserts spaces: ", insertSpaces);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int tabInc2 = tabInc;
        tabInc = (int)gd.getNextNumber();
        if (tabInc < 1) {
            tabInc = 1;
        }
        if (tabInc > 8) {
            tabInc = 8;
        }
        if (tabInc != tabInc2) {
            Prefs.set(TAB_INC, tabInc);
        }
        boolean insertSpaces2 = insertSpaces;
        insertSpaces = gd.getNextBoolean();
        if (insertSpaces != insertSpaces2) {
            Prefs.set(INSERT_SPACES, insertSpaces);
            this.insertSpacesItem.setState(insertSpaces);
        }
        int nb = 0;
        int pos = 1;
        String text = this.ta.getText();
        if (text.indexOf(9) < 0) {
            return;
        }
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        StringBuffer sb = new StringBuffer((int)((double)chars.length * 1.25));
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\t') {
                for (nb = tabInc - (pos - 1) % tabInc; nb > 0; --nb) {
                    sb.append(' ');
                    ++pos;
                }
                continue;
            }
            if (c == '\n') {
                sb.append(c);
                pos = 1;
                continue;
            }
            sb.append(c);
            ++pos;
        }
        this.ta.setText(sb.toString());
    }

    void selectAll() {
        this.ta.selectAll();
        this.showLinePos();
    }

    void changeFontSize(boolean larger) {
        int in = this.fontSizeIndex++;
        if (larger) {
            if (this.fontSizeIndex == this.sizes.length) {
                this.fontSizeIndex = this.sizes.length - 1;
            }
        } else {
            --this.fontSizeIndex;
            if (this.fontSizeIndex < 0) {
                this.fontSizeIndex = 0;
            }
        }
        IJ.showStatus(this.sizes[this.fontSizeIndex] + " point");
        this.setFont();
    }

    void saveSettings() {
        Prefs.set(FONT_SIZE, this.fontSizeIndex);
        Prefs.set(FONT_MONO, this.monospaced.getState());
        IJ.showStatus("Font settings saved (size=" + this.sizes[this.fontSizeIndex] + ", monospaced=" + this.monospaced.getState() + ")");
    }

    void setFont() {
        this.ta.setFont(new Font(this.getFontName(), 0, this.sizes[this.fontSizeIndex]));
    }

    String getFontName() {
        return this.monospaced.getState() ? "Monospaced" : "SansSerif";
    }

    @Override
    public void setFont(Font font) {
        this.ta.setFont(font);
    }

    public int getFontSize() {
        return this.sizes[this.fontSizeIndex];
    }

    public void append(String s) {
        this.ta.append(s);
    }

    public void setIsMacroWindow(boolean mw) {
        this.isMacroWindow = mw;
    }

    public static void setDefaultDirectory(String dir) {
        defaultDir = dir = IJ.addSeparator(dir);
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    @Override
    public int debug(Interpreter interp, int mode) {
        int len;
        if (IJ.debugMode) {
            IJ.log("debug: " + interp.getLineNumber() + "  " + mode + "  " + interp);
        }
        if (mode == 4) {
            return 0;
        }
        int n = interp.getLineNumber();
        if (mode == 5) {
            if (n == this.runToLine) {
                mode = 1;
                interp.setDebugMode(mode);
            } else {
                return 0;
            }
        }
        if (!this.isVisible()) {
            interp.abortMacro();
            return 0;
        }
        if (n == this.previousLine) {
            this.previousLine = 0;
            return 0;
        }
        Window win = WindowManager.getActiveWindow();
        if (win != this) {
            IJ.wait(50);
        }
        this.toFront();
        this.previousLine = n;
        String text = this.ta.getText();
        if (IJ.isWindows()) {
            text = text.replaceAll("\r\n", "\n");
        }
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 1;
        this.debugStart = 0;
        this.debugEnd = len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '\n') {
                ++count;
            }
            if (count == n && this.debugStart == 0) {
                this.debugStart = i + 1;
                continue;
            }
            if (count != n + 1) continue;
            this.debugEnd = i;
            break;
        }
        if (this.debugStart == 1) {
            this.debugStart = 0;
        }
        if ((this.debugStart == 0 || this.debugStart == len) && this.debugEnd == len) {
            return 0;
        }
        this.ta.select(this.debugStart, this.debugEnd);
        if (debugWindow != null && !debugWindow.isShowing()) {
            interp.setDebugger(null);
            debugWindow = null;
        } else {
            debugWindow = interp.updateDebugWindow(interp.getVariables(), debugWindow);
        }
        if (debugWindow != null) {
            interp.updateArrayInspector();
            this.toFront();
        }
        if (mode == 1) {
            this.step = false;
            while (!this.step && !interp.done() && this.isVisible()) {
                IJ.wait(5);
            }
        } else if (mode == 3) {
            IJ.wait(5);
        } else {
            IJ.wait(150);
        }
        return 0;
    }

    public static Editor getInstance() {
        return instance;
    }

    public static String getJSPrefix(String arg) {
        if (arg == null) {
            arg = "";
        }
        return JavaScriptIncludes + "function getArgument() {return \"" + arg + "\";};";
    }

    public void fixLineEndings() {
        if (!IJ.isWindows()) {
            return;
        }
        String text = this.ta.getText();
        text = text.replaceAll("\r\n", "\n");
        this.ta.setText(text);
    }

    public void showLogWindow() {
        Frame log = WindowManager.getFrame("Log");
        if (log != null) {
            log.toFront();
        } else {
            IJ.log("");
        }
    }

    public boolean fileChanged() {
        return this.changes;
    }

    @Override
    public void run() {
        if (this.downloading || this.downloadUrl == null) {
            return;
        }
        this.downloading = true;
        boolean ok = Macro_Runner.downloadJar(this.downloadUrl);
        this.downloading = false;
    }

    static {
        searchString = "";
        caseSensitive = Prefs.get(CASE_SENSITIVE, true);
        lineNumber = 1;
        defaultDir = Prefs.get(DEFAULT_DIR, null);
        tabInc = (int)Prefs.get(TAB_INC, 3.0);
        insertSpaces = Prefs.get(INSERT_SPACES, false);
    }
}

