/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.FormatException;
import io.scif.UnsupportedCompressionException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.BitBuffer;
import io.scif.codec.ByteVector;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import io.scif.codec.CodecService;
import io.scif.codec.HuffmanCodec;
import io.scif.codec.HuffmanCodecOptions;
import java.io.IOException;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;
import org.scijava.util.ShortArray;

@Plugin(type=Codec.class)
public class LosslessJPEGCodec
extends AbstractCodec {
    public static final int SOF0 = 65472;
    public static final int SOF1 = 65473;
    public static final int SOF2 = 65474;
    public static final int SOF3 = 65475;
    public static final int SOF5 = 65477;
    public static final int SOF6 = 65478;
    public static final int SOF7 = 65479;
    public static final int JPG = 65480;
    public static final int SOF9 = 65481;
    public static final int SOF10 = 65482;
    public static final int SOF11 = 65483;
    public static final int SOF13 = 65485;
    public static final int SOF14 = 65486;
    public static final int SOF15 = 65487;
    public static final int DHT = 65476;
    public static final int DAC = 65484;
    public static final int RST_0 = 65488;
    public static final int RST_1 = 65489;
    public static final int RST_2 = 65490;
    public static final int RST_3 = 65491;
    public static final int RST_4 = 65492;
    public static final int RST_5 = 65493;
    public static final int RST_6 = 65494;
    public static final int RST_7 = 65495;
    public static final int SOI = 65496;
    public static final int EOI = 65497;
    public static final int SOS = 65498;
    public static final int DQT = 65499;
    public static final int DNL = 65500;
    public static final int DRI = 65501;
    public static final int DHP = 65502;
    public static final int EXP = 65503;
    public static final int COM = 65534;
    @Parameter
    private CodecService codecService;

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("Lossless JPEG compression not supported");
    }

    @Override
    public byte[] decompress(DataHandle<Location> in, CodecOptions options) throws FormatException, IOException {
        int i;
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[] buf = new byte[]{};
        short width = 0;
        short height = 0;
        int bitsPerSample = 0;
        int nComponents = 0;
        int bytesPerSample = 0;
        int[] horizontalSampling = null;
        int[] verticalSampling = null;
        int[] quantizationTable = null;
        Object huffmanTables = null;
        int startPredictor = 0;
        int[] dcTable = null;
        int[] acTable = null;
        while (in.offset() < in.length() - 1L) {
            int code = in.readShort() & 0xFFFF;
            int length = in.readShort() & 0xFFFF;
            long fp = in.offset();
            if (length > 65280) {
                length = 0;
                in.seek(fp - 2L);
                continue;
            }
            if (code == 65498) {
                nComponents = in.read();
                dcTable = new int[nComponents];
                acTable = new int[nComponents];
                for (int i2 = 0; i2 < nComponents; ++i2) {
                    in.read();
                    int tableSelector = in.read();
                    dcTable[i2] = (tableSelector & 0xF0) >> 4;
                    acTable[i2] = tableSelector & 0xF;
                }
                startPredictor = in.read();
                in.read();
                in.read();
                byte[] toDecode = new byte[(int)(in.length() - in.offset())];
                in.read(toDecode);
                ByteVector b = new ByteVector();
                for (int i3 = 0; i3 < toDecode.length; ++i3) {
                    b.add(toDecode[i3]);
                    if (toDecode[i3] != -1 || toDecode[i3 + 1] != 0) continue;
                    ++i3;
                }
                toDecode = b.toByteArray();
                BitBuffer bb = new BitBuffer(toDecode);
                HuffmanCodec huffman = this.codecService.getCodec(HuffmanCodec.class);
                HuffmanCodecOptions huffmanOptions = new HuffmanCodecOptions();
                huffmanOptions.bitsPerSample = bitsPerSample;
                huffmanOptions.maxBytes = buf.length / nComponents;
                for (int nextSample = 0; nextSample < buf.length / nComponents; nextSample += bytesPerSample) {
                    for (int i4 = 0; i4 < nComponents; ++i4) {
                        int sampleC;
                        if (huffmanTables != null) {
                            huffmanOptions.table = huffmanTables[dcTable[i4]];
                        }
                        int v = 0;
                        if (huffmanOptions.table != null) {
                            v = huffman.getSample(bb, huffmanOptions);
                            if (nextSample == 0) {
                                v += (int)Math.pow(2.0, bitsPerSample - 1);
                            }
                        } else {
                            throw new UnsupportedCompressionException("Arithmetic coding not supported");
                        }
                        int predictor = startPredictor;
                        if (nextSample < width * bytesPerSample) {
                            predictor = 1;
                        } else if (nextSample % (width * bytesPerSample) == 0) {
                            predictor = 2;
                        }
                        int componentOffset = i4 * (buf.length / nComponents);
                        int indexA = nextSample - bytesPerSample + componentOffset;
                        int indexB = nextSample - width * bytesPerSample + componentOffset;
                        int indexC = nextSample - (width + 1) * bytesPerSample + componentOffset;
                        int sampleA = indexA < 0 ? 0 : Bytes.toInt((byte[])buf, (int)indexA, (int)bytesPerSample, (boolean)false);
                        int sampleB = indexB < 0 ? 0 : Bytes.toInt((byte[])buf, (int)indexB, (int)bytesPerSample, (boolean)false);
                        int n = sampleC = indexC < 0 ? 0 : Bytes.toInt((byte[])buf, (int)indexC, (int)bytesPerSample, (boolean)false);
                        if (nextSample > 0) {
                            int pred = 0;
                            switch (predictor) {
                                case 1: {
                                    pred = sampleA;
                                    break;
                                }
                                case 2: {
                                    pred = sampleB;
                                    break;
                                }
                                case 3: {
                                    pred = sampleC;
                                    break;
                                }
                                case 4: {
                                    pred = sampleA + sampleB + sampleC;
                                    break;
                                }
                                case 5: {
                                    pred = sampleA + (sampleB - sampleC) / 2;
                                    break;
                                }
                                case 6: {
                                    pred = sampleB + (sampleA - sampleC) / 2;
                                    break;
                                }
                                case 7: {
                                    pred = (sampleA + sampleB) / 2;
                                }
                            }
                            v += pred;
                        }
                        int offset = componentOffset + nextSample;
                        Bytes.unpack((long)v, (byte[])buf, (int)offset, (int)bytesPerSample, (boolean)false);
                    }
                }
                continue;
            }
            if ((length -= 2) == 0) continue;
            if (code != 65497) {
                if (code == 65475) {
                    bitsPerSample = in.read();
                    height = in.readShort();
                    width = in.readShort();
                    nComponents = in.read();
                    horizontalSampling = new int[nComponents];
                    verticalSampling = new int[nComponents];
                    quantizationTable = new int[nComponents];
                    for (int i5 = 0; i5 < nComponents; ++i5) {
                        in.skipBytes(1);
                        int s = in.read();
                        horizontalSampling[i5] = (s & 0xF0) >> 4;
                        verticalSampling[i5] = s & 0xF;
                        quantizationTable[i5] = in.read();
                    }
                    bytesPerSample = bitsPerSample / 8;
                    if (bitsPerSample % 8 != 0) {
                        ++bytesPerSample;
                    }
                    buf = new byte[width * height * nComponents * bytesPerSample];
                } else {
                    if (code == 65483) {
                        throw new UnsupportedCompressionException("Arithmetic coding is not yet supported");
                    }
                    if (code == 65476) {
                        int i6;
                        if (huffmanTables == null) {
                            huffmanTables = new short[4][];
                        }
                        int s = in.read();
                        byte destination = (byte)(s & 0xF);
                        int[] nCodes = new int[16];
                        ShortArray table = new ShortArray();
                        for (i6 = 0; i6 < nCodes.length; ++i6) {
                            nCodes[i6] = in.read();
                            table.add((Object)((short)nCodes[i6]));
                        }
                        for (i6 = 0; i6 < nCodes.length; ++i6) {
                            for (int j = 0; j < nCodes[i6]; ++j) {
                                table.add((Object)new Short((short)(in.read() & 0xFF)));
                            }
                        }
                        huffmanTables[destination] = new short[table.size()];
                        for (i6 = 0; i6 < huffmanTables[destination].length; ++i6) {
                            huffmanTables[destination][i6] = table.getValue(i6);
                        }
                    }
                }
            }
            in.seek(fp + (long)length);
        }
        if (options.interleaved && nComponents > 1) {
            byte[] newBuf = new byte[buf.length];
            for (i = 0; i < buf.length; i += nComponents * bytesPerSample) {
                for (int c = 0; c < nComponents; ++c) {
                    int src = c * (buf.length / nComponents) + i / nComponents;
                    int dst = i + c * bytesPerSample;
                    System.arraycopy(buf, src, newBuf, dst, bytesPerSample);
                }
            }
            buf = newBuf;
        }
        if (options.littleEndian && bytesPerSample > 1) {
            byte[] newBuf = new byte[buf.length];
            for (i = 0; i < buf.length; i += bytesPerSample) {
                for (int q = 0; q < bytesPerSample; ++q) {
                    newBuf[i + bytesPerSample - q - 1] = buf[i + q];
                }
            }
            buf = newBuf;
        }
        return buf;
    }
}

