/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.tiff;

import io.scif.FormatException;
import io.scif.SCIFIO;
import io.scif.codec.BitBuffer;
import io.scif.codec.CodecOptions;
import io.scif.enumeration.EnumException;
import io.scif.formats.tiff.FillOrder;
import io.scif.formats.tiff.IFD;
import io.scif.formats.tiff.IFDList;
import io.scif.formats.tiff.IFDType;
import io.scif.formats.tiff.OnDemandLongArray;
import io.scif.formats.tiff.PhotoInterp;
import io.scif.formats.tiff.TiffCompression;
import io.scif.formats.tiff.TiffIFDEntry;
import io.scif.formats.tiff.TiffRational;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.log.LogService;
import org.scijava.util.Bytes;
import org.scijava.util.IntRect;

public class TiffParser
extends AbstractContextual
implements Closeable {
    private final DataHandle<Location> in;
    private byte[] cachedTileBuffer;
    private boolean bigTiff;
    private boolean fakeBigTiff = false;
    private boolean ycbcrCorrection = true;
    private boolean equalStrips = false;
    private boolean doCaching;
    private IFDList ifdList;
    private IFD firstIFD;
    private final SCIFIO scifio;
    private final LogService log;
    private CodecOptions codecOptions = CodecOptions.getDefaultOptions();
    private static final byte[] REVERSE = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};

    public TiffParser(Context context, Location loc) {
        this(context, (DataHandle<Location>)((DataHandle)((DataHandleService)context.getService(DataHandleService.class)).create((Object)loc)));
    }

    public TiffParser(Context context, DataHandle<Location> in) {
        this.setContext(context);
        this.scifio = new SCIFIO(context);
        this.log = this.scifio.log();
        this.in = in;
        this.doCaching = true;
        try {
            long fp = in.offset();
            if (this.checkHeader() != null) {
                in.seek(fp);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setAssumeEqualStrips(boolean equalStrips) {
        this.equalStrips = equalStrips;
    }

    public void setCodecOptions(CodecOptions codecOptions) {
        this.codecOptions = codecOptions;
    }

    public CodecOptions getCodecOptions() {
        return this.codecOptions;
    }

    public void setDoCaching(boolean doCaching) {
        this.doCaching = doCaching;
    }

    public void setUse64BitOffsets(boolean use64Bit) {
        this.fakeBigTiff = use64Bit;
    }

    public void setYCbCrCorrection(boolean correctionAllowed) {
        this.ycbcrCorrection = correctionAllowed;
    }

    public DataHandle<Location> getStream() {
        return this.in;
    }

    public boolean isValidHeader() {
        try {
            return this.checkHeader() != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Boolean checkHeader() throws IOException {
        boolean bigEndian;
        if (this.in.length() < 4L) {
            return null;
        }
        this.in.seek(0L);
        int endianOne = this.in.read();
        int endianTwo = this.in.read();
        boolean littleEndian = endianOne == 73 && endianTwo == 73;
        boolean bl = bigEndian = endianOne == 77 && endianTwo == 77;
        if (!littleEndian && !bigEndian) {
            return null;
        }
        this.in.setLittleEndian(littleEndian);
        short magic = this.in.readShort();
        boolean bl2 = this.bigTiff = magic == 43;
        if (magic != 42 && magic != 43) {
            return null;
        }
        return littleEndian;
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public IFDList getIFDs() throws IOException {
        if (this.ifdList != null) {
            return this.ifdList;
        }
        long[] offsets = this.getIFDOffsets();
        IFDList ifds = new IFDList();
        for (long offset : offsets) {
            IFD ifd = this.getIFD(offset);
            if (ifd == null) continue;
            if (ifd.containsKey(256)) {
                ifds.add(ifd);
            }
            long[] subOffsets = null;
            try {
                if (!this.doCaching && ifd.containsKey(330)) {
                    this.fillInIFD(ifd);
                }
                subOffsets = ifd.getIFDLongArray(330);
            }
            catch (FormatException formatException) {
                // empty catch block
            }
            if (subOffsets == null) continue;
            for (long subOffset : subOffsets) {
                IFD sub = this.getIFD(subOffset);
                if (sub == null) continue;
                ifds.add(sub);
            }
        }
        if (this.doCaching) {
            this.ifdList = ifds;
        }
        return ifds;
    }

    public IFDList getThumbnailIFDs() throws IOException {
        IFDList ifds = this.getIFDs();
        IFDList thumbnails = new IFDList();
        for (IFD ifd : ifds) {
            Number subfile = (Number)ifd.getIFDValue(254);
            int subfileType = subfile == null ? 0 : subfile.intValue();
            if (subfileType != 1) continue;
            thumbnails.add(ifd);
        }
        return thumbnails;
    }

    public IFDList getNonThumbnailIFDs() throws IOException {
        IFDList ifds = this.getIFDs();
        IFDList nonThumbs = new IFDList();
        for (IFD ifd : ifds) {
            int subfileType;
            Number subfile = (Number)ifd.getIFDValue(254);
            int n = subfileType = subfile == null ? 0 : subfile.intValue();
            if (subfileType == 1 && ifds.size() > 1) continue;
            nonThumbs.add(ifd);
        }
        return nonThumbs;
    }

    public IFDList getExifIFDs() throws FormatException, IOException {
        IFDList ifds = this.getIFDs();
        IFDList exif = new IFDList();
        for (IFD ifd : ifds) {
            IFD exifIFD;
            long offset = ifd.getIFDLongValue(34665, 0L);
            if (offset == 0L || (exifIFD = this.getIFD(offset)) == null) continue;
            exif.add(exifIFD);
        }
        return exif;
    }

    public long[] getIFDOffsets() throws IOException {
        int bytesPerEntry = this.bigTiff ? 20 : 12;
        Vector<Long> offsets = new Vector<Long>();
        long offset = this.getFirstOffset();
        while (offset > 0L && offset < this.in.length()) {
            this.in.seek(offset);
            offsets.add(offset);
            int nEntries = this.bigTiff ? (int)this.in.readLong() : this.in.readUnsignedShort();
            this.in.skipBytes(nEntries * bytesPerEntry);
            offset = this.getNextOffset(offset);
        }
        long[] f = new long[offsets.size()];
        for (int i = 0; i < f.length; ++i) {
            f[i] = (Long)offsets.get(i);
        }
        return f;
    }

    public IFD getFirstIFD() throws IOException {
        if (this.firstIFD != null) {
            return this.firstIFD;
        }
        long offset = this.getFirstOffset();
        IFD ifd = this.getIFD(offset);
        if (this.doCaching) {
            this.firstIFD = ifd;
        }
        return ifd;
    }

    public TiffIFDEntry getFirstIFDEntry(int tag) throws IOException {
        long offset = this.getFirstOffset();
        if (offset < 0L) {
            return null;
        }
        this.in.seek(offset);
        long numEntries = this.bigTiff ? this.in.readLong() : (long)this.in.readUnsignedShort();
        int i = 0;
        while ((long)i < numEntries) {
            this.in.seek(offset + (long)(this.bigTiff ? 8 : 2) + (long)((this.bigTiff ? 20 : 12) * i));
            TiffIFDEntry entry = this.readTiffIFDEntry();
            if (entry.getTag() == tag) {
                return entry;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown tag: " + tag);
    }

    public long getFirstOffset() throws IOException {
        Boolean header = this.checkHeader();
        if (header == null) {
            return -1L;
        }
        if (this.bigTiff) {
            this.in.skipBytes(4);
        }
        return this.getNextOffset(0L);
    }

    public IFD getIFD(long offset) throws IOException {
        if (offset < 0L || offset >= this.in.length()) {
            return null;
        }
        IFD ifd = new IFD(this.log);
        ifd.put(new Integer(0), this.in.isLittleEndian());
        ifd.put(new Integer(1), this.bigTiff);
        this.log.trace((Object)("getIFDs: seeking IFD at " + offset));
        this.in.seek(offset);
        long numEntries = this.bigTiff ? this.in.readLong() : (long)this.in.readUnsignedShort();
        this.log.trace((Object)("getIFDs: " + numEntries + " directory entries to read"));
        if (numEntries == 0L || numEntries == 1L) {
            return ifd;
        }
        int bytesPerEntry = this.bigTiff ? 20 : 12;
        int baseOffset = this.bigTiff ? 8 : 2;
        int i = 0;
        while ((long)i < numEntries) {
            this.in.seek(offset + (long)baseOffset + (long)(bytesPerEntry * i));
            TiffIFDEntry entry = null;
            try {
                entry = this.readTiffIFDEntry();
            }
            catch (EnumException e) {
                this.log.debug((Object)"", (Throwable)e);
            }
            if (entry == null) break;
            int count = entry.getValueCount();
            int tag = entry.getTag();
            long pointer = entry.getValueOffset();
            int bpe = entry.getType().getBytesPerElement();
            if (count < 0 || bpe <= 0) {
                this.in.skipBytes(bytesPerEntry - 4 - (this.bigTiff ? 8 : 4));
            } else {
                Object value = null;
                long inputLen = this.in.length();
                if ((long)(count * bpe) + pointer > inputLen) {
                    int oldCount = count;
                    count = (int)((inputLen - pointer) / (long)bpe);
                    this.log.trace((Object)("getIFDs: truncated " + (oldCount - count) + " array elements for tag " + tag));
                    if (count < 0) {
                        count = oldCount;
                    }
                    entry = new TiffIFDEntry(entry.getTag(), entry.getType(), count, entry.getValueOffset());
                }
                if (count < 0 || (long)count > this.in.length()) break;
                value = pointer != this.in.offset() && !this.doCaching ? entry : this.getIFDValue(entry);
                if (value != null && !ifd.containsKey(new Integer(tag))) {
                    ifd.put(new Integer(tag), value);
                }
            }
            ++i;
        }
        this.in.seek(offset + (long)baseOffset + (long)bytesPerEntry * numEntries);
        return ifd;
    }

    public void fillInIFD(IFD ifd) throws IOException {
        HashSet<TiffIFDEntry> entries = new HashSet<TiffIFDEntry>();
        for (Object key : ifd.keySet()) {
            if (!(ifd.get(key) instanceof TiffIFDEntry)) continue;
            entries.add((TiffIFDEntry)ifd.get(key));
        }
        for (TiffIFDEntry entry : entries) {
            if (entry.getValueCount() >= 0xA00000 && entry.getTag() >= 32768) continue;
            ifd.put(new Integer(entry.getTag()), this.getIFDValue(entry));
        }
    }

    public Object getIFDValue(TiffIFDEntry entry) throws IOException {
        IFDType type = entry.getType();
        int count = entry.getValueCount();
        long offset = entry.getValueOffset();
        this.log.trace((Object)("Reading entry " + entry.getTag() + " from " + offset + "; type=" + type + ", count=" + count));
        if (offset >= this.in.length()) {
            return null;
        }
        if (offset != this.in.offset()) {
            this.in.seek(offset);
        }
        if (type == IFDType.BYTE) {
            if (count == 1) {
                return new Short(this.in.readByte());
            }
            byte[] bytes = new byte[count];
            this.in.readFully(bytes);
            short[] shorts = new short[count];
            for (int j = 0; j < count; ++j) {
                shorts[j] = (short)(bytes[j] & 0xFF);
            }
            return shorts;
        }
        if (type == IFDType.ASCII) {
            byte[] ascii = new byte[count];
            this.in.read(ascii);
            int nullCount = 0;
            for (int j = 0; j < count; ++j) {
                if (ascii[j] != 0 && j != count - 1) continue;
                ++nullCount;
            }
            String[] strings = nullCount == 1 ? null : new String[nullCount];
            Object s = null;
            int c = 0;
            int ndx = -1;
            for (int j = 0; j < count; ++j) {
                if (ascii[j] == 0) {
                    s = new String(ascii, ndx + 1, j - ndx - 1, "UTF-8");
                    ndx = j;
                } else {
                    s = j == count - 1 ? new String(ascii, ndx + 1, j - ndx, "UTF-8") : null;
                }
                if (strings == null || s == null) continue;
                strings[c++] = s;
            }
            return strings == null ? s : strings;
        }
        if (type == IFDType.SHORT) {
            if (count == 1) {
                return new Integer(this.in.readUnsignedShort());
            }
            int[] shorts = new int[count];
            for (int j = 0; j < count; ++j) {
                shorts[j] = this.in.readUnsignedShort();
            }
            return shorts;
        }
        if (type == IFDType.LONG || type == IFDType.IFD) {
            if (count == 1) {
                return new Long(this.in.readInt());
            }
            long[] longs = new long[count];
            for (int j = 0; j < count; ++j) {
                if (this.in.offset() + 4L > this.in.length()) continue;
                longs[j] = this.in.readInt();
            }
            return longs;
        }
        if (type == IFDType.LONG8 || type == IFDType.SLONG8 || type == IFDType.IFD8) {
            if (count == 1) {
                return new Long(this.in.readLong());
            }
            long[] longs = null;
            if (this.equalStrips && (entry.getTag() == 279 || entry.getTag() == 325)) {
                longs = new long[]{this.in.readLong()};
            } else {
                if (this.equalStrips && (entry.getTag() == 273 || entry.getTag() == 324)) {
                    OnDemandLongArray offsets = new OnDemandLongArray(this.in);
                    offsets.setSize(count);
                    return offsets;
                }
                longs = new long[count];
                for (int j = 0; j < count; ++j) {
                    longs[j] = this.in.readLong();
                }
            }
            return longs;
        }
        if (type == IFDType.RATIONAL || type == IFDType.SRATIONAL) {
            if (count == 1) {
                return new TiffRational(this.in.readInt(), this.in.readInt());
            }
            TiffRational[] rationals = new TiffRational[count];
            for (int j = 0; j < count; ++j) {
                rationals[j] = new TiffRational(this.in.readInt(), this.in.readInt());
            }
            return rationals;
        }
        if (type == IFDType.SBYTE || type == IFDType.UNDEFINED) {
            if (count == 1) {
                return new Byte(this.in.readByte());
            }
            byte[] sbytes = new byte[count];
            this.in.read(sbytes);
            return sbytes;
        }
        if (type == IFDType.SSHORT) {
            if (count == 1) {
                return new Short(this.in.readShort());
            }
            short[] sshorts = new short[count];
            for (int j = 0; j < count; ++j) {
                sshorts[j] = this.in.readShort();
            }
            return sshorts;
        }
        if (type == IFDType.SLONG) {
            if (count == 1) {
                return new Integer(this.in.readInt());
            }
            int[] slongs = new int[count];
            for (int j = 0; j < count; ++j) {
                slongs[j] = this.in.readInt();
            }
            return slongs;
        }
        if (type == IFDType.FLOAT) {
            if (count == 1) {
                return new Float(this.in.readFloat());
            }
            float[] floats = new float[count];
            for (int j = 0; j < count; ++j) {
                floats[j] = this.in.readFloat();
            }
            return floats;
        }
        if (type == IFDType.DOUBLE) {
            if (count == 1) {
                return new Double(this.in.readDouble());
            }
            double[] doubles = new double[count];
            for (int j = 0; j < count; ++j) {
                doubles[j] = this.in.readDouble();
            }
            return doubles;
        }
        return null;
    }

    public String getComment() throws IOException {
        IFD firstIFD = this.getFirstIFD();
        if (firstIFD == null) {
            return null;
        }
        this.fillInIFD(firstIFD);
        return firstIFD.getComment();
    }

    public byte[] getTile(IFD ifd, byte[] buf, int row, int col) throws FormatException, IOException {
        int realBytes;
        int channel;
        Object stripOffsets;
        int offsetIndex;
        byte[] jpegTable = (byte[])ifd.getIFDValue(347);
        this.codecOptions.interleaved = true;
        this.codecOptions.littleEndian = ifd.isLittleEndian();
        long tileWidth = ifd.getTileWidth();
        long tileLength = ifd.getTileLength();
        int samplesPerPixel = ifd.getSamplesPerPixel();
        int planarConfig = ifd.getPlanarConfiguration();
        TiffCompression compression = ifd.getCompression();
        long numTileCols = ifd.getTilesPerRow();
        int pixel = ifd.getBytesPerSample()[0];
        int effectiveChannels = planarConfig == 2 ? 1 : samplesPerPixel;
        long[] stripByteCounts = ifd.getStripByteCounts();
        long[] rowsPerStrip = ifd.getRowsPerStrip();
        int countIndex = offsetIndex = (int)((long)row * numTileCols + (long)col);
        if (this.equalStrips) {
            countIndex = 0;
        }
        if (stripByteCounts[countIndex] == rowsPerStrip[0] * tileWidth && pixel > 1) {
            int n = countIndex;
            stripByteCounts[n] = stripByteCounts[n] * (long)pixel;
        }
        Object stripOffset = 0L;
        long nStrips = 0L;
        if (ifd.getOnDemandStripOffsets() != null) {
            stripOffsets = ifd.getOnDemandStripOffsets();
            stripOffset = ((OnDemandLongArray)stripOffsets).get(offsetIndex);
            nStrips = ((OnDemandLongArray)stripOffsets).size();
        } else {
            stripOffsets = ifd.getStripOffsets();
            stripOffset = stripOffsets[offsetIndex];
            nStrips = ((Object)stripOffsets).length;
        }
        int size = (int)(tileWidth * tileLength * (long)pixel * (long)effectiveChannels);
        if (buf == null) {
            buf = new byte[size];
        }
        if (stripByteCounts[countIndex] == 0L || stripOffset >= this.in.length()) {
            return buf;
        }
        byte[] tile = new byte[(int)stripByteCounts[countIndex]];
        this.log.debug((Object)("Reading tile Length " + tile.length + " Offset " + stripOffset));
        this.in.seek(stripOffset);
        this.in.read(tile);
        this.codecOptions.maxBytes = Math.max(size, tile.length);
        boolean bl = this.codecOptions.ycbcr = ifd.getPhotometricInterpretation() == PhotoInterp.Y_CB_CR && ifd.getIFDIntValue(530) == 1 && this.ycbcrCorrection;
        if (jpegTable != null) {
            byte[] q = new byte[jpegTable.length + tile.length - 4];
            System.arraycopy(jpegTable, 0, q, 0, jpegTable.length - 2);
            System.arraycopy(tile, 2, q, jpegTable.length - 2, tile.length - 2);
            tile = compression.decompress(this.scifio.codec(), q, this.codecOptions);
        } else {
            tile = compression.decompress(this.scifio.codec(), tile, this.codecOptions);
        }
        this.scifio.tiff().undifference(tile, ifd);
        this.unpackBytes(buf, 0, tile, ifd);
        if (planarConfig == 2 && !ifd.isTiled() && ifd.getSamplesPerPixel() > 1 && (channel = (int)((long)row % nStrips)) < ifd.getBytesPerSample().length && (realBytes = ifd.getBytesPerSample()[channel]) != pixel) {
            int i;
            boolean littleEndian = ifd.isLittleEndian();
            int[] samples = new int[buf.length / pixel];
            for (i = 0; i < samples.length; ++i) {
                samples[i] = Bytes.toInt((byte[])buf, (int)(i * realBytes), (int)realBytes, (boolean)littleEndian);
            }
            for (i = 0; i < samples.length; ++i) {
                Bytes.unpack((long)samples[i], (byte[])buf, (int)(i * pixel), (int)pixel, (boolean)littleEndian);
            }
        }
        return buf;
    }

    public byte[] getSamples(IFD ifd, byte[] buf) throws FormatException, IOException {
        long width = ifd.getImageWidth();
        long length = ifd.getImageLength();
        return this.getSamples(ifd, buf, 0, 0, width, length);
    }

    public byte[] getSamples(IFD ifd, byte[] buf, int x, int y, long width, long height) throws FormatException, IOException {
        return this.getSamples(ifd, buf, x, y, width, height, 0, 0);
    }

    public byte[] getSamples(IFD ifd, byte[] buf, int x, int y, long width, long height, int overlapX, int overlapY) throws FormatException, IOException {
        int effectiveChannels;
        this.log.trace((Object)"parsing IFD entries");
        this.in.setLittleEndian(ifd.isLittleEndian());
        int samplesPerPixel = ifd.getSamplesPerPixel();
        long tileWidth = ifd.getTileWidth();
        long tileLength = ifd.getTileLength();
        if (tileLength <= 0L) {
            this.log.trace((Object)("Tile length is " + tileLength + "; setting it to " + height));
            tileLength = height;
        }
        long numTileRows = ifd.getTilesPerColumn();
        long numTileCols = ifd.getTilesPerRow();
        PhotoInterp photoInterp = ifd.getPhotometricInterpretation();
        int planarConfig = ifd.getPlanarConfiguration();
        int pixel = ifd.getBytesPerSample()[0];
        int n = effectiveChannels = planarConfig == 2 ? 1 : samplesPerPixel;
        if (this.log.isTrace()) {
            ifd.printIFD();
        }
        if (width * height > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth x ImageLength > 2147483647 is not supported (" + width + " x " + height + ")");
        }
        if (width * height * (long)effectiveChannels * (long)pixel > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth x ImageLength x SamplesPerPixel x BitsPerSample > 2147483647 is not supported (" + width + " x " + height + " x " + samplesPerPixel + " x " + pixel * 8 + ")");
        }
        int numSamples = (int)(width * height);
        this.log.trace((Object)("reading image data (samplesPerPixel=" + samplesPerPixel + "; numSamples=" + numSamples + ")"));
        TiffCompression compression = ifd.getCompression();
        this.codecOptions = compression == TiffCompression.JPEG_2000 || compression == TiffCompression.JPEG_2000_LOSSY ? compression.getCompressionCodecOptions(ifd, this.codecOptions) : compression.getCompressionCodecOptions(ifd);
        this.codecOptions.interleaved = true;
        this.codecOptions.littleEndian = ifd.isLittleEndian();
        long imageLength = ifd.getImageLength();
        if ((long)x % tileWidth == 0L && (long)y % tileLength == 0L && width == tileWidth && height == imageLength && samplesPerPixel == 1 && ifd.getBitsPerSample()[0] % 8 == 0 && photoInterp != PhotoInterp.WHITE_IS_ZERO && photoInterp != PhotoInterp.CMYK && photoInterp != PhotoInterp.Y_CB_CR && compression == TiffCompression.UNCOMPRESSED) {
            long[] stripOffsets = ifd.getStripOffsets();
            long[] stripByteCounts = ifd.getStripByteCounts();
            if (stripOffsets != null && stripByteCounts != null) {
                long column = (long)x / tileWidth;
                int firstTile = (int)((long)y / tileLength * numTileCols + column);
                int lastTile = (int)(((long)y + height) / tileLength * numTileCols + column);
                lastTile = Math.min(lastTile, stripOffsets.length - 1);
                int offset = 0;
                for (int tile = firstTile; tile <= lastTile; ++tile) {
                    long byteCount;
                    long l = byteCount = this.equalStrips ? stripByteCounts[0] : stripByteCounts[tile];
                    if (byteCount == (long)numSamples && pixel > 1) {
                        byteCount *= (long)pixel;
                    }
                    this.in.seek(stripOffsets[tile]);
                    int len = (int)Math.min((long)(buf.length - offset), byteCount);
                    this.in.read(buf, offset, len);
                    offset += len;
                }
            }
            return this.adjustFillOrder(ifd, buf);
        }
        long nrows = numTileRows;
        if (planarConfig == 2) {
            numTileRows *= (long)samplesPerPixel;
        }
        IntRect imageBounds = new IntRect(x, y, (int)width, (int)height);
        int endX = (int)width + x;
        int endY = (int)height + y;
        long w = tileWidth;
        long h = tileLength;
        int rowLen = pixel * (int)w;
        int tileSize = (int)((long)rowLen * h);
        int planeSize = (int)(width * height * (long)pixel);
        int outputRowLen = (int)((long)pixel * width);
        int bufferSizeSamplesPerPixel = samplesPerPixel;
        if (ifd.getPlanarConfiguration() == 2) {
            bufferSizeSamplesPerPixel = 1;
        }
        int bpp = ifd.getBytesPerSample()[0];
        int bufferSize = (int)tileWidth * (int)tileLength * bufferSizeSamplesPerPixel * bpp;
        this.cachedTileBuffer = new byte[bufferSize];
        IntRect tileBounds = new IntRect(0, 0, (int)tileWidth, (int)tileLength);
        int row = 0;
        while ((long)row < numTileRows) {
            if (row == 0) {
                tileBounds.height = (int)(tileLength - (long)overlapY);
            }
            int col = 0;
            while ((long)col < numTileCols) {
                if (col == 0) {
                    tileBounds.width = (int)(tileWidth - (long)overlapX);
                }
                tileBounds.x = col * (int)(tileWidth - (long)overlapX);
                tileBounds.y = row * (int)(tileLength - (long)overlapY);
                if (planarConfig == 2) {
                    tileBounds.y = (int)((long)row % nrows * (tileLength - (long)overlapY));
                }
                if (imageBounds.intersects(tileBounds)) {
                    int theight;
                    this.getTile(ifd, this.cachedTileBuffer, row, col);
                    int tileX = Math.max(tileBounds.x, x);
                    int tileY = Math.max(tileBounds.y, y);
                    int realX = tileX % (int)(tileWidth - (long)overlapX);
                    int realY = tileY % (int)(tileLength - (long)overlapY);
                    int twidth = (int)Math.min((long)(endX - tileX), tileWidth - (long)realX);
                    if (twidth <= 0) {
                        twidth = (int)Math.max((long)(endX - tileX), tileWidth - (long)realX);
                    }
                    if ((theight = (int)Math.min((long)(endY - tileY), tileLength - (long)realY)) <= 0) {
                        theight = (int)Math.max((long)(endY - tileY), tileLength - (long)realY);
                    }
                    int copy = pixel * twidth;
                    realX *= pixel;
                    realY *= rowLen;
                    for (int q = 0; q < effectiveChannels; ++q) {
                        int src = q * tileSize + realX + realY;
                        int dest = q * planeSize + pixel * (tileX - x) + outputRowLen * (tileY - y);
                        if (planarConfig == 2) {
                            dest = (int)((long)dest + (long)planeSize * ((long)row / nrows));
                        }
                        if (rowLen == outputRowLen && overlapX == 0 && overlapY == 0) {
                            System.arraycopy(this.cachedTileBuffer, src, buf, dest, copy * theight);
                            continue;
                        }
                        for (int tileRow = 0; tileRow < theight; ++tileRow) {
                            System.arraycopy(this.cachedTileBuffer, src, buf, dest, copy);
                            src += rowLen;
                            dest += outputRowLen;
                        }
                    }
                }
                ++col;
            }
            ++row;
        }
        return this.adjustFillOrder(ifd, buf);
    }

    public TiffIFDEntry readTiffIFDEntry() throws IOException {
        int valueCount;
        IFDType entryType;
        int entryTag = this.in.readUnsignedShort();
        try {
            entryType = IFDType.get(this.in.readUnsignedShort());
        }
        catch (EnumException e) {
            this.log.error((Object)("Error reading IFD type at: " + this.in.offset()));
            throw e;
        }
        int n = valueCount = this.bigTiff ? (int)this.in.readLong() : this.in.readInt();
        if (valueCount < 0) {
            throw new RuntimeException("Count of '" + valueCount + "' unexpected.");
        }
        int nValueBytes = valueCount * entryType.getBytesPerElement();
        int threshhold = this.bigTiff ? 8 : 4;
        long offset = nValueBytes > threshhold ? this.getNextOffset(0L) : this.in.offset();
        return new TiffIFDEntry(entryTag, entryType, valueCount, offset);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private void unpackBytes(byte[] samples, int startIndex, byte[] bytes, IFD ifd) throws FormatException {
        int ndx;
        int skipBits;
        boolean planar = ifd.getPlanarConfiguration() == 2;
        TiffCompression compression = ifd.getCompression();
        PhotoInterp photoInterp = ifd.getPhotometricInterpretation();
        if (compression == TiffCompression.JPEG) {
            photoInterp = PhotoInterp.RGB;
        }
        int[] bitsPerSample = ifd.getBitsPerSample();
        int nChannels = bitsPerSample.length;
        int sampleCount = (int)(8L * (long)bytes.length / (long)bitsPerSample[0]);
        if (photoInterp == PhotoInterp.Y_CB_CR) {
            sampleCount *= 3;
        }
        if (planar) {
            nChannels = 1;
        } else {
            sampleCount /= nChannels;
        }
        this.log.trace((Object)("unpacking " + sampleCount + " samples (startIndex=" + startIndex + "; totalBits=" + nChannels * bitsPerSample[0] + "; numBytes=" + bytes.length + ")"));
        long imageWidth = ifd.getImageWidth();
        long imageHeight = ifd.getImageLength();
        int bps0 = bitsPerSample[0];
        int numBytes = ifd.getBytesPerSample()[0];
        int nSamples = samples.length / (nChannels * numBytes);
        boolean noDiv8 = bps0 % 8 != 0;
        boolean bps8 = bps0 == 8;
        boolean bps16 = bps0 == 16;
        boolean littleEndian = ifd.isLittleEndian();
        BitBuffer bb = new BitBuffer(bytes);
        if ((bps8 || bps16) && bytes.length <= samples.length && nChannels == 1 && photoInterp != PhotoInterp.WHITE_IS_ZERO && photoInterp != PhotoInterp.CMYK && photoInterp != PhotoInterp.Y_CB_CR) {
            System.arraycopy(bytes, 0, samples, 0, bytes.length);
            return;
        }
        long maxValue = (long)Math.pow(2.0, bps0) - 1L;
        if (photoInterp == PhotoInterp.CMYK) {
            maxValue = Integer.MAX_VALUE;
        }
        if ((skipBits = (int)(8L - imageWidth * (long)bps0 * (long)nChannels % 8L)) == 8 || (long)(bytes.length * 8) < (long)bps0 * ((long)nChannels * imageWidth + imageHeight)) {
            skipBits = 0;
        }
        float lumaRed = 0.299f;
        float lumaGreen = 0.587f;
        float lumaBlue = 0.114f;
        int[] reference = ifd.getIFDIntArray(532);
        if (reference == null) {
            reference = new int[]{0, 0, 0, 0, 0, 0};
        }
        int[] subsampling = ifd.getIFDIntArray(530);
        TiffRational[] coefficients = (TiffRational[])ifd.getIFDValue(529);
        if (coefficients != null) {
            lumaRed = coefficients[0].floatValue();
            lumaGreen = coefficients[1].floatValue();
            lumaBlue = coefficients[2].floatValue();
        }
        int subX = subsampling == null ? 2 : subsampling[0];
        int subY = subsampling == null ? 2 : subsampling[1];
        int block = subX * subY;
        int nTiles = (int)(imageWidth / (long)subX);
        block0: for (int sample = 0; sample < sampleCount && (ndx = startIndex + sample) < nSamples; ++sample) {
            for (int channel = 0; channel < nChannels; ++channel) {
                int index = numBytes * (sample * nChannels + channel);
                int outputIndex = (channel * nSamples + ndx) * numBytes;
                if (photoInterp != PhotoInterp.Y_CB_CR) {
                    long value = 0L;
                    if (noDiv8) {
                        if (channel == 0 && photoInterp == PhotoInterp.RGB_PALETTE || photoInterp != PhotoInterp.CFA_ARRAY && photoInterp != PhotoInterp.RGB_PALETTE) {
                            value = bb.getBits(bps0) & 0xFFFF;
                            if ((long)ndx % imageWidth == imageWidth - 1L) {
                                bb.skipBits(skipBits);
                            }
                        }
                    } else {
                        value = Bytes.toLong((byte[])bytes, (int)index, (int)numBytes, (boolean)littleEndian);
                    }
                    if (photoInterp == PhotoInterp.WHITE_IS_ZERO || photoInterp == PhotoInterp.CMYK) {
                        value = maxValue - value;
                    }
                    if (outputIndex + numBytes > samples.length) continue;
                    Bytes.unpack((long)value, (byte[])samples, (int)outputIndex, (int)numBytes, (boolean)littleEndian);
                    continue;
                }
                if (channel != nChannels - 1) continue;
                int lumaIndex = sample + 2 * (sample / block);
                int chromaIndex = sample / block * (block + 2) + block;
                if (chromaIndex + 1 >= bytes.length) continue block0;
                int tile = ndx / block;
                int pixel = ndx % block;
                long r = subY * (tile / nTiles) + pixel / subX;
                long c = subX * (tile % nTiles) + pixel % subX;
                int idx = (int)(r * imageWidth + c);
                if (idx >= nSamples) continue;
                int y = (bytes[lumaIndex] & 0xFF) - reference[0];
                int cb = (bytes[chromaIndex] & 0xFF) - reference[2];
                int cr = (bytes[chromaIndex + 1] & 0xFF) - reference[4];
                int red = (int)((float)cr * (2.0f - 2.0f * lumaRed) + (float)y);
                int blue = (int)((float)cb * (2.0f - 2.0f * lumaBlue) + (float)y);
                int green = (int)(((float)y - lumaBlue * (float)blue - lumaRed * (float)red) / lumaGreen);
                samples[idx] = (byte)(red & 0xFF);
                samples[nSamples + idx] = (byte)(green & 0xFF);
                samples[2 * nSamples + idx] = (byte)(blue & 0xFF);
            }
        }
    }

    private long getNextOffset(long previous) throws IOException {
        if (this.bigTiff || this.fakeBigTiff) {
            return this.in.readLong();
        }
        long offset = previous & 0xFFFFFFFF00000000L | (long)this.in.readInt() & 0xFFFFFFFFL;
        if (offset < previous && offset != 0L && this.in.length() > Integer.MAX_VALUE) {
            offset += 0x100000000L;
        }
        return offset;
    }

    private byte[] adjustFillOrder(IFD ifd, byte[] buf) throws FormatException {
        if (ifd.getFillOrder() == FillOrder.REVERSED) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = REVERSE[0xFF & buf[i]];
            }
        }
        return buf;
    }
}

