/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.refs.CleaningRef;
import io.scif.refs.RefProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import net.imagej.ImgPlus;
import org.scijava.Context;
import org.scijava.plugin.Plugin;

@Plugin(type=RefProvider.class)
public class ImgPlusCtxCleaningProvider
extends AbstractSCIFIOPlugin
implements RefProvider {
    @Override
    public boolean handles(Object referent, Object ... params) {
        boolean matches = ImgPlus.class.isAssignableFrom(referent.getClass());
        matches = matches && params.length == 1;
        matches = matches && Context.class.isAssignableFrom(params[0].getClass());
        return matches;
    }

    @Override
    public Reference makeRef(Object referent, ReferenceQueue queue, Object ... params) {
        ImgPlusCtxCleaner ref = new ImgPlusCtxCleaner(referent, queue, params);
        return ref;
    }

    public static class ImgPlusCtxCleaner
    extends PhantomReference<ImgPlus>
    implements CleaningRef {
        private static Map<Context, Integer> ctxRefs = new HashMap<Context, Integer>();
        private Context ctx;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ImgPlusCtxCleaner(Object imgPlus, ReferenceQueue queue, Object ... params) {
            super((ImgPlus)imgPlus, queue);
            if (params.length != 1) {
                throw new IllegalArgumentException("ImgPlusCleanerRef require 1 parameter: a scijava-common Context");
            }
            try {
                this.ctx = (Context)params[0];
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("ImgPlusCleanerRef: invalid parameter");
            }
            Context context = this.ctx;
            synchronized (context) {
                Integer count = ctxRefs.get(this.ctx);
                if (count == null) {
                    ctxRefs.put(this.ctx, 1);
                } else {
                    ctxRefs.put(this.ctx, ctxRefs.get(this.ctx) + 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanup() {
            if (this.ctx == null) {
                return;
            }
            Context context = this.ctx;
            synchronized (context) {
                int count = ctxRefs.get(this.ctx);
                if (--count == 0) {
                    ctxRefs.remove(this.ctx);
                    this.ctx.dispose();
                } else {
                    ctxRefs.put(this.ctx, count);
                }
            }
        }
    }
}

