/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.FormatException;
import io.scif.Reader;
import io.scif.img.cell.SCIFIOCellImgFactory;
import io.scif.img.cell.loaders.SCIFIOArrayLoader;
import java.io.IOException;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.cache.Cache;
import net.imglib2.cache.IoSync;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.display.ColorTable;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;
import org.scijava.Disposable;

public class SCIFIOCellImg<T extends NativeType<T>, A extends DataAccess>
extends CachedCellImg<T, A>
implements Disposable {
    private final Reader reader;
    private SCIFIOArrayLoader<?> loader;
    private final SCIFIOCellImgFactory<T> factory;
    private final IoSync iosync;

    public SCIFIOCellImg(SCIFIOCellImgFactory<T> factory, CellGrid grid, Fraction entitiesPerPixel, Cache<Long, Cell<A>> cache, A accessType, IoSync iosync) {
        super(grid, entitiesPerPixel, cache, accessType);
        this.factory = factory;
        this.reader = factory.reader();
        this.iosync = iosync;
    }

    public ColorTable getColorTable(int imageIndex, int planeIndex) throws FormatException, IOException {
        if (this.loader != null) {
            return this.loader.loadTable(imageIndex, planeIndex);
        }
        int planarAxisCount = this.reader.getMetadata().get(imageIndex).getAxesPlanar().size();
        long[] dims = new long[planarAxisCount];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = 1L;
        }
        FinalInterval bounds = new FinalInterval(dims);
        return this.reader.openPlane(imageIndex, (long)planeIndex, (Interval)bounds).getColorTable();
    }

    public SCIFIOCellImgFactory<T> factory() {
        return this.factory;
    }

    public Reader reader() {
        return this.reader;
    }

    public void setLoader(SCIFIOArrayLoader<?> loader) {
        this.loader = loader;
    }

    public SCIFIOCellImg<T, A> copy() {
        SCIFIOCellImg<T, ?> copy = this.factory().create(this.dimension);
        super.copyDataTo(copy);
        return copy;
    }

    public void dispose() {
        this.iosync.shutdown();
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

