/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.RealSum;
import net.imglib2.view.Views;

public class ImageStatistics {
    public static final <T extends RealType<T>> long getNumPixels(RandomAccessibleInterval<T> img) {
        long numPixels = 1L;
        for (int d = 0; d < img.numDimensions(); ++d) {
            numPixels *= img.dimension(d);
        }
        return numPixels;
    }

    public static final <T extends RealType<T>> double getImageMean(RandomAccessibleInterval<T> img, RandomAccessibleInterval<BitType> mask) {
        RealSum sum = new RealSum();
        long numPixels = 0L;
        TwinCursor cursor = new TwinCursor(img.randomAccess(), img.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        while (cursor.hasNext()) {
            sum.add(((RealType)cursor.getFirst()).getRealDouble());
            ++numPixels;
        }
        return sum.getSum() / (double)numPixels;
    }

    public static final <T extends RealType<T>> double getImageMean(RandomAccessibleInterval<T> img) {
        RealSum realSum = new RealSum();
        long count = 0L;
        for (RealType type : Views.iterable(img)) {
            realSum.add(type.getRealDouble());
            ++count;
        }
        return realSum.getSum() / (double)count;
    }

    public static final <T extends RealType<T>> double getImageIntegral(RandomAccessibleInterval<T> img) {
        RealSum sum = new RealSum();
        for (RealType type : Views.iterable(img)) {
            sum.add(type.getRealDouble());
        }
        return sum.getSum();
    }

    public static final <T extends RealType<T>> double getImageIntegral(RandomAccessibleInterval<T> img, RandomAccessibleInterval<BitType> mask) {
        RealSum sum = new RealSum();
        TwinCursor cursor = new TwinCursor(img.randomAccess(), img.randomAccess(), (Cursor<BitType>)Views.iterable(mask).cursor());
        while (cursor.hasNext()) {
            sum.add(((RealType)cursor.getFirst()).getRealDouble());
        }
        return sum.getSum();
    }

    public static final <T extends Type<T> & Comparable<T>> T getImageMin(RandomAccessibleInterval<T> img) {
        Cursor cursor = Views.iterable(img).cursor();
        cursor.fwd();
        Type min = ((Type)cursor.get()).copy();
        while (cursor.hasNext()) {
            cursor.fwd();
            Type currValue = (Type)cursor.get();
            if (((Comparable)currValue).compareTo(min) >= 0) continue;
            min.set(currValue);
        }
        return (T)min;
    }

    public static final <T extends Type<T> & Comparable<T>> T getImageMin(RandomAccessibleInterval<T> img, RandomAccessibleInterval<BitType> mask) {
        TwinCursor cursor = new TwinCursor(img.randomAccess(), img.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        cursor.fwd();
        Type min = cursor.getFirst().copy();
        while (cursor.hasNext()) {
            cursor.fwd();
            Object currValue = cursor.getFirst();
            if (((Comparable)currValue).compareTo(min) >= 0) continue;
            min.set(currValue);
        }
        return (T)min;
    }

    public static final <T extends Type<T> & Comparable<T>> T getImageMax(RandomAccessibleInterval<T> img) {
        Cursor cursor = Views.iterable(img).localizingCursor();
        cursor.fwd();
        Type max = ((Type)cursor.get()).copy();
        while (cursor.hasNext()) {
            cursor.fwd();
            Type currValue = (Type)cursor.get();
            if (((Comparable)currValue).compareTo(max) <= 0) continue;
            max.set(currValue);
        }
        return (T)max;
    }

    public static final <T extends Type<T> & Comparable<T>> T getImageMax(RandomAccessibleInterval<T> img, RandomAccessibleInterval<BitType> mask) {
        TwinCursor cursor = new TwinCursor(img.randomAccess(), img.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        cursor.fwd();
        Type max = cursor.getFirst().copy();
        while (cursor.hasNext()) {
            cursor.fwd();
            Object currValue = cursor.getFirst();
            if (((Comparable)currValue).compareTo(max) <= 0) continue;
            max.set(currValue);
        }
        return (T)max;
    }
}

