/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import sc.fiji.coloc.algorithms.IntComparator;

public class IntArraySorter {
    private static final int SORT_SIZE_THRESHOLD = 16;

    public static void sort(int[] array, IntComparator comparator) {
        IntArraySorter.introSort(array, comparator, 0, array.length, array.length);
        IntArraySorter.insertionSort(array, comparator);
    }

    private static void introSort(int[] array, IntComparator comparator, int begin, int end, int limit) {
        while (end - begin > 16) {
            if (limit == 0) {
                IntArraySorter.heapSort(array, comparator, begin, end);
                return;
            }
            limit >>= 1;
            int a = array[begin];
            int b = array[begin + (end - begin) / 2 + 1];
            int c = array[end - 1];
            int median = comparator.compare(a, b) < 0 ? (comparator.compare(b, c) < 0 ? b : (comparator.compare(a, c) < 0 ? c : a)) : (comparator.compare(b, c) > 0 ? b : (comparator.compare(a, c) > 0 ? c : a));
            int i = begin;
            int j = end;
            while (true) {
                if (comparator.compare(array[i], median) < 0) {
                    ++i;
                    continue;
                }
                --j;
                while (comparator.compare(median, array[j]) < 0) {
                    --j;
                }
                if (i >= j) break;
                int swap = array[i];
                array[i] = array[j];
                array[j] = swap;
                ++i;
            }
            int pivot = i;
            IntArraySorter.introSort(array, comparator, pivot, end, limit);
            end = pivot;
        }
    }

    private static void heapSort(int[] array, IntComparator comparator, int begin, int end) {
        int i;
        int count = end - begin;
        for (i = count / 2 - 1; i >= 0; --i) {
            IntArraySorter.siftDown(array, comparator, i, count, begin);
        }
        for (i = count - 1; i > 0; --i) {
            int swap = array[begin + i];
            array[begin + i] = array[begin];
            array[begin] = swap;
            IntArraySorter.siftDown(array, comparator, 0, i, begin);
        }
    }

    private static void siftDown(int[] array, IntComparator comparator, int i, int count, int offset) {
        int value = array[offset + i];
        while (i < count / 2) {
            int child = 2 * i + 1;
            if (child + 1 < count && comparator.compare(array[child], array[child + 1]) < 0) {
                ++child;
            }
            if (comparator.compare(value, array[child]) >= 0) break;
            array[offset + i] = array[offset + child];
            i = child;
        }
        array[offset + i] = value;
    }

    private static void insertionSort(int[] array, IntComparator comparator) {
        for (int j = 1; j < array.length; ++j) {
            int t = array[j];
            for (int i = j - 1; i >= 0 && comparator.compare(array[i], t) > 0; --i) {
                array[i + 1] = array[i];
            }
            array[i + 1] = t;
        }
    }
}

