/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.gadgets;

import ij.process.ImageProcessor;

public final class Autoscaler {
    private Autoscaler() {
    }

    public static void autoscale(ImageProcessor ip) {
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (int y = 0; y < ip.getHeight(); ++y) {
            for (int x = 0; x < ip.getWidth(); ++x) {
                float pix = ip.getPixelValue(x, y);
                if (!Float.isFinite(pix)) continue;
                if (pix < min) {
                    min = pix;
                }
                if (!(pix > max)) continue;
                max = pix;
            }
        }
        ip.setMinAndMax((double)min, (double)max);
    }
}

