/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.results;

import fiji.util.gui.JImagePanel;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import sc.fiji.coloc.algorithms.AutoThresholdRegression;
import sc.fiji.coloc.algorithms.Histogram2D;
import sc.fiji.coloc.gadgets.Autoscaler;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.NamedContainer;
import sc.fiji.coloc.results.PDFWriter;
import sc.fiji.coloc.results.ResultHandler;
import sc.fiji.coloc.results.ValueResult;
import sc.fiji.coloc.results.Warning;

public class SingleWindowDisplay<T extends RealType<T>>
extends JFrame
implements ResultHandler<T>,
ItemListener,
ActionListener,
ClipboardOwner,
MouseMotionListener {
    private static final long serialVersionUID = -5642321584354176878L;
    protected static final int WIN_WIDTH = 350;
    protected static final int WIN_HEIGHT = 600;
    public boolean displayOriginalImages = false;
    protected RandomAccessibleInterval<? extends RealType<?>> currentlyDisplayedImageResult;
    protected List<NamedContainer<RandomAccessibleInterval<? extends RealType<?>>>> listOfImages = new ArrayList();
    protected Map<RandomAccessibleInterval<LongType>, Histogram2D<T>> mapOf2DHistograms = new HashMap<RandomAccessibleInterval<LongType>, Histogram2D<T>>();
    protected List<Warning> warnings = new ArrayList<Warning>();
    protected List<ValueResult> valueResults = new ArrayList<ValueResult>();
    protected Map<Object, String> listOfLUTs = new HashMap<Object, String>();
    protected RandomAccess<? extends RealType<?>> pixelAccessCursor;
    protected PDFWriter<T> pdfWriter;
    protected ImagePlus imp;
    protected JImagePanel imagePanel;
    protected JButton listButton;
    protected JButton copyButton;
    protected JCheckBox log;
    protected DataContainer<T> dataContainer = null;

    public SingleWindowDisplay(DataContainer<T> container, PDFWriter<T> pdfWriter) {
        super(container.getJobName());
        this.setPreferredSize(new Dimension(350, 600));
        this.dataContainer = container;
        this.pdfWriter = pdfWriter;
        this.setVisible(false);
    }

    public void setup() {
        JComboBox dropDownList = new JComboBox();
        for (NamedContainer<RandomAccessibleInterval<? extends RealType<?>>> namedContainer : this.listOfImages) {
            dropDownList.addItem(new NamedContainer(namedContainer.object, namedContainer.name));
        }
        dropDownList.addItemListener(this);
        this.imagePanel = new JImagePanel(IJ.createImage((String)"dummy", (String)"8-bit", (int)10, (int)10, (int)1));
        this.imagePanel.addMouseMotionListener((MouseMotionListener)this);
        JEditorPane editor = new JEditorPane();
        editor.setEditable(false);
        editor.setContentType("text/html");
        editor.setText(this.makeHtmlText());
        JScrollPane jScrollPane = new JScrollPane(editor);
        jScrollPane.setPreferredSize(new Dimension(256, 150));
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.listButton = new JButton("List");
        this.listButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleWindowDisplay.this.showList();
            }
        });
        buttons.add(this.listButton);
        this.copyButton = new JButton("Copy");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SingleWindowDisplay.this.copyToClipboard();
            }
        });
        buttons.add(this.copyButton);
        JButton pdfButten = new JButton("PDF");
        pdfButten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SingleWindowDisplay.this.pdfWriter.process();
            }
        });
        buttons.add(pdfButten);
        this.log = new JCheckBox("Log");
        this.log.setSelected(true);
        this.log.addActionListener(this);
        buttons.add(this.log);
        GridBagLayout layout = new GridBagLayout();
        Container pane = this.getContentPane();
        this.getContentPane().setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        ++c.gridy;
        pane.add(dropDownList, c);
        ++c.gridy;
        c.weighty = 1.0;
        JPanel imageAndLabelPanel = new JPanel();
        imageAndLabelPanel.setLayout(new BorderLayout());
        imageAndLabelPanel.add((Component)this.imagePanel, "Center");
        JLabel yAxisLabel = new JLabel(this.labelName(2, this.dataContainer.getSourceCh2Name()));
        yAxisLabel.setHorizontalAlignment(4);
        yAxisLabel.setBorder(new EmptyBorder(0, 15, 0, 0));
        imageAndLabelPanel.add((Component)yAxisLabel, "West");
        JLabel xAxisLabel = new JLabel(this.labelName(1, this.dataContainer.getSourceCh1Name()));
        xAxisLabel.setHorizontalAlignment(0);
        xAxisLabel.setBorder(new EmptyBorder(0, 0, 15, 0));
        imageAndLabelPanel.add((Component)xAxisLabel, "South");
        JScrollPane scrollImagePane = new JScrollPane(imageAndLabelPanel);
        pane.add((Component)scrollImagePane, c);
        ++c.gridy;
        c.weighty = 1.0;
        pane.add((Component)jScrollPane, c);
        c.weighty = 0.0;
        ++c.gridy;
        pane.add((Component)buttons, c);
    }

    private String labelName(int ch, String s) {
        int maxLen = 30;
        String shortName = s.length() > 30 ? s.substring(0, 27) + "..." : s;
        return "<html><center>Channel " + ch + "<br>(" + shortName + ")</center>";
    }

    @Override
    public void process() {
        int imageWidth = 0;
        int imageHeight = 0;
        if (this.displayOriginalImages) {
            RandomAccessibleInterval<T> img1 = this.dataContainer.getSourceImage1();
            RandomAccessibleInterval<T> img2 = this.dataContainer.getSourceImage2();
            this.listOfImages.add(new NamedContainer<RandomAccessibleInterval<T>>(img1, this.dataContainer.getSourceImage1Name()));
            this.listOfImages.add(new NamedContainer<RandomAccessibleInterval<T>>(img2, this.dataContainer.getSourceImage2Name()));
            imageWidth = (int)img1.dimension(0);
            imageHeight = (int)img1.dimension(1);
        }
        this.setup();
        if (this.listOfImages.size() > 0) {
            this.adjustDisplayedImage((RandomAccessibleInterval)this.listOfImages.get((int)0).object);
        }
        this.setSize(600 + imageWidth, 600 + imageHeight);
        this.setVisible(true);
    }

    @Override
    public void handleImage(RandomAccessibleInterval<T> image, String name) {
        this.listOfImages.add(new NamedContainer<RandomAccessibleInterval<T>>(image, name));
    }

    @Override
    public void handleHistogram(Histogram2D<T> histogram, String name) {
        this.listOfImages.add(new NamedContainer<RandomAccessibleInterval<LongType>>(histogram.getPlotImage(), name));
        this.mapOf2DHistograms.put(histogram.getPlotImage(), histogram);
        this.listOfLUTs.put(histogram.getPlotImage(), "Fire");
    }

    @Override
    public void handleWarning(Warning warning) {
        this.warnings.add(warning);
    }

    @Override
    public void handleValue(String name, String value) {
        this.valueResults.add(new ValueResult(name, value));
    }

    @Override
    public void handleValue(String name, double value) {
        this.handleValue(name, value, 3);
    }

    @Override
    public void handleValue(String name, double value, int decimals) {
        this.valueResults.add(new ValueResult(name, value, decimals));
    }

    protected void printTableRow(PrintWriter out, String name, String text) {
        out.print("<TR><TD>" + name + "</TD><TD>" + this.escape(text) + "</TD></TR>");
    }

    private String escape(String text) {
        int maxChars = 40;
        int minChars = 10;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String word : text.split(" ")) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(this.chop(word, 40, 10));
        }
        return sb.toString();
    }

    private String chop(String word, int maxChars, int minChars) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < word.length(); i += maxChars) {
            int end = Math.min(i + maxChars, word.length());
            String fragment = word.substring(i, end);
            if (i > 0 && fragment.length() > minChars) {
                sb.append(" ");
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    protected void printTableRow(PrintWriter out, String name, double number, int decimalPlaces) {
        String stringNum = IJ.d2s((double)number, (int)decimalPlaces);
        this.printTableRow(out, name, stringNum);
    }

    protected String makeHtmlText() {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter(sout);
        out.print("<html><head>");
        out.print("<style type=\"text/css\">body {font-size: 9px; font-family: sans-serif;}h1 {color: black; font-weight: bold; font-size: 10px;}h1.warn {color: red;}h1.nowarn {color: green;}h1.results {color: black;}table {width: auto;}td { border-width:1px; border-style: solid; vertical-align:top; overflow:hidden;}</style>");
        out.print("</head>");
        if (this.warnings.size() > 0) {
            out.print("<H1 class=\"warn\">Warnings</H1>");
            out.print("<TABLE class=\"warn\"><TR>");
            out.print("<TH>Type</TH><TH>Message</TH></TR>");
            for (Warning w : this.warnings) {
                this.printTableRow(out, w.getShortMessage(), w.getLongMessage());
            }
            out.println("</TABLE>");
        } else {
            out.print("<H1 class=\"nowarn\">No warnings occurred.</H1>");
        }
        IJ.log((String)"!!! WARNINGS !!!");
        for (Warning war : this.warnings) {
            IJ.log((String)("Warning! " + war.getShortMessage() + " - " + war.getLongMessage()));
        }
        out.print("<H1 class=\"results\">Results</H1>");
        out.print("<TABLE class=\"results\"><TR>");
        out.print("<TH>Name</TH><TH>Result</TH></TR>");
        IJ.log((String)"RESULTS:");
        for (ValueResult vr : this.valueResults) {
            if (vr.isNumber) {
                this.printTableRow(out, vr.name, vr.number, vr.decimals);
                IJ.log((String)(vr.name + ", " + IJ.d2s((double)vr.number, (int)vr.decimals)));
                continue;
            }
            this.printTableRow(out, vr.name, vr.value);
            IJ.log((String)(vr.name + ", " + vr.value));
        }
        out.println("</TABLE>");
        out.print("</html>");
        out.close();
        return sout.toString();
    }

    protected void showList() {
        if (this.isHistogram(this.currentlyDisplayedImageResult)) {
            Histogram2D<T> hr = this.mapOf2DHistograms.get(this.currentlyDisplayedImageResult);
            double xBinWidth = 1.0 / hr.getXBinWidth();
            double yBinWidth = 1.0 / hr.getYBinWidth();
            boolean xBinWidthIsOne = Math.abs(xBinWidth - 1.0) < 1.0E-5;
            boolean yBinWidthIsOne = Math.abs(yBinWidth - 1.0) < 1.0E-5;
            String vHeadingX = xBinWidthIsOne ? "X value" : "X bin start";
            String vHeadingY = yBinWidthIsOne ? "Y value" : "Y bin start";
            String histogramData = hr.getData();
            TextWindow tw = new TextWindow(this.getTitle(), vHeadingX + "\t" + vHeadingY + "\tcount", histogramData, 250, 400);
            tw.setVisible(true);
        }
    }

    protected void copyToClipboard() {
        if (this.isHistogram(this.currentlyDisplayedImageResult)) {
            Clipboard systemClipboard = null;
            try {
                systemClipboard = this.getToolkit().getSystemClipboard();
            }
            catch (Exception e) {
                systemClipboard = null;
            }
            if (systemClipboard == null) {
                IJ.error((String)"Unable to copy to Clipboard.");
                return;
            }
            IJ.showStatus((String)"Copying histogram values...");
            String text = this.mapOf2DHistograms.get(this.currentlyDisplayedImageResult).getData();
            StringSelection contents = new StringSelection(text);
            systemClipboard.setContents(contents, this);
            IJ.showStatus((String)(text.length() + " characters copied to Clipboard"));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource().equals(this.imagePanel)) {
            int imgWidth = this.imagePanel.getSrcRect().width;
            int imgHeight = this.imagePanel.getSrcRect().height;
            int displayWidth = (int)((double)imgWidth * this.imagePanel.getMagnification());
            int displayHeight = (int)((double)imgHeight * this.imagePanel.getMagnification());
            int offsetX = (this.imagePanel.getWidth() - displayWidth) / 2;
            int offsetY = (this.imagePanel.getHeight() - displayHeight) / 2;
            int onImageX = this.imagePanel.screenX(e.getX() - offsetX);
            int onImageY = this.imagePanel.screenY(e.getY() - offsetY);
            if (onImageX >= 0 && onImageX < imgWidth && onImageY >= 0 && onImageY < imgHeight) {
                this.mouseMoved(onImageX, onImageY);
            } else {
                IJ.showStatus((String)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(int x, int y) {
        ImageJ ij = IJ.getInstance();
        if (ij != null && this.currentlyDisplayedImageResult != null) {
            if (!IJ.altKeyDown()) {
                if (this.isHistogram(this.currentlyDisplayedImageResult)) {
                    Histogram2D<T> histogram = this.mapOf2DHistograms.get(this.currentlyDisplayedImageResult);
                    RandomAccess<? extends RealType<?>> randomAccess = this.pixelAccessCursor;
                    synchronized (randomAccess) {
                        this.pixelAccessCursor.setPosition(x, 0);
                        this.pixelAccessCursor.setPosition(y, 1);
                        y = (int)this.currentlyDisplayedImageResult.dimension(1) - 1 - y;
                        RandomAccess<? extends RealType<?>> cursor = this.pixelAccessCursor;
                        long val = ((LongType)cursor.get()).getIntegerLong();
                        double calibratedXBinBottom = histogram.getXMin() + (double)x / histogram.getXBinWidth();
                        double calibratedXBinTop = histogram.getXMin() + (double)(x + 1) / histogram.getXBinWidth();
                        double calibratedYBinBottom = histogram.getYMin() + (double)y / histogram.getYBinWidth();
                        double calibratedYBinTop = histogram.getYMin() + (double)(y + 1) / histogram.getYBinWidth();
                        IJ.showStatus((String)("x = " + IJ.d2s((double)calibratedXBinBottom) + " to " + IJ.d2s((double)calibratedXBinTop) + ", y = " + IJ.d2s((double)calibratedYBinBottom) + " to " + IJ.d2s((double)calibratedYBinTop) + ", value = " + val));
                    }
                } else {
                    RandomAccessibleInterval<? extends RealType<?>> img = this.currentlyDisplayedImageResult;
                    ImagePlus imp = ImageJFunctions.wrapFloat(img, (String)"TODO");
                    imp.mouseMoved(x, y);
                }
            } else {
                RandomAccessibleInterval<? extends RealType<?>> img = this.currentlyDisplayedImageResult;
                ImagePlus imp = ImageJFunctions.wrapFloat(img, (String)"TODO");
                imp.mouseMoved(x, y);
            }
        }
    }

    protected void drawImage(RandomAccessibleInterval<? extends RealType<?>> img) {
        Histogram2D<T> histogram;
        this.imp = ImageJFunctions.wrapFloat(img, (String)"TODO");
        this.imagePanel.updateImage(this.imp);
        if (this.listOfLUTs.containsKey(img)) {
            IJ.run((ImagePlus)this.imp, (String)this.listOfLUTs.get(img), null);
        }
        Autoscaler.autoscale(this.imp.getProcessor());
        boolean overlayModified = false;
        Overlay overlay = new Overlay();
        if (this.isHistogram(img) && (histogram = this.mapOf2DHistograms.get(img)).getDrawingSettings().contains((Object)Histogram2D.DrawingFlags.RegressionLine)) {
            AutoThresholdRegression<T> autoThreshold = this.dataContainer.getAutoThreshold();
            if (histogram != null && autoThreshold != null && img == histogram.getPlotImage()) {
                this.drawLine(overlay, img, autoThreshold.getAutoThresholdSlope(), autoThreshold.getAutoThresholdIntercept());
                overlayModified = true;
            }
        }
        if (overlayModified) {
            overlay.setStrokeColor(Color.WHITE);
            this.imp.setOverlay(overlay);
        }
        this.imagePanel.repaint();
    }

    protected boolean isHistogram(RandomAccessibleInterval<? extends RealType<?>> img) {
        return this.mapOf2DHistograms.containsKey(img);
    }

    protected void drawLine(Overlay overlay, RandomAccessibleInterval<? extends RealType<?>> img, double slope, double intercept) {
        double endY;
        double startY;
        long imgWidth = img.dimension(0);
        long imgHeight = img.dimension(1);
        double startX = 0.0;
        double endX = imgWidth;
        if (this.isHistogram(img)) {
            Histogram2D<T> histogram = this.mapOf2DHistograms.get(img);
            double calibratedStartY = slope * histogram.getXMin() + intercept;
            double calibratedEndY = slope * histogram.getXMax() + intercept;
            startY = calibratedStartY * histogram.getYBinWidth();
            endY = calibratedEndY * histogram.getYBinWidth();
        } else {
            startY = slope * startX + intercept;
            endY = slope * endX + intercept;
        }
        startY = (double)(imgHeight - 1L) - startY;
        endY = (double)(imgHeight - 1L) - endY;
        Line lineROI = new Line(startX, startY, endX, endY);
        lineROI.setStrokeWidth(1.0f);
        overlay.add((Roi)lineROI);
    }

    protected void adjustDisplayedImage(RandomAccessibleInterval<? extends RealType<?>> img) {
        if (this.log.isSelected()) {
            this.toggleLogarithmic(false);
        }
        this.currentlyDisplayedImageResult = img;
        this.pixelAccessCursor = img.randomAccess();
        this.listButton.setEnabled(this.isHistogram(img));
        this.copyButton.setEnabled(this.isHistogram(img));
        this.drawImage(img);
        this.toggleLogarithmic(this.log.isSelected());
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            RandomAccessibleInterval img = (RandomAccessibleInterval)((NamedContainer)e.getItem()).getObject();
            this.adjustDisplayedImage(img);
        }
    }

    protected void toggleLogarithmic(boolean enabled) {
        if (this.imp == null) {
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        if (enabled) {
            ip.snapshot();
            ip.log();
            Autoscaler.autoscale(ip);
        } else {
            ip.reset();
        }
        this.imagePanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.log) {
            this.toggleLogarithmic(this.log.isSelected());
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

