/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sc.fiji.kappa.curve.Curve;
import sc.fiji.kappa.gui.KappaFrame;
import sc.fiji.kappa.gui.Panel;

public class ControlPanel
extends JPanel {
    public static final int MAX_AVG_PIXEL_DIM = 2000;
    public static final int MIN_SCALE = 25;
    public static final int MAX_SCALE = 800;
    public static final int DEFAULT_SCALE = 100;
    public static final int DIGITS_MAX_SCALE = Integer.toString(800).length();
    public static double[] SCALE_INCREMENTS = new double[]{0.25, 0.5, 0.6666666666666666, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
    final int SLIDER_OFFSET_OSX = 13;
    final int SLIDER_OFFSET_WIN = 7;
    final int KEYFRAME_MARKER_X_SIZE = 1;
    final int KEYFRAME_MARKER_Y_OFFSET_OSX = 24;
    final int KEYFRAME_MARKER_Y_OFFSET = 25;
    final int KEYFRAME_MARKER_Y_SIZE = 7;
    private JSlider scaleSlider;
    private JSlider currentLayerSlider;
    private JToggleButton[] channelButtons = new JToggleButton[3];
    static final String[] CHANNEL_TOOLTIPS = new String[]{"Display Red Channel", "Display Green Channel", "Display Blue Channel"};
    static final String[] CHANNEL_FILENAMES = new String[]{"red.jpg", "green.jpg", "blue.jpg"};
    private static final long serialVersionUID = 1L;
    private JLabel layerLabel;
    private JLabel scaleLabel;
    private KappaFrame frame;

    public ControlPanel(final KappaFrame frame) {
        this.frame = frame;
        this.setBackground(KappaFrame.PANEL_COLOR);
        this.setPreferredSize(new Dimension(0, 55));
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setLayout(new BoxLayout(this, 2));
        this.setCurrentLayerSlider(new JSlider(0, 1, 200, frame.getINIT_LAYER()));
        this.layerLabel = new JLabel("");
        this.layerLabel.setPreferredSize(new Dimension(65, Short.MAX_VALUE));
        this.getCurrentLayerSlider().addChangeListener(new LayerChanger());
        this.getCurrentLayerSlider().setPaintTicks(false);
        this.getCurrentLayerSlider().setEnabled(false);
        this.add(Box.createRigidArea(new Dimension(15, 0)));
        this.add(this.getCurrentLayerSlider());
        this.add(Box.createRigidArea(new Dimension(8, 0)));
        this.add(this.layerLabel);
        for (int i = 0; i < this.channelButtons.length; ++i) {
            ImageIcon channelIcon = new ImageIcon(Panel.class.getResource("/icons/" + CHANNEL_FILENAMES[i]));
            this.channelButtons[i] = new JToggleButton(channelIcon);
            this.channelButtons[i].setEnabled(false);
            this.channelButtons[i].setToolTipText(CHANNEL_TOOLTIPS[i]);
            this.channelButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    frame.setDisplayedChannels(ControlPanel.this.channelButtons[0].isSelected(), ControlPanel.this.channelButtons[1].isSelected(), ControlPanel.this.channelButtons[2].isSelected());
                }
            });
        }
        this.setScaleSlider(new JSlider(0, 25, 800, 100));
        this.getScaleSlider().setMajorTickSpacing(100);
        this.getScaleSlider().setMinorTickSpacing(50);
        this.getScaleSlider().setPaintTicks(true);
        this.getScaleSlider().setMaximumSize(new Dimension(200, Short.MAX_VALUE));
        this.getScaleSlider().addChangeListener(new ScaleChanger());
        this.scaleLabel = new JLabel(frame.formatNumber(100, DIGITS_MAX_SCALE));
        this.scaleLabel.setPreferredSize(new Dimension(40, Short.MAX_VALUE));
        this.getScaleSlider().setEnabled(false);
        this.add(Box.createHorizontalGlue());
        this.add(Box.createHorizontalGlue());
        this.add(new JLabel("SCALE: "));
        this.add(this.getScaleSlider());
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.scaleLabel);
        this.addSpacer(25);
        this.add(new JLabel("CHANNELS:"));
        this.add(Box.createRigidArea(new Dimension(8, 0)));
        for (JToggleButton b : this.channelButtons) {
            this.add(b);
        }
        this.add(Box.createRigidArea(new Dimension(8, 0)));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle bounds = this.getCurrentLayerSlider().getBounds();
        if (this.frame.getCurves().getNoSelected() == 1) {
            int[] keyframeLayers;
            g.setColor(Color.RED);
            Curve currentCurve = this.frame.getCurves().getSelected()[0];
            for (int frameLayer : keyframeLayers = currentCurve.getKeyframeLayers()) {
                int centerX = System.getProperty("os.name").equals("Mac OS X") ? bounds.x + 13 + (int)(((double)frameLayer - 1.0) / (double)(this.getCurrentLayerSlider().getMaximum() - 1) * (double)(bounds.width - 26)) : bounds.x + 7 + (int)(((double)frameLayer - 1.0) / (double)(this.getCurrentLayerSlider().getMaximum() - 1) * (double)(bounds.width - 14));
                g.fillRect(centerX - 1, bounds.y + 25, 2, 7);
            }
        }
    }

    private void addSpacer(int spaceSize) {
        this.add(Box.createRigidArea(new Dimension(spaceSize, 0)));
        JSeparator spacer = new JSeparator(1);
        spacer.setMaximumSize(new Dimension(10, 35));
        this.add(spacer);
        this.add(Box.createRigidArea(new Dimension(spaceSize, 0)));
    }

    public JToggleButton[] getChannelButtons() {
        return this.channelButtons;
    }

    public JSlider getScaleSlider() {
        return this.scaleSlider;
    }

    public void setScaleSlider(JSlider scaleSlider) {
        this.scaleSlider = scaleSlider;
    }

    public JSlider getCurrentLayerSlider() {
        return this.currentLayerSlider;
    }

    public void setCurrentLayerSlider(JSlider currentLayerSlider) {
        this.currentLayerSlider = currentLayerSlider;
    }

    private class ScaleChanger
    implements ChangeListener {
        private ScaleChanger() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            ControlPanel.this.scaleLabel.setText(ControlPanel.this.frame.formatNumber(ControlPanel.this.getScaleSlider().getValue(), DIGITS_MAX_SCALE) + "%");
            ControlPanel.this.frame.setScaledImage((double)ControlPanel.this.getScaleSlider().getValue() / 100.0);
            ControlPanel.this.frame.drawImageOverlay();
        }
    }

    private class LayerChanger
    implements ChangeListener {
        private LayerChanger() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            ControlPanel.this.layerLabel.setText(ControlPanel.this.frame.formatNumber(ControlPanel.this.getCurrentLayerSlider().getValue(), ControlPanel.this.frame.getMaxLayerDigits()) + " / " + ControlPanel.this.frame.getMaxLayer());
            ControlPanel.this.frame.setLayer(ControlPanel.this.getCurrentLayerSlider().getValue(), (double)ControlPanel.this.getScaleSlider().getValue() / 100.0);
            JSlider source = (JSlider)ce.getSource();
            if (!source.getValueIsAdjusting()) {
                ControlPanel.this.frame.getInfoPanel().updateHistograms();
            }
        }
    }
}

