/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import java.util.ArrayList;
import java.util.Collection;
import stitching.model.InvertibleModel;
import stitching.model.Model;
import stitching.model.NotEnoughDataPointsException;
import stitching.model.PointMatch;

public class Tile {
    private final float width;
    private final float height;
    private float[] lc;
    private float[] wc;
    private Model model;
    private final ArrayList<PointMatch> matches = new ArrayList();
    private final ArrayList<Tile> connectedTiles = new ArrayList();
    private double error;
    private double distance;

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public float[] getWC() {
        return this.wc;
    }

    public final Model getModel() {
        return this.model;
    }

    public final ArrayList<PointMatch> getMatches() {
        return this.matches;
    }

    public final void resetMatches() {
        this.matches.clear();
    }

    public final ArrayList<Tile> getConnectedTiles() {
        return this.connectedTiles;
    }

    public final void resetConnectedTiles() {
        this.connectedTiles.clear();
    }

    public final void resetTile() {
        this.lc = new float[]{this.width / 2.0f - 1.0f, this.height / 2.0f - 1.0f};
        this.wc = new float[]{this.lc[0], this.lc[1]};
        this.resetConnectedTiles();
        this.resetMatches();
    }

    public final boolean addConnectedTile(Tile t) {
        if (this.connectedTiles.contains(t)) {
            return true;
        }
        return this.connectedTiles.add(t);
    }

    public final boolean removeConnectedTile(Tile t) {
        return this.connectedTiles.remove(t);
    }

    public final double getError() {
        return this.error;
    }

    public final double getDistance() {
        return this.distance;
    }

    public Tile(float width, float height, Model model) {
        this.width = width;
        this.height = height;
        this.model = model;
        this.lc = new float[]{width / 2.0f - 1.0f, height / 2.0f - 1.0f};
        this.wc = new float[]{this.lc[0], this.lc[1]};
    }

    public Tile(double width, double height, Model model) {
        this.width = (float)width;
        this.height = (float)height;
        this.model = model;
        this.lc = new float[]{this.width / 2.0f - 1.0f, this.height / 2.0f - 1.0f};
        this.wc = new float[]{this.lc[0], this.lc[1]};
    }

    public final boolean addMatches(Collection<PointMatch> more) {
        return this.matches.addAll(more);
    }

    public final boolean addMatch(PointMatch match) {
        return this.matches.add(match);
    }

    public final void update() {
        double d = 0.0;
        double e = 0.0;
        int num_matches = this.matches.size();
        if (num_matches > 0) {
            double sum_weight = 0.0;
            for (PointMatch match : this.matches) {
                match.apply(this.model);
                double dl = match.getDistance();
                d += dl;
                e += dl * dl * (double)match.getWeight();
                sum_weight += (double)match.getWeight();
            }
            d /= (double)num_matches;
            e /= sum_weight;
        }
        this.distance = (float)d;
        this.error = (float)e;
        this.model.setError(e);
    }

    public final void updateByStrength(float amount) {
        this.wc = this.model.apply(this.lc);
        double d = 0.0;
        double e = 0.0;
        int num_matches = this.matches.size();
        if (num_matches > 0) {
            double sum_weight = 0.0;
            for (PointMatch match : this.matches) {
                match.applyByStrength(this.model, amount);
                double dl = match.getDistance();
                d += dl;
                e += dl * dl * (double)match.getWeight();
                sum_weight += (double)match.getWeight();
            }
            d /= (double)num_matches;
            e /= sum_weight;
        }
        this.distance = (float)d;
        this.error = (float)e;
        this.model.setError(e);
    }

    public final boolean diceBetterModel(int max_num_tries, float scale) {
        Model old_model = this.model;
        for (int t = 0; t < max_num_tries; ++t) {
            this.model = this.model.clone();
            this.model.shake(this.matches, scale, this.lc);
            this.update();
            if (this.model.betterThan(old_model)) {
                return true;
            }
            this.model = old_model;
        }
        this.update();
        return false;
    }

    public final void fitModel() throws NotEnoughDataPointsException {
        this.model.fit(this.matches);
    }

    private final int traceConnectedGraph(ArrayList<Tile> graph) {
        graph.add(this);
        for (Tile t : this.connectedTiles) {
            if (graph.contains(t)) continue;
            t.traceConnectedGraph(graph);
        }
        return graph.size();
    }

    public final void connect(Tile o, Collection<PointMatch> matches) {
        this.addMatches(matches);
        o.addMatches(PointMatch.flip(matches));
        this.addConnectedTile(o);
        o.addConnectedTile(this);
    }

    public static final ArrayList<ArrayList<Tile>> identifyConnectedGraphs(Collection<Tile> tiles) {
        ArrayList<ArrayList<Tile>> graphs = new ArrayList<ArrayList<Tile>>();
        int numInspectedTiles = 0;
        block0: for (Tile tile : tiles) {
            for (ArrayList<Tile> knownGraph : graphs) {
                if (!knownGraph.contains(tile)) continue;
                continue block0;
            }
            ArrayList<Tile> current_graph = new ArrayList<Tile>();
            graphs.add(current_graph);
            if ((numInspectedTiles += tile.traceConnectedGraph(current_graph)) != tiles.size()) continue;
            break;
        }
        return graphs;
    }

    public final boolean isInside(float[] point) throws Exception {
        float[] local = ((InvertibleModel)this.model).applyInverse(point);
        return local[0] >= 0.0f && local[0] < this.width && local[1] >= 0.0f && local[1] < this.height;
    }

    public final boolean intersects(Tile t) throws Exception {
        float[] p = new float[]{0.0f, 0.0f};
        this.model.applyInPlace(p);
        if (t.isInside(p)) {
            return true;
        }
        p = new float[]{this.width, 0.0f};
        this.model.applyInPlace(p);
        if (t.isInside(p)) {
            return true;
        }
        p = new float[]{this.width, this.height};
        this.model.applyInPlace(p);
        if (t.isInside(p)) {
            return true;
        }
        p = new float[]{0.0f, this.height};
        this.model.applyInPlace(p);
        if (t.isInside(p)) {
            return true;
        }
        Model m = t.getModel();
        p = new float[]{0.0f, 0.0f};
        m.applyInPlace(p);
        if (this.isInside(p)) {
            return true;
        }
        p = new float[]{t.width, 0.0f};
        m.applyInPlace(p);
        if (this.isInside(p)) {
            return true;
        }
        p = new float[]{t.width, t.height};
        m.applyInPlace(p);
        if (this.isInside(p)) {
            return true;
        }
        p = new float[]{0.0f, t.height};
        m.applyInPlace(p);
        return this.isInside(p);
    }
}

