/*
 * Decompiled with CFR 0.152.
 */
package stitching.utils;

import ij.IJ;
import java.util.Date;

public final class Log {
    public static void debug(String message) {
        if (!IJ.debugMode) {
            return;
        }
        IJ.log((String)message);
    }

    public static void warn(String message) {
        IJ.log((String)("WARNING: " + message));
    }

    public static void info(String message) {
        IJ.log((String)message);
    }

    public static void timestamp(String message) {
        Log.info("(" + new Date(System.currentTimeMillis()) + "): " + message);
    }

    public static void error(String message) {
        Log.error(message, null);
    }

    public static void error(Throwable t) {
        Log.error(null, t);
    }

    public static void error(String message, Throwable t) {
        String logMessage;
        if (t != null) {
            t.printStackTrace();
        }
        String string = logMessage = message != null ? message : Log.message(t);
        if (logMessage != null) {
            IJ.log((String)("ERROR: " + logMessage));
        }
        if (t != null) {
            IJ.handleException((Throwable)t);
        }
    }

    private static String message(Throwable t) {
        return t == null ? null : t.getMessage();
    }
}

