/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.dbengine;

import java.sql.SQLException;
import java.util.ArrayList;
import mdbtools.dbengine.Data;

public class MemoryData
implements Data {
    protected int currentRow = -1;
    private ArrayList rows = new ArrayList();

    public MemoryData() {
    }

    public MemoryData(Data data, int numColumns) throws SQLException {
        while (data.next()) {
            Object[] row = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                row[i] = data.get(i);
            }
            this.rows.add(row);
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.currentRow + 1 < this.rows.size()) {
            ++this.currentRow;
            return true;
        }
        return false;
    }

    @Override
    public Object get(int index) {
        Object[] row = (Object[])this.rows.get(this.currentRow);
        return row[index];
    }

    public Object[] getRow(int index) {
        return (Object[])this.rows.get(index);
    }

    public void addRow(Object[] row) {
        if (this.currentRow != -1) {
            throw new RuntimeException("can't add a row after the data has been read");
        }
        this.rows.add(row);
    }

    public void sort(int[] sortBy, boolean[] ascending) throws SQLException {
        if (this.rows.size() == 0) {
            return;
        }
        int numColumns = ((Object[])this.rows.get(0)).length;
        for (int i = 0; i < sortBy.length; ++i) {
            if (sortBy[i] < numColumns) continue;
            throw new SQLException("can't sort by a column that does not exist");
        }
        int columnToSort = sortBy[0];
        boolean asc = ascending[0];
        this.sort(columnToSort, 0, this.rows.size() - 1, asc);
        int lastColumnSorted = columnToSort;
        for (int i = 1; i < sortBy.length; ++i) {
            columnToSort = sortBy[i];
            asc = ascending[i];
            int start = 0;
            int end = this.findDifferent(lastColumnSorted, start) - 1;
            while (end != -2) {
                this.sort(columnToSort, start, end, asc);
                start = end + 1;
                end = this.findDifferent(lastColumnSorted, start) - 1;
            }
            this.sort(columnToSort, start, this.rows.size() - 1, asc);
        }
    }

    private int findDifferent(int column, int start) {
        Object value = ((Object[])this.rows.get(start))[column];
        for (int i = start + 1; i < this.rows.size(); ++i) {
            Object o = ((Object[])this.rows.get(i))[column];
            if (value.equals(o)) continue;
            return i;
        }
        return -1;
    }

    private void sort(int columnToSort, int startAt, int endAt, boolean ascending) {
        if (startAt == endAt) {
            return;
        }
        int size = endAt - startAt + 1;
        int j = startAt + 1;
        for (int i = 1; i < size; ++i) {
            int a;
            Object[] row = (Object[])this.rows.get(j);
            for (a = j - 1; a > startAt - 1 && (ascending && ((Comparable)row[columnToSort]).compareTo((Comparable)((Object[])this.rows.get(a))[columnToSort]) < 0 || !ascending && ((Comparable)row[columnToSort]).compareTo((Comparable)((Object[])this.rows.get(a))[columnToSort]) > 0); --a) {
                this.rows.set(a + 1, this.rows.get(a));
            }
            this.rows.set(a + 1, row);
            ++j;
        }
    }

    public void dump() {
        System.out.println("+++++++++++");
        for (int i = 0; i < this.rows.size(); ++i) {
            Object[] row = (Object[])this.rows.get(i);
            for (int j = 0; j < row.length; ++j) {
                if (j != 0) {
                    System.out.print(',');
                }
                System.out.print(row[j].toString());
            }
            System.out.println("");
        }
    }
}

