/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.BSplineModel;
import bunwarpj.MainDialog;
import bunwarpj.Mask;
import bunwarpj.MiscTools;
import bunwarpj.PointHandler;
import bunwarpj.Transformation;
import ij.IJ;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.util.Stack;

public class FinalAction
implements Runnable {
    private Thread t;
    private MainDialog dialog;
    private ImagePlus sourceImp;
    private ImagePlus targetImp;
    private BSplineModel source;
    private BSplineModel target;
    private PointHandler sourcePh;
    private PointHandler targetPh;
    private Mask sourceMsk;
    private Mask targetMsk;
    private double[][] sourceAffineMatrix;
    private double[][] targetAffineMatrix;
    private int min_scale_deformation;
    private int max_scale_deformation;
    private int min_scale_image;
    private int outputLevel;
    private boolean showMarquardtOptim;
    private double divWeight;
    private double curlWeight;
    private double landmarkWeight;
    private double imageWeight;
    private double consistencyWeight;
    private double stopThreshold;
    private int accurate_mode;

    public FinalAction(MainDialog dialog) {
        this.dialog = dialog;
        this.t = new Thread(this);
        this.t.setDaemon(true);
    }

    public Thread getThread() {
        return this.t;
    }

    @Override
    public void run() {
        int i0;
        IJ.showStatus((String)"Starting image pyramids...");
        if (this.target.getWidth() > 1024 || this.target.getHeight() > 1024 || this.source.getWidth() > 1024 || this.source.getHeight() > 1024) {
            IJ.log((String)"Starting image pyramids...");
        }
        this.source.startPyramids();
        this.target.startPyramids();
        this.dialog.joinThreads();
        ImagePlus[] output_ip = this.initializeOutputIPs();
        if (this.accurate_mode == MainDialog.MONO_MODE) {
            this.consistencyWeight = 0.0;
        }
        if (this.dialog.isMacroCall() && (i0 = this.dialog.getMacroArgs().indexOf("load=")) != -1) {
            int i1 = this.dialog.getMacroArgs().indexOf(" ", i0 + 5);
            String filename = this.dialog.getMacroArgs().substring(i0 + 5, i1);
            Stack<Point> sourceStack = new Stack<Point>();
            Stack<Point> targetStack = new Stack<Point>();
            MiscTools.loadPoints(filename, sourceStack, targetStack);
            this.sourcePh = new PointHandler(this.sourceImp);
            this.targetPh = new PointHandler(this.targetImp);
            while (!sourceStack.empty() && !targetStack.empty()) {
                Point sourcePoint = sourceStack.pop();
                Point targetPoint = targetStack.pop();
                this.sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
                this.targetPh.addPoint(targetPoint.x, targetPoint.y);
            }
        }
        Transformation warp = new Transformation(this.sourceImp, this.targetImp, this.source, this.target, this.sourcePh, this.targetPh, this.sourceMsk, this.targetMsk, this.sourceAffineMatrix, this.targetAffineMatrix, this.min_scale_deformation, this.max_scale_deformation, this.min_scale_image, this.divWeight, this.curlWeight, this.landmarkWeight, this.imageWeight, this.consistencyWeight, this.stopThreshold, this.outputLevel, this.showMarquardtOptim, this.accurate_mode, "", "", output_ip[0], output_ip[1], this.dialog);
        IJ.showStatus((String)"Registering...");
        long start = System.currentTimeMillis();
        if (this.accurate_mode == MainDialog.MONO_MODE) {
            warp.doUnidirectionalRegistration();
            if (this.dialog.isSaveTransformationSet()) {
                warp.saveDirectTransformation();
            }
            if (this.source.isSubOutput()) {
                IJ.log((String)"Calculating final transformed source image");
            }
            warp.showDirectResults();
        } else {
            warp.doBidirectionalRegistration();
            if (this.dialog.isSaveTransformationSet()) {
                warp.saveDirectTransformation();
                warp.saveInverseTransformation();
            }
            if (this.source.isSubOutput()) {
                IJ.log((String)"Calculating final transformed source image");
            }
            warp.showDirectResults();
            if (this.target.isSubOutput()) {
                IJ.log((String)"Calculating final transformed target image");
            }
            warp.showInverseResults();
        }
        long stop = System.currentTimeMillis();
        if (this.outputLevel == 2) {
            IJ.log((String)("\nRegistration time: " + (stop - start) + "ms"));
        }
        this.dialog.restoreAll();
        this.dialog.freeMemory();
    }

    public void setup(ImagePlus sourceImp, ImagePlus targetImp, BSplineModel source, BSplineModel target, PointHandler sourcePh, PointHandler targetPh, Mask sourceMsk, Mask targetMsk, double[][] sourceAffineMatrix, double[][] targetAffineMatrix, int min_scale_deformation, int max_scale_deformation, int min_scale_image, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, int outputLevel, boolean showMarquardtOptim, int accurate_mode) {
        this.sourceImp = sourceImp;
        this.targetImp = targetImp;
        this.source = source;
        this.target = target;
        this.sourcePh = sourcePh;
        this.targetPh = targetPh;
        this.sourceMsk = sourceMsk;
        this.targetMsk = targetMsk;
        this.sourceAffineMatrix = sourceAffineMatrix;
        this.targetAffineMatrix = targetAffineMatrix;
        this.min_scale_deformation = min_scale_deformation;
        this.max_scale_deformation = max_scale_deformation;
        this.min_scale_image = min_scale_image;
        this.divWeight = divWeight;
        this.curlWeight = curlWeight;
        this.landmarkWeight = landmarkWeight;
        this.imageWeight = imageWeight;
        this.consistencyWeight = consistencyWeight;
        this.stopThreshold = stopThreshold;
        this.outputLevel = outputLevel;
        this.showMarquardtOptim = showMarquardtOptim;
        this.accurate_mode = accurate_mode;
    }

    public ImagePlus[] initializeOutputIPs() {
        int Ydimt = this.target.getHeight();
        int Xdimt = this.target.getWidth();
        int Xdims = this.source.getWidth();
        int Ydims = this.source.getHeight();
        double[] tImage = this.target.isSubOutput() ? this.target.getSubImage() : this.target.getImage();
        double[] sImage = this.source.isSubOutput() ? this.source.getSubImage() : this.source.getImage();
        int sSubFactorX = 1;
        int sSubFactorY = 1;
        int tSubFactorX = 1;
        int tSubFactorY = 1;
        ImagePlus[] outputIP = new ImagePlus[2];
        String extraTitleS = "";
        String extraTitleT = "";
        if (this.target.isSubOutput() || this.source.isSubOutput()) {
            IJ.log((String)"Initializing output windows...");
        }
        if (this.target.isSubOutput()) {
            tSubFactorX = Xdimt / this.target.getSubWidth();
            tSubFactorY = Ydimt / this.target.getSubHeight();
            extraTitleT = " (Subsampled)";
            Xdimt = this.target.getSubWidth();
            Ydimt = this.target.getSubHeight();
        }
        if (this.source.isSubOutput()) {
            sSubFactorX = Xdims / this.source.getSubWidth();
            sSubFactorY = Ydims / this.source.getSubHeight();
            extraTitleS = " (Subsampled)";
            Xdims = this.source.getSubWidth();
            Ydims = this.source.getSubHeight();
        }
        FloatProcessor fp = new FloatProcessor(Xdimt, Ydimt);
        float[] f_array = (float[])fp.getPixels();
        for (int i = 0; i < Ydimt; ++i) {
            int i_offset_t = i * Xdimt;
            int i_offset_s = i * Xdims;
            int i_s_sub = i * sSubFactorY;
            int i_t_sub = i * tSubFactorY;
            for (int j = 0; j < Xdimt; ++j) {
                f_array[j + i_offset_t] = this.sourceMsk.getValue(j * sSubFactorX, i_s_sub) && this.targetMsk.getValue(j * tSubFactorX, i_t_sub) && j < Xdims && i < Ydims ? (float)(tImage[i_offset_t + j] - sImage[i_offset_s + j]) : 0.0f;
            }
        }
        fp.resetMinAndMax();
        ImagePlus ip1 = new ImagePlus("Output Source-Target" + extraTitleS, (ImageProcessor)fp);
        ip1.updateAndDraw();
        ip1.show();
        outputIP[0] = ip1;
        if (this.accurate_mode != MainDialog.MONO_MODE) {
            FloatProcessor fp2 = new FloatProcessor(Xdims, Ydims);
            float[] f_array_2 = (float[])fp2.getPixels();
            for (int i = 0; i < Ydims; ++i) {
                int i_offset_t = i * Xdimt;
                int i_offset_s = i * Xdims;
                int i_s_sub = i * sSubFactorY;
                int i_t_sub = i * tSubFactorY;
                for (int j = 0; j < Xdims; ++j) {
                    f_array_2[j + i_offset_s] = this.targetMsk.getValue(j * tSubFactorX, i_t_sub) && this.sourceMsk.getValue(j * sSubFactorX, i_s_sub) && i < Ydimt && j < Xdimt ? (float)(sImage[i_offset_s + j] - tImage[i_offset_t + j]) : 0.0f;
                }
            }
            fp2.resetMinAndMax();
            ImagePlus ip2 = new ImagePlus("Output Target-Source" + extraTitleT, (ImageProcessor)fp2);
            ip2.updateAndDraw();
            ip2.show();
            outputIP[1] = ip2;
        } else {
            outputIP[1] = null;
        }
        return outputIP;
    }
}

