/*
 * Decompiled with CFR 0.152.
 */
package fiji.packaging;

import fiji.packaging.Packager;
import fiji.packaging.TarBz2Packager;
import fiji.packaging.TarGzPackager;
import fiji.packaging.TarPackager;
import fiji.packaging.ZipPackager;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Package_Maker
implements PlugIn {
    public void run(String arg) {
        ArrayList<Packager> packagers = new ArrayList<Packager>();
        packagers.add(new ZipPackager());
        try {
            packagers.add(new TarBz2Packager());
        }
        catch (Exception exception) {
            // empty catch block
        }
        packagers.add(new TarGzPackager());
        packagers.add(new TarPackager());
        String[] types = new String[packagers.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ((Packager)packagers.get(i)).getExtension().substring(1).toUpperCase();
        }
        GenericDialogPlus gd = new GenericDialogPlus("Make Fiji Package");
        gd.addChoice("Type", types, types[IJ.isWindows() ? 0 : 1]);
        gd.addCheckbox("Include_Java_Runtime", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        Packager packager = (Packager)packagers.get(gd.getNextChoiceIndex());
        boolean includeJRE = gd.getNextBoolean();
        String platform = Packager.getPlatform();
        String timestamp = new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
        String extension = packager.getExtension();
        String fileName = "fiji-" + platform + "-" + timestamp;
        SaveDialog save = new SaveDialog("Make Fiji Package", fileName, extension);
        if (save.getFileName() == null) {
            return;
        }
        String path = save.getDirectory() + save.getFileName();
        try {
            packager.initialize(includeJRE, new String[0]);
            packager.open(new FileOutputStream(path));
            packager.addDefaultFiles();
            packager.close();
            IJ.showMessage((String)("Wrote " + path));
        }
        catch (Throwable e) {
            e.printStackTrace();
            IJ.error((String)("Error writing " + path));
        }
    }
}

