/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_;
import org.knowm.xchart.internal.chartpart.RenderableSeries;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;

public class Legend_Bubble<ST extends AxesChartStyler, S extends AxesChartSeries>
extends Legend_<ST, S> {
    private final ST axesChartStyler;

    public Legend_Bubble(Chart<ST, S> chart) {
        super(chart);
        this.axesChartStyler = (AxesChartStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        double startx = this.xOffset + (double)((AxesChartStyler)this.chart.getStyler()).getLegendPadding();
        double starty = this.yOffset + (double)((AxesChartStyler)this.chart.getStyler()).getLegendPadding();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.chart.getSeriesMap();
        for (AxesChartSeries series : map.values()) {
            if (!series.isShowInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            float legendEntryHeight = this.getLegendEntryHeight(seriesTextBounds, 20);
            Ellipse2D.Double rectSmall = new Ellipse2D.Double(startx, starty, 20.0, 20.0);
            g.setColor(series.getFillColor());
            g.fill(rectSmall);
            g.setStroke(series.getLineStyle());
            g.setColor(series.getLineColor());
            g.draw(rectSmall);
            double x = startx + 20.0 + (double)((AxesChartStyler)this.chart.getStyler()).getLegendPadding();
            this.paintSeriesText(g, seriesTextBounds, 20, x, starty);
            if (((AxesChartStyler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
                starty += (double)(legendEntryHeight + (float)((AxesChartStyler)this.chart.getStyler()).getLegendPadding());
                continue;
            }
            int markerWidth = 20;
            if (series.getLegendRenderType() == RenderableSeries.LegendRenderType.Line) {
                markerWidth = ((AxesChartStyler)this.chart.getStyler()).getLegendSeriesLineLength();
            }
            float legendEntryWidth = this.getLegendEntryWidth(seriesTextBounds, markerWidth);
            startx += (double)(legendEntryWidth + (float)((AxesChartStyler)this.chart.getStyler()).getLegendPadding());
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public double getSeriesLegendRenderGraphicHeight(S series) {
        return ((Series)series).getLegendRenderType() == RenderableSeries.LegendRenderType.Box ? 20.0 : (double)((AxesChartStyler)this.axesChartStyler).getMarkerSize();
    }
}

