/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.util.Hashtable;

public class BufferedImageBuilder
implements ImageConsumer {
    BufferedImage bufferedImage;
    ColorModel defaultModel;

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    @Override
    public void setDimensions(int width, int height) {
        this.bufferedImage = new BufferedImage(width, height, 1);
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.defaultModel = model;
    }

    @Override
    public void setHints(int flags) {
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        if (this.bufferedImage != null) {
            int[] pixels2;
            if (model == null) {
                model = this.defaultModel;
            }
            if (model != null) {
                pixels2 = new int[pixels.length];
                for (int yy = 0; yy < h; ++yy) {
                    for (int xx = 0; xx < w; ++xx) {
                        int i = yy * scansize + xx;
                        pixels2[i] = model.getRGB(pixels[i]);
                    }
                }
            } else {
                pixels2 = pixels;
            }
            this.bufferedImage.setRGB(x, y, w, h, pixels2, offset, scansize);
        }
    }

    @Override
    public void imageComplete(int status) {
    }
}

