/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.StringUtils;

public class FileListConverters {

    @Plugin(type=Converter.class)
    public static class FileArrayToStringConverter
    extends AbstractConverter<File[], String> {
        @Override
        public <T> T convert(Object src, Class<T> dest) {
            List result = Arrays.asList((File[])src).stream().map(f -> {
                String path = f.getAbsolutePath();
                return path.contains(",") ? "\"" + path + "\"" : path;
            }).collect(Collectors.toList());
            return (T)String.join((CharSequence)",", result);
        }

        @Override
        public Class<String> getOutputType() {
            return String.class;
        }

        @Override
        public Class<File[]> getInputType() {
            return File[].class;
        }
    }

    @Plugin(type=Converter.class)
    public static class FileToStringConverter
    extends AbstractConverter<File, String> {
        @Override
        public <T> T convert(Object src, Class<T> dest) {
            return (T)((File)src).getAbsolutePath();
        }

        @Override
        public Class<String> getOutputType() {
            return String.class;
        }

        @Override
        public Class<File> getInputType() {
            return File.class;
        }
    }

    @Plugin(type=Converter.class)
    public static class StringToFileArrayConverter
    extends AbstractConverter<String, File[]> {
        @Override
        public <T> T convert(Object src, Class<T> dest) {
            String[] tokens = StringUtils.splitUnquoted((String)src, ",");
            ArrayList<File> fileList = new ArrayList<File>();
            for (String filePath : tokens) {
                if (filePath.isEmpty()) continue;
                fileList.add(new File(filePath.replaceAll("^\"|\"$", "")));
            }
            return (T)fileList.toArray(new File[fileList.size()]);
        }

        @Override
        public Class<File[]> getOutputType() {
            return File[].class;
        }

        @Override
        public Class<String> getInputType() {
            return String.class;
        }
    }

    @Plugin(type=Converter.class)
    public static class StringToFileConverter
    extends AbstractConverter<String, File> {
        @Override
        public <T> T convert(Object src, Class<T> dest) {
            return (T)new File((String)src);
        }

        @Override
        public Class<File> getOutputType() {
            return File.class;
        }

        @Override
        public Class<String> getInputType() {
            return String.class;
        }
    }
}

