/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.display;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.DisplayUpdatedEvent;
import org.scijava.event.EventService;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.plugin.Parameter;

public abstract class AbstractDisplay<T>
extends AbstractRichPlugin
implements Display<T> {
    private final Class<T> type;
    private final ArrayList<T> objects;
    @Parameter(required=false)
    private EventService eventService;
    @Parameter(required=false)
    private DisplayService displayService;
    private boolean structureChanged;
    private String name;
    protected boolean isClosed = false;

    public AbstractDisplay(Class<T> type) {
        this.type = type;
        this.objects = new ArrayList();
    }

    protected void rebuild() {
        this.structureChanged = true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(": type=" + this.type);
        sb.append(", name=" + this.name);
        sb.append(", objects={");
        boolean first = true;
        for (T object : this.objects) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(object);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean canDisplay(Class<?> c) {
        return this.type.isAssignableFrom(c);
    }

    @Override
    public void display(Object o) {
        this.checkObject(o);
        Object typedObj = o;
        this.add((T)typedObj);
    }

    @Override
    public void update() {
        if (this.eventService != null && !this.isClosed) {
            this.eventService.publish(new DisplayUpdatedEvent(this, this.structureChanged ? DisplayUpdatedEvent.DisplayUpdateLevel.REBUILD : DisplayUpdatedEvent.DisplayUpdateLevel.UPDATE));
        }
        this.structureChanged = false;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        if (this.displayService != null && this.displayService.getActiveDisplay() == this) {
            this.displayService.setActiveDisplay(null);
        }
        if (this.eventService != null) {
            this.eventService.publish(new DisplayDeletedEvent(this));
        }
        this.isClosed = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void add(int index, T element) {
        this.objects.add(index, element);
        this.noteStructureChange();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean changed = this.objects.addAll(index, c);
        if (changed) {
            this.noteStructureChange();
        }
        return changed;
    }

    @Override
    public T get(int index) {
        return this.objects.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.objects.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.objects.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.objects.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.objects.listIterator(index);
    }

    @Override
    public T remove(int index) {
        T result = this.objects.remove(index);
        if (result != null) {
            this.noteStructureChange();
        }
        return result;
    }

    @Override
    public T set(int index, T element) {
        T result = this.objects.set(index, element);
        if (result != null) {
            this.noteStructureChange();
        }
        return result;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.objects.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(T o) {
        this.checkObject(o);
        boolean changed = this.objects.add(o);
        if (changed) {
            this.noteStructureChange();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T o : c) {
            this.checkObject(o);
        }
        boolean changed = this.objects.addAll(c);
        if (changed) {
            this.noteStructureChange();
        }
        return changed;
    }

    @Override
    public void clear() {
        boolean changed = this.objects.size() > 0;
        this.objects.clear();
        if (changed) {
            this.noteStructureChange();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.objects.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.objects.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.objects.iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = this.objects.remove(o);
        if (changed) {
            this.noteStructureChange();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.objects.removeAll(c);
        if (changed) {
            this.noteStructureChange();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.objects.retainAll(c);
        if (changed) {
            this.noteStructureChange();
        }
        return changed;
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public Object[] toArray() {
        return this.objects.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.objects.toArray(a);
    }

    protected void checkObject(Object o) {
        if (!this.canDisplay(o.getClass())) {
            String typeName = o.getClass().getName();
            throw new IllegalArgumentException("Unsupported type: " + typeName);
        }
        if (!this.canDisplay(o)) {
            throw new IllegalArgumentException("Unsupported object: " + o);
        }
    }

    protected void noteStructureChange() {
        this.structureChanged = true;
    }
}

