/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import org.scijava.util.BoolArray;
import org.scijava.util.ByteArray;
import org.scijava.util.CharArray;
import org.scijava.util.DoubleArray;
import org.scijava.util.FloatArray;
import org.scijava.util.IntArray;
import org.scijava.util.LongArray;
import org.scijava.util.ObjectArray;
import org.scijava.util.ShortArray;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    @SafeVarargs
    public static <T> T[] array(T ... values) {
        return values;
    }

    public static Collection<?> toCollection(Object value) {
        if (value == null || Collection.class.isAssignableFrom(value.getClass())) {
            return (Collection)value;
        }
        if (value instanceof char[]) {
            return new CharArray((char[])value);
        }
        if (value instanceof byte[]) {
            return new ByteArray((byte[])value);
        }
        if (value instanceof boolean[]) {
            return new BoolArray((boolean[])value);
        }
        if (value instanceof short[]) {
            return new ShortArray((short[])value);
        }
        if (value instanceof int[]) {
            return new IntArray((int[])value);
        }
        if (value instanceof long[]) {
            return new LongArray((long[])value);
        }
        if (value instanceof float[]) {
            return new FloatArray((float[])value);
        }
        if (value instanceof double[]) {
            return new DoubleArray((double[])value);
        }
        if (value instanceof Object[]) {
            return new ObjectArray<Object>((Object[])value);
        }
        ObjectArray<Object> list = new ObjectArray<Object>(Object.class);
        list.add(value);
        return list;
    }

    public static byte[] allocate(long ... sizes) throws IllegalArgumentException {
        if (sizes == null) {
            return null;
        }
        if (sizes.length == 0) {
            return new byte[0];
        }
        int total = ArrayUtils.safeMultiply32(sizes);
        return new byte[total];
    }

    public static int safeMultiply32(long ... sizes) throws IllegalArgumentException {
        if (sizes.length == 0) {
            return 0;
        }
        long total = 1L;
        for (long size : sizes) {
            if (size < 1L) {
                throw new IllegalArgumentException("Invalid array size: " + ArrayUtils.sizeAsProduct(sizes));
            }
            if ((total *= size) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Array size too large: " + ArrayUtils.sizeAsProduct(sizes));
        }
        return (int)total;
    }

    public static long safeMultiply64(long ... sizes) throws IllegalArgumentException {
        if (sizes.length == 0) {
            return 0L;
        }
        long total = 1L;
        for (long size : sizes) {
            if (size < 1L) {
                throw new IllegalArgumentException("Invalid array size: " + ArrayUtils.sizeAsProduct(sizes));
            }
            if (ArrayUtils.willOverflow(total, size)) {
                throw new IllegalArgumentException("Array size too large: " + ArrayUtils.sizeAsProduct(sizes));
            }
            total *= size;
        }
        return total;
    }

    public static boolean contains(byte[] array, byte value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(boolean[] array, boolean value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(char[] array, char value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(double[] array, double value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(float[] array, float value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(int[] array, int value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(long[] array, long value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(short[] array, short value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(Object[] array, Object value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static int indexOf(boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object value) {
        for (int i = 0; i < array.length; ++i) {
            if (!(value == null ? array[i] == null : value.equals(array[i]))) continue;
            return i;
        }
        return -1;
    }

    private static String sizeAsProduct(long ... sizes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (long size : sizes) {
            if (first) {
                first = false;
            } else {
                sb.append(" x ");
            }
            sb.append(size);
        }
        return sb.toString();
    }

    private static boolean willOverflow(long v1, long v2) {
        return Long.MAX_VALUE / v1 < v2;
    }
}

